/**
 * Description: CmAddGoodsWS接口
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2015-08-10 下午 17:06:04
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-08-10   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.impl;

import com.house365.beans.entity.CmAddGoodsEntity;
import com.house365.beans.system.QueryParams;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.ServiceRunException;
import com.house365.ws.beans.request.CmAddGoodsListRequest;
import com.house365.ws.beans.request.CmAddGoodsRequest;
import com.house365.ws.beans.response.CmAddGoodsListResponse;
import com.house365.ws.beans.response.CmAddGoodsResponse;
import com.house365.ws.interfaces.server.ICmAddGoods;
import com.house365.ws.service.interfaces.ICmAddGoodsService;
import com.house365.ws.system.ReturnResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * CmAddGoodsWS接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-08-10
 * @see
 * @since 1.0
 */
@Service("cmAddGoods")
public class CmAddGoodsImpl implements ICmAddGoods {
    /**
     * 日志记录器
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(CmAddGoodsImpl.class);

    /**
     * CmAddGoods服务对象
     */
    @Autowired
    private ICmAddGoodsService<CmAddGoodsEntity> cmAddGoodsService;

    /**
     * CmAddGoods列表查询
     *
     * @param request CmAddGoods列表查询请求
     * @return CmAddGoods列表查询响应
     */
    @Override
    public CmAddGoodsListResponse getCmAddGoodsList(CmAddGoodsListRequest request) {
        CmAddGoodsListResponse response = new CmAddGoodsListResponse();
        try {
            QueryParams<CmAddGoodsEntity> queryParams = new QueryParams<>(request.getSearchParams());
            queryParams.setPaging(request.getPaging());
            List<CmAddGoodsEntity> cmAddGoodss = cmAddGoodsService.queryByPage(queryParams);
            response.setPaging(queryParams.getPaging());
            response.setObjectList(cmAddGoodss);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 保存CmAddGoods
     *
     * @param request CmAddGoods请求
     * @return 保存CmAddGoods响应
     */
    @Override
    public CmAddGoodsResponse addCmAddGoods(CmAddGoodsRequest request) {
        CmAddGoodsResponse response = new CmAddGoodsResponse();
        try {
            CmAddGoodsEntity entity = request.getEntity();
            cmAddGoodsService.save(entity);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 删除CmAddGoods通过唯一标识
     *
     * @param id 唯一标识
     * @return 删除CmAddGoods响应
     */
    @Override
    public CmAddGoodsResponse deleteCmAddGoodsById(Integer id) {
        CmAddGoodsResponse response = new CmAddGoodsResponse();
        try {
            cmAddGoodsService.delete(id);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 修改CmAddGoods
     *
     * @param request 修改CmAddGoods请求
     * @return 修改CmAddGoods响应
     */
    @Override
    public CmAddGoodsResponse updateCmAddGoods(CmAddGoodsRequest request) {
        CmAddGoodsResponse response = new CmAddGoodsResponse();
        try {
            cmAddGoodsService.update(request.getEntity());
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 通过ID获取CmAddGoods
     *
     * @param id 唯一标识
     * @return 通过ID获取CmAddGoods响应
     */
    @Override
    public CmAddGoodsResponse getCmAddGoodsById(Integer id) {
        CmAddGoodsResponse response = new CmAddGoodsResponse();
        try {
            CmAddGoodsEntity entity = cmAddGoodsService.getById(id);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }


    /**
     * 以下均为自动生成
     */

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {
    }
}
