/**
 * Description: CmOrder数据访问接口
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2015-08-10 下午 17:06:17
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-08-10   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.dao.interfaces;

import java.util.List;

import com.house365.dao.system.interfaces.Dao;
import com.house365.beans.entity.CmOrderEntity;
import com.house365.beans.system.QueryParams;

/**
 * CmOrder数据访问接口<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-08-10
 * @see
 * @since 1.0
 */
public interface ICmOrderDao<T extends CmOrderEntity> extends Dao<T>{

    /**
     * 通过订单查询统计已经发送的商品数量
     * 功能描述: <br>
     * 〈功能详细描述〉
     *
     * @author yinchangming
     * @version [v1.0.0, 2015年8月12日]
     * @param queryParams
     * @return
     * @since [产品/模块版本](可选)
     */
    List<CmOrderEntity> getCmOrderStatisticsList(QueryParams<CmOrderEntity> queryParams);
}
