/**
 * Description: CmUser数据访问实现类
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2015-08-10 下午 17:06:21
 * <p/>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-08-10   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.dao.impl;

import com.house365.beans.entity.CmUserEntity;
import com.house365.beans.system.Page;
import com.house365.beans.system.QueryParams;
import com.house365.dao.system.impl.DefaultDaoImpl;
import com.house365.rest.context.CmConstant;
import com.house365.ws.dao.interfaces.ICmUserDao;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * CmUser数据访问实现类<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-08-10
 * @see
 * @since 1.0
 */
@Repository("cmUserDao")
public class CmUserDaoImpl extends DefaultDaoImpl<CmUserEntity> implements ICmUserDao<CmUserEntity> {

    /**
     * 查询没有手机号的用户列表
     *
     * @param queryParams 参数
     * @return
     */
    @Override
    public List<CmUserEntity> getPhoneMissList(QueryParams<?> queryParams) {
        Object count = this.getReadTemplate().queryForList(getStatement(), queryParams);
        return (List<CmUserEntity>) (count);
    }

    @Override
    public CmUserEntity getUserByUserId(Integer userId, String cityKey, Integer useridType) {
        Map<String, Object> param = new HashMap<>();
        param.put("EQ_userId", userId);
        //如果不是用户中心的用户，则需要城市字段
        if (CmConstant.USERID_TYPE_OTHER.equals(useridType)) {
            param.put("EQ_cityKey", cityKey);
        }
        param.put("EQ_useridType", useridType);
        QueryParams<CmUserEntity> queryParamUser = new QueryParams<>();
        queryParamUser.setSearchParams(param);
        queryParamUser.setPaging(new Page(1));
        List<CmUserEntity> list = this.queryByPage(queryParamUser);
        if (CollectionUtils.isNotEmpty(list)) {
            return list.get(0);
        } else {
            return null;
        }
    }

    /**
     * 累计所有积分不为NULL的用户数
     */
    @SuppressWarnings("deprecation")
    @Override
    public Integer countAllCreditsNotNull() {
        Object obj = getObject(getStatement(), null);
        if (obj == null) {
            return 0;
        }
        return Integer.parseInt(obj.toString());
    }

    @Override
    public Integer countDeviceInvite(String deviceId) {
        Object obj = getObject(getStatement(), deviceId);
        if (obj == null) {
            return 0;
        }
        return Integer.parseInt(obj.toString());
    }

    /**
     * 累计所有积分不为NULL的用户数
     */
    @SuppressWarnings("deprecation")
    @Override
    public Integer countAllRemainingCredits() {
        Object obj = getObject(getStatement(), null);
        if (obj == null) {
            return 0;
        }
        return Integer.parseInt(obj.toString());
    }

    /**
     * 修改会员积分 <br>
     *
     * @param userId
     * @see
     */
    @Override
    public void updateCredits(int userId, int credits) {
        Map<String, Object> params = new HashMap<>();
        params.put("userId", userId);
        params.put("credits", credits);
        this.update(getStatement("updateCredits"), params);
    }

    @Override
    public Map getUserCreditTask(String userId) {
        Object obj = getObject(getStatement(), userId);
        return (Map) obj;
    }

    @Override
    public CmUserEntity getUserEntity(String userId) {
        CmUserEntity user = null;
        Map<String, Object> qm = new HashMap<>();
        qm.put("EQ_userId", userId);
        QueryParams<CmUserEntity> queryParams = new QueryParams<>();
        queryParams.setSearchParams(qm);
        queryParams.setOrderColumn("id");
        queryParams.setPaging(new Page(1));
        List<CmUserEntity> userEntities = queryByPage(queryParams);
        if (userEntities != null && !userEntities.isEmpty()) {
            user = userEntities.get(0);
        }
        return user;
    }

    /**
     * 查询事业部榜单
     *
     * @param startTime
     * @param endTime
     * @return
     */
    @Override
    public List<CmUserEntity> selectRanksByDivision(final String startTime, final String endTime) {
        return this.getReadTemplate().queryForList(getStatement(), new HashMap<String, String>() {
            /**
             */
            private static final long serialVersionUID = 1L;

            {
                put("startTime", startTime);
                put("endTime", endTime);
            }
        });
    }

    /**
     * 查询个人榜单
     *
     * @param startTime
     * @param endTime
     * @return
     */
    @Override
    public List<CmUserEntity> selectRanksByInvite(final String startTime, final String endTime) {
        return this.getReadTemplate().queryForList(getStatement(), new HashMap<String, String>() {
            /**
             */
            private static final long serialVersionUID = 1L;

            {
                put("startTime", startTime);
                put("endTime", endTime);
            }
        });
    }

    /**
     * 查询个人推荐信息
     *
     * @param startTime
     * @param endTime
     * @return
     */
    @Override
    public CmUserEntity getRankByInvite(final Integer userId, final String startTime, final String endTime) {
        return (CmUserEntity) this.getReadTemplate().queryForObject(getStatement(), new HashMap<String, Object>() {
            /**
             */
            private static final long serialVersionUID = 1L;

            {
                put("userId", userId);
                put("startTime", startTime);
                put("endTime", endTime);
            }
        });
    }

}
