/**
 * Description: CmSmsCode数据访问实现类
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2015-07-06 下午 14:00:59
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-07-06   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.dao.impl;

import java.util.HashMap;
import java.util.Map;

import org.springframework.stereotype.Repository;

import com.house365.beans.entity.CmSmsCodeEntity;
import com.house365.dao.system.impl.DefaultDaoImpl;
import com.house365.ws.dao.interfaces.ICmSmsCodeDao;

/**
 * CmSmsCode数据访问实现类<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-07-06
 * @see
 * @since 1.0
 */
@Repository("cmSmsCodeDao")
public class CmSmsCodeDaoImpl extends DefaultDaoImpl<CmSmsCodeEntity> implements ICmSmsCodeDao<CmSmsCodeEntity>{
	/**
     * 
     * 根据手机号查询记录
     */
    @SuppressWarnings({"deprecation" })
    public CmSmsCodeEntity getByPhone(final String phone) {
        return (CmSmsCodeEntity) this.getReadTemplate().queryForObject(getStatement(),
                new HashMap<String, String>() {
                    private static final long serialVersionUID = 1L;
                    {
                        put("phone", phone);
                    }
                });
    }

    /**
     * 
     * 根据手机号查询该短信发送信息
     */
    @SuppressWarnings("unchecked")
    @Override
    public Map<String,Object> findAllSmsRecord(String phone) {
        return (Map<String, Object>)getObject(getStatement(), phone);
    }

    /**
     * 
     * 更新短信发送次数
     */
    @SuppressWarnings("deprecation")
    @Override
    public Integer recordSmsTimes(Map<String,Object> param) {
        return getReadTemplate().update(getStatement(), param);
    }

}
