/**
 * Description: CmCreditGoods数据访问实现类
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2015-08-10 下午 17:06:09
 * <p/>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-08-10   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.dao.impl;

import org.springframework.stereotype.Repository;
import com.house365.dao.system.impl.DefaultDaoImpl;

import com.house365.ws.dao.interfaces.ICmCreditGoodsDao;
import com.house365.beans.entity.CmCreditGoodsEntity;

import java.util.List;

/**
 * CmCreditGoods数据访问实现类<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-08-10
 * @see
 * @since 1.0
 */
@Repository("cmCreditGoodsDao")
public class CmCreditGoodsDaoImpl extends DefaultDaoImpl<CmCreditGoodsEntity> implements ICmCreditGoodsDao<CmCreditGoodsEntity> {


    @Override
    public void updateSortList() {
        this.update(getStatement("updateSortList"), null);
    }

    @Override
    public List<CmCreditGoodsEntity> getTodaySeckills() {
        return getReadTemplate().queryForList(getStatement());
    }

    @Override
    public void updatePromotionSort() {
        this.update(getStatement("updatePromotionSort"), null);
    }

}
