/**
 * Description: CmAssess数据访问实现类
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2015-12-29 上午 11:12:24
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-12-29   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.dao.impl;

import com.house365.beans.entity.CmCreditRecordEntity;
import com.house365.beans.system.QueryParams;
import org.apache.commons.collections.map.HashedMap;
import org.springframework.stereotype.Repository;
import com.house365.dao.system.impl.DefaultDaoImpl;

import com.house365.ws.dao.interfaces.ICmAssessDao;
import com.house365.beans.entity.CmAssessEntity;

import java.util.List;
import java.util.Map;

/**
 * CmAssess数据访问实现类<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-12-29
 * @see
 * @since 1.0
 */
@Repository("cmAssessDao")
public class CmAssessDaoImpl extends DefaultDaoImpl<CmAssessEntity> implements ICmAssessDao<CmAssessEntity> {

    @Override
    public List<CmAssessEntity> limitQuery(QueryParams<?> queryParams) {
        Object count = this.getReadTemplate().queryForList(getStatement(), queryParams);
        return (List<CmAssessEntity>) (count);
    }

    @Override
    public List<String> getClearIds() {
        return (List<String>) (this.getReadTemplate().queryForList(getStatement()));
    }

    @Override
    public Integer getMinIdByUserId(String userId) {
        return (Integer) this.getReadTemplate().queryForObject(getStatement(), userId);
    }

    @Override
    public void removeWaste(String userId, Integer minId) {
        Map<String, Object> parm = new HashedMap();
        parm.put("userId", userId);
        parm.put("minId", minId);
        this.getReadTemplate().delete(getStatement(), parm);
    }




}
