package com.house365.ws.dao.impl;

import java.util.Date;
import java.util.HashMap;
import java.util.List;

import org.springframework.stereotype.Component;

import com.house365.beans.po.BaseAttachment;
import com.house365.dao.system.impl.DefaultDaoImpl;
import com.house365.ws.dao.interfaces.IAttachmentDao;

@Component("attachmentDao")
public class AttachmentDaoImpl extends DefaultDaoImpl<BaseAttachment> implements
        IAttachmentDao<BaseAttachment> {
    /**
     * 通过resouceId查询
     */
    @SuppressWarnings({ "unchecked", "deprecation" })
    public List<BaseAttachment> getByResourceId(Integer resourceId) {
        return (List<BaseAttachment>) this.getReadTemplate().queryForList(getStatement(),resourceId);
    }
    /**
     * 根据resourceId和resouceType查询
     */
    @SuppressWarnings({ "deprecation", "unchecked" })
    public List<BaseAttachment> queryByResourceIdAndResouceType(final String resourceId,final String channel) {
        return (List<BaseAttachment>) this.getReadTemplate().queryForList(getStatement(),
                new HashMap<String, String>() {
            private static final long serialVersionUID = 1L;

            {
                put("resourceId", resourceId);
                put("channel", channel);
            }
        }
                
                );
    }

    /**
     * 获取数据库当前时间
     *
     * @return 数据库当前时间
     */
    @Override
    public Date getDbNow() {
        return (Date)this.getObject(getStatement(),null);
    }
    
    @SuppressWarnings("deprecation")
	@Override
	public void deleteAttachment(Integer resourceId) {
		getReadTemplate().delete(getStatement(), resourceId);
	}
    
    @SuppressWarnings("deprecation")
	@Override
	public void updateAttachmentResourceId(Integer resourceId) {
		getReadTemplate().update(getStatement(), resourceId);
	}
}
