/**
 * Description: CmSeckillRemindWS接口
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2015-11-29 下午 14:08:45
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-11-29   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.server;

import com.house365.rest.context.IService;
import com.house365.ws.beans.request.CmSeckillRemindListRequest;
import com.house365.ws.beans.request.CmSeckillRemindRequest;
import com.house365.ws.beans.response.CmSeckillRemindListResponse;
import com.house365.ws.beans.response.CmSeckillRemindResponse;


/**
 * CmSeckillRemindWS接口<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-11-29
 * @see
 * @since 1.0
 */
public interface ICmSeckillRemind extends IService{

    /**
     * CmSeckillRemind列表查询
     * 
     * @param request
     *            CmSeckillRemind列表查询请求
     * @return CmSeckillRemind列表查询响应
     */
    CmSeckillRemindListResponse getCmSeckillRemindList(
            CmSeckillRemindListRequest request);

    /**
     * 保存CmSeckillRemind
     * 
     * @param request
     *            CmSeckillRemind请求
     * @return 保存CmSeckillRemind响应
     */
    CmSeckillRemindResponse addCmSeckillRemind(CmSeckillRemindRequest request);

    /**
     * 删除CmSeckillRemind通过唯一标识
     * 
     * @param id
     *            唯一标识
     * @return 删除CmSeckillRemind响应
     */
    CmSeckillRemindResponse deleteCmSeckillRemindById(Integer id);

    /**
     * 修改CmSeckillRemind
     * 
     * @param request
     *            修改CmSeckillRemind请求
     * @return 修改CmSeckillRemind响应
     */
    CmSeckillRemindResponse updateCmSeckillRemind(
            CmSeckillRemindRequest request);

    /**
     * 通过ID获取CmSeckillRemind
     * 
     * @param id
     *            唯一标识
     * @return 通过ID获取CmSeckillRemind响应
     */
    CmSeckillRemindResponse getCmSeckillRemindById(Integer id);
}
