/**
 * Description: CmSeckillBookedWS接口
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2015-11-29 下午 14:08:43
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-11-29   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.server;

import com.house365.rest.context.IService;
import com.house365.ws.beans.request.CmSeckillBookedListRequest;
import com.house365.ws.beans.request.CmSeckillBookedRequest;
import com.house365.ws.beans.response.CmSeckillBookedListResponse;
import com.house365.ws.beans.response.CmSeckillBookedResponse;


/**
 * CmSeckillBookedWS接口<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-11-29
 * @see
 * @since 1.0
 */
public interface ICmSeckillBooked extends IService{

    /**
     * CmSeckillBooked列表查询
     * 
     * @param request
     *            CmSeckillBooked列表查询请求
     * @return CmSeckillBooked列表查询响应
     */
    CmSeckillBookedListResponse getCmSeckillBookedList(
            CmSeckillBookedListRequest request);

    /**
     * 保存CmSeckillBooked
     * 
     * @param request
     *            CmSeckillBooked请求
     * @return 保存CmSeckillBooked响应
     */
    CmSeckillBookedResponse addCmSeckillBooked(CmSeckillBookedRequest request);

    /**
     * 删除CmSeckillBooked通过唯一标识
     * 
     * @param id
     *            唯一标识
     * @return 删除CmSeckillBooked响应
     */
    CmSeckillBookedResponse deleteCmSeckillBookedById(Integer id);

    /**
     * 修改CmSeckillBooked
     * 
     * @param request
     *            修改CmSeckillBooked请求
     * @return 修改CmSeckillBooked响应
     */
    CmSeckillBookedResponse updateCmSeckillBooked(
            CmSeckillBookedRequest request);

    /**
     * 通过ID获取CmSeckillBooked
     * 
     * @param id
     *            唯一标识
     * @return 通过ID获取CmSeckillBooked响应
     */
    CmSeckillBookedResponse getCmSeckillBookedById(Integer id);

    /**
     * 通过商品id删除秒杀记录
     * 功能描述: <br>
     * 〈功能详细描述〉
     *
     * @author yinchangming
     * @version [v1.0.0, 2015年12月8日]
     * @param id
     * @since [产品/模块版本](可选)
     */
    void deleteCmSeckillBookedByGoodId(Integer id);
}
