/**
 * Description: 商品促销关联WS接口
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-09-01 上午 10:52:46
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-01   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.server;

import com.house365.rest.context.IService;
import com.house365.ws.beans.request.CmPromotionProductListRequest;
import com.house365.ws.beans.request.CmPromotionProductRequest;
import com.house365.ws.beans.response.CmPromotionProductListResponse;
import com.house365.ws.beans.response.CmPromotionProductResponse;

import java.util.List;


/**
 * 商品促销关联WS接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-01
 * @see
 * @since 1.0
 */
public interface ICmPromotionProduct extends IService {

    /**
     * 商品促销关联列表查询
     *
     * @param request 商品促销关联列表查询请求
     * @return 商品促销关联列表查询响应
     */
    CmPromotionProductListResponse getCmPromotionProductList(
        CmPromotionProductListRequest request
    );

    /**
     * 保存商品促销关联
     *
     * @param request 商品促销关联请求
     * @return 保存商品促销关联响应
     */
    CmPromotionProductResponse addCmPromotionProduct(CmPromotionProductRequest request);

    /**
     * 删除商品促销关联通过唯一标识
     *
     * @param id 唯一标识
     * @return 删除商品促销关联响应
     */
    CmPromotionProductResponse deleteCmPromotionProductById(Integer id);

    /**
     * 修改商品促销关联
     *
     * @param request 修改商品促销关联请求
     * @return 修改商品促销关联响应
     */
    CmPromotionProductResponse updateCmPromotionProduct(
        CmPromotionProductRequest request
    );

    /**
     * 通过ID获取商品促销关联
     *
     * @param id 唯一标识
     * @return 通过ID获取商品促销关联响应
     */
    CmPromotionProductResponse getCmPromotionProductById(Integer id);

    void updateStatus(List<String> productIds, int status);
}
