/**
 * Description: CmPraiseWS接口
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2015-08-10 下午 17:06:19
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-08-10   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.server;

import com.house365.rest.context.IService;
import com.house365.ws.beans.request.CmPraiseListRequest;
import com.house365.ws.beans.request.CmPraiseRequest;
import com.house365.ws.beans.response.CmPraiseListResponse;
import com.house365.ws.beans.response.CmPraiseResponse;


/**
 * CmPraiseWS接口<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-08-10
 * @see
 * @since 1.0
 */
public interface ICmPraise extends IService{

    /**
     * CmPraise列表查询
     * 
     * @param request
     *            CmPraise列表查询请求
     * @return CmPraise列表查询响应
     */
    CmPraiseListResponse getCmPraiseList(
            CmPraiseListRequest request);

    /**
     * 保存CmPraise
     * 
     * @param request
     *            CmPraise请求
     * @return 保存CmPraise响应
     */
    CmPraiseResponse addCmPraise(CmPraiseRequest request);

    /**
     * 删除CmPraise通过唯一标识
     * 
     * @param id
     *            唯一标识
     * @return 删除CmPraise响应
     */
    CmPraiseResponse deleteCmPraiseById(Integer id);

    /**
     * 修改CmPraise
     * 
     * @param request
     *            修改CmPraise请求
     * @return 修改CmPraise响应
     */
    CmPraiseResponse updateCmPraise(
            CmPraiseRequest request);

    /**
     * 通过ID获取CmPraise
     * 
     * @param id
     *            唯一标识
     * @return 通过ID获取CmPraise响应
     */
    CmPraiseResponse getCmPraiseById(Integer id);
}
