/**
 * Description: CmOrderWS接口
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2015-08-10 下午 17:06:17
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-08-10   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.server;

import com.house365.rest.context.IService;
import com.house365.ws.beans.request.CmOrderListRequest;
import com.house365.ws.beans.request.CmOrderRequest;
import com.house365.ws.beans.response.CmOrderListResponse;
import com.house365.ws.beans.response.CmOrderResponse;


/**
 * CmOrderWS接口<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-08-10
 * @see
 * @since 1.0
 */
public interface ICmOrder extends IService{

    /**
     * CmOrder列表查询
     * 
     * @param request
     *            CmOrder列表查询请求
     * @return CmOrder列表查询响应
     */
    CmOrderListResponse getCmOrderList(
            CmOrderListRequest request);

    /**
     * 保存CmOrder
     * 
     * @param request
     *            CmOrder请求
     * @return 保存CmOrder响应
     */
    CmOrderResponse addCmOrder(CmOrderRequest request);

    /**
     * 删除CmOrder通过唯一标识
     * 
     * @param id
     *            唯一标识
     * @return 删除CmOrder响应
     */
    CmOrderResponse deleteCmOrderById(Integer id);

    /**
     * 修改CmOrder
     * 
     * @param request
     *            修改CmOrder请求
     * @return 修改CmOrder响应
     */
    CmOrderResponse updateCmOrder(
            CmOrderRequest request);

    /**
     * 通过ID获取CmOrder
     * 
     * @param id
     *            唯一标识
     * @return 通过ID获取CmOrder响应
     */
    CmOrderResponse getCmOrderById(Integer id);

    /**
     * 查询订单中的累计数量
     * 功能描述: <br>
     * 〈功能详细描述〉
     *
     * @author yinchangming
     * @version [v1.0.0, 2015年8月12日]
     * @param listRequest
     * @return
     * @since [产品/模块版本](可选)
     */
    CmOrderListResponse getCmOrderStatisticsList(CmOrderListRequest listRequest);
}
