/**
 * Description: CmLotteryRuleWS接口
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2015-08-19 上午 11:24:24
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-08-19   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.server;

import com.house365.rest.context.IService;
import com.house365.ws.beans.request.CmLotteryRuleListRequest;
import com.house365.ws.beans.request.CmLotteryRuleRequest;
import com.house365.ws.beans.response.CmLotteryRuleListResponse;
import com.house365.ws.beans.response.CmLotteryRuleResponse;


/**
 * CmLotteryRuleWS接口<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-08-19
 * @see
 * @since 1.0
 */
public interface ICmLotteryRule extends IService{

    /**
     * CmLotteryRule列表查询
     * 
     * @param request
     *            CmLotteryRule列表查询请求
     * @return CmLotteryRule列表查询响应
     */
    CmLotteryRuleListResponse getCmLotteryRuleList(
            CmLotteryRuleListRequest request);

    /**
     * 保存CmLotteryRule
     * 
     * @param request
     *            CmLotteryRule请求
     * @return 保存CmLotteryRule响应
     */
    CmLotteryRuleResponse addCmLotteryRule(CmLotteryRuleRequest request);

    /**
     * 删除CmLotteryRule通过唯一标识
     * 
     * @param id
     *            唯一标识
     * @return 删除CmLotteryRule响应
     */
    CmLotteryRuleResponse deleteCmLotteryRuleById(Integer id);

    /**
     * 修改CmLotteryRule
     * 
     * @param request
     *            修改CmLotteryRule请求
     * @return 修改CmLotteryRule响应
     */
    CmLotteryRuleResponse updateCmLotteryRule(
            CmLotteryRuleRequest request);

    /**
     * 通过ID获取CmLotteryRule
     * 
     * @param id
     *            唯一标识
     * @return 通过ID获取CmLotteryRule响应
     */
    CmLotteryRuleResponse getCmLotteryRuleById(Integer id);
}
