/**
 * Description: CmInviteRecordWS接口
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2015-10-15 上午 09:33:17
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-10-15   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.server;

import com.house365.rest.context.IService;
import com.house365.ws.beans.request.CmInviteRecordListRequest;
import com.house365.ws.beans.request.CmInviteRecordRequest;
import com.house365.ws.beans.response.CmInviteRecordListResponse;
import com.house365.ws.beans.response.CmInviteRecordResponse;


/**
 * CmInviteRecordWS接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-10-15
 * @see
 * @since 1.0
 */
public interface ICmInviteRecord extends IService {

    /**
     * CmInviteRecord列表查询
     *
     * @param request
     *            CmInviteRecord列表查询请求
     * @return CmInviteRecord列表查询响应
     */
    CmInviteRecordListResponse getCmInviteRecordList(CmInviteRecordListRequest request);

    /**
     * 保存CmInviteRecord
     *
     * @param request
     *            CmInviteRecord请求
     * @return 保存CmInviteRecord响应
     */
    CmInviteRecordResponse addCmInviteRecord(CmInviteRecordRequest request);

    /**
     * 删除CmInviteRecord通过唯一标识
     *
     * @param id
     *            唯一标识
     * @return 删除CmInviteRecord响应
     */
    CmInviteRecordResponse deleteCmInviteRecordById(Integer id);

    /**
     * 修改CmInviteRecord
     *
     * @param request
     *            修改CmInviteRecord请求
     * @return 修改CmInviteRecord响应
     */
    CmInviteRecordResponse updateCmInviteRecord(CmInviteRecordRequest request);

    /**
     * 通过ID获取CmInviteRecord
     *
     * @param id
     *            唯一标识
     * @return 通过ID获取CmInviteRecord响应
     */
    CmInviteRecordResponse getCmInviteRecordById(Integer id);
}
