/**
 * Description: CmHouseCommentReplyWS接口
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2015-08-11 上午 09:31:50
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-08-11   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.server;

import com.house365.rest.context.IService;
import com.house365.rest.parameter.House365RestResponse;
import com.house365.ws.beans.request.CmHouseCommentReplyListRequest;
import com.house365.ws.beans.request.CmHouseCommentReplyRequest;
import com.house365.ws.beans.response.CmHouseCommentReplyListResponse;
import com.house365.ws.beans.response.CmHouseCommentReplyResponse;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;


/**
 * CmHouseCommentReplyWS接口<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-08-11
 * @see
 * @since 1.0
 */
public interface ICmHouseCommentReply extends IService{

    /**
     * CmHouseCommentReply列表查询
     * 
     * @param request
     *            CmHouseCommentReply列表查询请求
     * @return CmHouseCommentReply列表查询响应
     */
    CmHouseCommentReplyListResponse getCmHouseCommentReplyList(
            CmHouseCommentReplyListRequest request);

    /**
     * 保存CmHouseCommentReply
     * 
     * @param request
     *            CmHouseCommentReply请求
     * @return 保存CmHouseCommentReply响应
     */
    CmHouseCommentReplyResponse addCmHouseCommentReply(CmHouseCommentReplyRequest request);

    /**
     * 删除CmHouseCommentReply通过唯一标识
     * 
     * @param id
     *            唯一标识
     * @return 删除CmHouseCommentReply响应
     */
    CmHouseCommentReplyResponse deleteCmHouseCommentReplyById(Integer id);

    /**
     * 修改CmHouseCommentReply
     * 
     * @param request
     *            修改CmHouseCommentReply请求
     * @return 修改CmHouseCommentReply响应
     */
    CmHouseCommentReplyResponse updateCmHouseCommentReply(
            CmHouseCommentReplyRequest request);

    /**
     * 通过ID获取CmHouseCommentReply
     * 
     * @param id
     *            唯一标识
     * @return 通过ID获取CmHouseCommentReply响应
     */
    CmHouseCommentReplyResponse getCmHouseCommentReplyById(Integer id);

    @Transactional(readOnly = false, propagation = Propagation.REQUIRED, rollbackFor = {Exception.class})
    House365RestResponse checkHouseComment(String commentIds, String op) throws Exception;

    //Integer delete
}
