/**
 * Description: 只包含楼盘和经纪人评论删除后的扣分WS接口
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2015-08-10 下午 17:06:10
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-08-10   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.server;

import com.house365.rest.context.IService;
import com.house365.ws.beans.request.CmCreditRemoveRecordListRequest;
import com.house365.ws.beans.request.CmCreditRemoveRecordRequest;
import com.house365.ws.beans.response.CmCreditRemoveRecordListResponse;
import com.house365.ws.beans.response.CmCreditRemoveRecordResponse;


/**
 * 只包含楼盘和经纪人评论删除后的扣分WS接口<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-08-10
 * @see
 * @since 1.0
 */
public interface ICmCreditRemoveRecord extends IService{

    /**
     * 只包含楼盘和经纪人评论删除后的扣分列表查询
     * 
     * @param request
     *            只包含楼盘和经纪人评论删除后的扣分列表查询请求
     * @return 只包含楼盘和经纪人评论删除后的扣分列表查询响应
     */
    CmCreditRemoveRecordListResponse getCmCreditRemoveRecordList(
            CmCreditRemoveRecordListRequest request);

    /**
     * 保存只包含楼盘和经纪人评论删除后的扣分
     * 
     * @param request
     *            只包含楼盘和经纪人评论删除后的扣分请求
     * @return 保存只包含楼盘和经纪人评论删除后的扣分响应
     */
    CmCreditRemoveRecordResponse addCmCreditRemoveRecord(CmCreditRemoveRecordRequest request);

    /**
     * 删除只包含楼盘和经纪人评论删除后的扣分通过唯一标识
     * 
     * @param id
     *            唯一标识
     * @return 删除只包含楼盘和经纪人评论删除后的扣分响应
     */
    CmCreditRemoveRecordResponse deleteCmCreditRemoveRecordById(Integer id);

    /**
     * 修改只包含楼盘和经纪人评论删除后的扣分
     * 
     * @param request
     *            修改只包含楼盘和经纪人评论删除后的扣分请求
     * @return 修改只包含楼盘和经纪人评论删除后的扣分响应
     */
    CmCreditRemoveRecordResponse updateCmCreditRemoveRecord(
            CmCreditRemoveRecordRequest request);

    /**
     * 通过ID获取只包含楼盘和经纪人评论删除后的扣分
     * 
     * @param id
     *            唯一标识
     * @return 通过ID获取只包含楼盘和经纪人评论删除后的扣分响应
     */
    CmCreditRemoveRecordResponse getCmCreditRemoveRecordById(Integer id);
}
