/**
 * Description: CmCreditRecordWS接口
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2015-08-14 上午 09:30:51
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-08-14   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.server;

import java.util.List;
import java.util.Map;

import com.house365.beans.entity.CmCreditRecordEntity;
import com.house365.beans.entity.CmUserEntity;
import com.house365.beans.system.QueryParams;
import com.house365.rest.context.IService;
import com.house365.ws.beans.request.CmCreditRecordListRequest;
import com.house365.ws.beans.request.CmCreditRecordRequest;
import com.house365.ws.beans.response.CmCreditRecordListResponse;
import com.house365.ws.beans.response.CmCreditRecordResponse;


/**
 * CmCreditRecordWS接口<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-08-14
 * @see
 * @since 1.0
 */
public interface ICmCreditRecord extends IService{

    /**
     * CmCreditRecord列表查询
     * 
     * @param request
     *            CmCreditRecord列表查询请求
     * @return CmCreditRecord列表查询响应
     */
    CmCreditRecordListResponse getCmCreditRecordList(
            CmCreditRecordListRequest request);

    /**
     * 保存CmCreditRecord
     * 
     * @param request
     *            CmCreditRecord请求
     * @return 保存CmCreditRecord响应
     */
    CmCreditRecordResponse addCmCreditRecord(CmCreditRecordRequest request);
    
    /**
     * 扣除指定commentId,ruleId的积分
     * @param 
     * @return 
     */
    public void removeCredit(Integer commentId,Integer ruleId);

    /**
     * 删除CmCreditRecord通过唯一标识
     * 
     * @param id
     *            唯一标识
     * @return 删除CmCreditRecord响应
     */
    CmCreditRecordResponse deleteCmCreditRecordById(Integer id);

    /**
     * 修改CmCreditRecord
     * 
     * @param request
     *            修改CmCreditRecord请求
     * @return 修改CmCreditRecord响应
     */
    CmCreditRecordResponse updateCmCreditRecord(
            CmCreditRecordRequest request);

    /**
     * 通过ID获取CmCreditRecord
     * 
     * @param id
     *            唯一标识
     * @return 通过ID获取CmCreditRecord响应
     */
    CmCreditRecordResponse getCmCreditRecordById(Integer id);

    CmCreditRecordListResponse getCmCreditRecordListWithCity(
        CmCreditRecordListRequest request
    );

    /**
     * 
     * 功能描述: 保存加精积分
     * 〈功能详细描述〉
     *
     * @author yinchangming
     * @version [v1.0.0, 2015年11月5日]
     * @param user
     * @param recordId 所对应记录id
     * @return
     * @since [产品/模块版本](可选)
     */
    CmCreditRecordEntity saveAddExcellentRecord(CmUserEntity user, int commonId) throws Exception;
    
    /**
     * 获取条件内积分总和
     * 
     */
    Integer getTotalCreditsByCondition(CmCreditRecordListRequest request);
    /**
     *  获取条件内用户数（不重复）
     * 
     */
    Integer getDistinctUserCount(CmCreditRecordListRequest request);


    CmCreditRecordListResponse statisticsByPage(CmCreditRecordListRequest request);

    Integer statisticsByPageCount(CmCreditRecordListRequest request);

}
