/**
 * Description: CmCreditGoodsWS接口
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2015-08-10 下午 17:06:09
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-08-10   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.server;

import com.house365.rest.context.IService;
import com.house365.ws.beans.request.CmCreditGoodsListRequest;
import com.house365.ws.beans.request.CmCreditGoodsRequest;
import com.house365.ws.beans.response.CmCreditGoodsListResponse;
import com.house365.ws.beans.response.CmCreditGoodsResponse;


/**
 * CmCreditGoodsWS接口<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-08-10
 * @see
 * @since 1.0
 */
public interface ICmCreditGoods extends IService{

    /**
     * CmCreditGoods列表查询
     * 
     * @param request
     *            CmCreditGoods列表查询请求
     * @return CmCreditGoods列表查询响应
     */
    CmCreditGoodsListResponse getCmCreditGoodsList(CmCreditGoodsListRequest request);

    /**
     * 保存CmCreditGoods
     * 
     * @param request
     *            CmCreditGoods请求
     * @return 保存CmCreditGoods响应
     */
    CmCreditGoodsResponse addCmCreditGoods(CmCreditGoodsRequest request);
    /**
     * 保存CmCreditGoods
     * 
     * @param request
     *            CmCreditGoods请求
     * @return 保存CmCreditGoods响应
     */
    CmCreditGoodsResponse addCmCreditGoodsAndExchangeCode(CmCreditGoodsRequest request);

    /**
     * 删除CmCreditGoods通过唯一标识
     * 
     * @param id
     *            唯一标识
     * @return 删除CmCreditGoods响应
     */
    CmCreditGoodsResponse deleteCmCreditGoodsById(Integer id);

    /**
     * 修改CmCreditGoods
     * 
     * @param request
     *            修改CmCreditGoods请求
     * @return 修改CmCreditGoods响应
     */
    CmCreditGoodsResponse updateCmCreditGoods(CmCreditGoodsRequest request);
    
    /**
     * 修改CmCreditGoods实物商品
     * 
     * @param request
     *            修改CmCreditGoods请求
     * @return 修改CmCreditGoods响应
     */
    CmCreditGoodsResponse updateCmCreditGoodsById(CmCreditGoodsRequest request);
    
    /**
     * 修改CmCreditGoods
     * 
     * @param request
     *            CmCreditGoods请求
     * @return 保存CmCreditGoods响应
     */
    CmCreditGoodsResponse updateCmCreditGoodsAndExchangeCode(CmCreditGoodsRequest request);

    /**
     * 通过ID获取CmCreditGoods
     * 
     * @param id
     *            唯一标识
     * @return 通过ID获取CmCreditGoods响应
     */
    CmCreditGoodsResponse getCmCreditGoodsById(Integer id);

    void updateSortList();

    void refreshTask();
}
