/**
 * Description: CmCommentReportWS接口
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2015-08-14 上午 09:19:21
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-08-14   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.server;

import com.house365.rest.context.IService;
import com.house365.ws.beans.request.CmCommentReportListRequest;
import com.house365.ws.beans.request.CmCommentReportRequest;
import com.house365.ws.beans.response.CmCommentReportListResponse;
import com.house365.ws.beans.response.CmCommentReportResponse;


/**
 * CmCommentReportWS接口<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-08-14
 * @see
 * @since 1.0
 */
public interface ICmCommentReport extends IService{

    /**
     * CmCommentReport列表查询
     * 
     * @param request
     *            CmCommentReport列表查询请求
     * @return CmCommentReport列表查询响应
     */
    CmCommentReportListResponse getCmCommentReportList(
            CmCommentReportListRequest request);

    /**
     * 保存CmCommentReport
     * 
     * @param request
     *            CmCommentReport请求
     * @return 保存CmCommentReport响应
     */
    CmCommentReportResponse addCmCommentReport(CmCommentReportRequest request);

    /**
     * 删除CmCommentReport通过唯一标识
     * 
     * @param id
     *            唯一标识
     * @return 删除CmCommentReport响应
     */
    CmCommentReportResponse deleteCmCommentReportById(Integer id);

    /**
     * 修改CmCommentReport
     * 
     * @param request
     *            修改CmCommentReport请求
     * @return 修改CmCommentReport响应
     */
    CmCommentReportResponse updateCmCommentReport(
            CmCommentReportRequest request);

    /**
     * 通过ID获取CmCommentReport
     * 
     * @param id
     *            唯一标识
     * @return 通过ID获取CmCommentReport响应
     */
    CmCommentReportResponse getCmCommentReportById(Integer id);
    
    Integer deleteCommentReport(String id,String isNoTalk,String isIgnored);
}
