/**
 * Description: CmBrokerLabelWS接口
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2015-08-10 下午 17:06:07
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-08-10   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.server;

import com.house365.rest.context.IService;
import com.house365.ws.beans.request.CmBrokerLabelListRequest;
import com.house365.ws.beans.request.CmBrokerLabelRequest;
import com.house365.ws.beans.response.CmBrokerLabelListResponse;
import com.house365.ws.beans.response.CmBrokerLabelResponse;


/**
 * CmBrokerLabelWS接口<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-08-10
 * @see
 * @since 1.0
 */
public interface ICmBrokerLabel extends IService{

    /**
     * CmBrokerLabel列表查询
     * 
     * @param request
     *            CmBrokerLabel列表查询请求
     * @return CmBrokerLabel列表查询响应
     */
    CmBrokerLabelListResponse getCmBrokerLabelList(
            CmBrokerLabelListRequest request);

    /**
     * 保存CmBrokerLabel
     * 
     * @param request
     *            CmBrokerLabel请求
     * @return 保存CmBrokerLabel响应
     */
    CmBrokerLabelResponse addCmBrokerLabel(CmBrokerLabelRequest request);

    /**
     * 删除CmBrokerLabel通过唯一标识
     * 
     * @param id
     *            唯一标识
     * @return 删除CmBrokerLabel响应
     */
    CmBrokerLabelResponse deleteCmBrokerLabelById(Integer id);

    /**
     * 修改CmBrokerLabel
     * 
     * @param request
     *            修改CmBrokerLabel请求
     * @return 修改CmBrokerLabel响应
     */
    CmBrokerLabelResponse updateCmBrokerLabel(
            CmBrokerLabelRequest request);

    /**
     * 通过ID获取CmBrokerLabel
     * 
     * @param id
     *            唯一标识
     * @return 通过ID获取CmBrokerLabel响应
     */
    CmBrokerLabelResponse getCmBrokerLabelById(Integer id);
}
