/**
 * Description: CmBrokerCommentWS接口
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2015-08-10 下午 17:06:06
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-08-10   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.server;

import com.house365.rest.context.IService;
import com.house365.ws.beans.request.CmBrokerCommentListRequest;
import com.house365.ws.beans.request.CmBrokerCommentRequest;
import com.house365.ws.beans.response.CmBrokerCommentListResponse;
import com.house365.ws.beans.response.CmBrokerCommentResponse;


/**
 * CmBrokerCommentWS接口<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-08-10
 * @see
 * @since 1.0
 */
public interface ICmBrokerComment extends IService{

    /**
     * CmBrokerComment列表查询
     * 
     * @param request
     *            CmBrokerComment列表查询请求
     * @return CmBrokerComment列表查询响应
     */
    CmBrokerCommentListResponse getCmBrokerCommentList(
            CmBrokerCommentListRequest request);

    /**
     * 保存CmBrokerComment
     * 
     * @param request
     *            CmBrokerComment请求
     * @return 保存CmBrokerComment响应
     */
    CmBrokerCommentResponse addCmBrokerComment(CmBrokerCommentRequest request);

    /**
     * 删除CmBrokerComment通过唯一标识
     * 
     * @param id
     *            唯一标识
     * @return 删除CmBrokerComment响应
     */
    CmBrokerCommentResponse deleteCmBrokerCommentById(Integer id);

    /**
     * 修改CmBrokerComment
     * 
     * @param request
     *            修改CmBrokerComment请求
     * @return 修改CmBrokerComment响应
     */
    CmBrokerCommentResponse updateCmBrokerComment(
            CmBrokerCommentRequest request);

    /**
     * 通过ID获取CmBrokerComment
     * 
     * @param id
     *            唯一标识
     * @return 通过ID获取CmBrokerComment响应
     */
    CmBrokerCommentResponse getCmBrokerCommentById(Integer id);
    
    /**
     * 通过ID获取CmBrokerComment
     * 
     * @param id
     *            唯一标识
     * @return 通过ID获取CmBrokerComment响应
     */
    Integer deleteBroker(String id,String isNoTalk);
    
}
