/**
 * Description: CmPromotionWS接口
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2016-08-26 下午 17:24:02
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-08-26   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.rest;

import com.house365.rest.context.IService;
import com.house365.ws.beans.request.CmPromotionListRequest;
import com.house365.ws.beans.request.CmPromotionRequest;
import com.house365.ws.beans.response.CmPromotionListResponse;
import com.house365.ws.beans.response.CmPromotionResponse;


/**
 * CmPromotionWS接口<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-08-26
 * @see
 * @since 1.0
 */
public interface ICmPromotion extends IService{

    /**
     * CmPromotion列表查询
     * 
     * @param request
     *            CmPromotion列表查询请求
     * @return CmPromotion列表查询响应
     */
    CmPromotionListResponse getCmPromotionList(
        CmPromotionListRequest request
    );

    /**
     * 保存CmPromotion
     * 
     * @param request
     *            CmPromotion请求
     * @return 保存CmPromotion响应
     */
    CmPromotionResponse addCmPromotion(CmPromotionRequest request);

    /**
     * 删除CmPromotion通过唯一标识
     * 
     * @param id
     *            唯一标识
     * @return 删除CmPromotion响应
     */
    CmPromotionResponse deleteCmPromotionById(Integer id);

    /**
     * 修改CmPromotion
     * 
     * @param request
     *            修改CmPromotion请求
     * @return 修改CmPromotion响应
     */
    CmPromotionResponse updateCmPromotion(
        CmPromotionRequest request
    );

    /**
     * 通过ID获取CmPromotion
     * 
     * @param id
     *            唯一标识
     * @return 通过ID获取CmPromotion响应
     */
    CmPromotionResponse getCmPromotionById(Integer id);
}
