package com.house365.ws.interfaces.rest;

import java.util.Map;

import com.house365.rest.context.IService;
import com.house365.rest.exception.ServiceRunException;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

/**
 * Created by 365 on 2015/12/29.
 */
public interface IAssessInterface extends IService {

    Object saveAssess(Map<String, Object> paramMap) throws ServiceRunException;

    Object assessResult(Map<String, Object> paramMap);

    Object saveAssessScore(Map<String, Object> paramMap) throws ServiceRunException;

    Object deleteAssess(Map<String, Object> paramMap);

    Object getAssess(Map<String, Object> paramMap) throws ServiceRunException;

    Object streetTrend(Map<String, Object> paramMap) throws ServiceRunException;

    /**
     * 二手房评估首页整合 API
     */
    Object queryAssessHome(Map<String, Object> paramMap);

    /**
     * 整合 API，获取可估价的二手房小区列表
     */
    Object queryAssessableBlocks(Map<String, Object> paramMap);

    /**
     * 获取区域走势
     */
    Object queryDistrictTrend(Map<String, Object> paramMap);

    Object getBlockByKeyword(Map<String, Object> paramMap) throws ServiceRunException;

    Object getBlockByDistance(Map<String, Object> paramMap) throws ServiceRunException;

    Object getDistrictForMap(Map<String, Object> paramMap) throws ServiceRunException;
}
