/**
 * Description: CmCreditGoods保存响应
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2015-08-10 下午 17:06:09
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-08-10   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.beans.response;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;

import com.house365.beans.entity.CmCreditGoodsEntity;
import com.house365.ws.system.House365Response;

/**
 * CmCreditGoods保存响应<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-08-10
 * @param <ConsultantBatchResult>
 * @see
 * @since 1.0
 */
public class CmCreditGoodsResponse extends House365Response {

    /**
     * 
     */
    private static final long serialVersionUID = 1L;

    /**
     * CmCreditGoods实体对象
     */
    private CmCreditGoodsEntity entity;
    
    //成功条数
    private int successNum;
    //失败条数
    private int failedNum;
    //上传的错误信息
    private List<ConsultantBatchResult> batchResults;

    /**
     * @return the entity
     */
    public CmCreditGoodsEntity getEntity() {
        return entity;
    }

    /**
     * @param entity
     *            the entity to set
     */
    public void setEntity(CmCreditGoodsEntity entity) {
        this.entity = entity;
    }

	public int getSuccessNum() {
		return successNum;
	}

	public void setSuccessNum(int successNum) {
		this.successNum = successNum;
	}

	public int getFailedNum() {
		return failedNum;
	}

	public void setFailedNum(int failedNum) {
		this.failedNum = failedNum;
	}

	public List<ConsultantBatchResult> getBatchResults() {
		return batchResults;
	}

	public void setBatchResults(List<ConsultantBatchResult> batchResults) {
		this.batchResults = batchResults;
	}
	
	
	public void incSuccessNum() {
        this.successNum++;
    }

    public void incFailedNum() {
        this.failedNum++;
    }
    
	 public void addBatchResult(ConsultantBatchResult result){
	        if(null==batchResults){
	            batchResults = new LinkedList<CmCreditGoodsResponse.ConsultantBatchResult>();
	        }
	        batchResults.add(result);
	 }
    
	static public class ConsultantBatchResult implements Serializable{
        private static final long serialVersionUID = 1L;
        private String name;
        private String code;
        private String msg;
        /**
         * @return the name
         */
        public String getName() {
            return name;
        }
        /**
         * @param name the name to set
         */
        public void setName(String name) {
            this.name = name;
        }
        /**
         * @return the code
         */
        public String getCode() {
            return code;
        }
        /**
         * @param mobile the code to set
         */
        public void setCode(String code) {
            this.code = code;
        }
        /**
         * @return the msg
         */
        public String getMsg() {
            return msg;
        }
        /**
         * @param msg the msg to set
         */
        public void setMsg(String msg) {
            this.msg = msg;
        }
        
    }
	
	/**
     * @return the serialversionuid
     */
    public static long getSerialversionuid() {
        return serialVersionUID;
    }
    
}