<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<!doctype html>
<html lang="en">

<head>
    <meta charset="UTF-8"/>
    <title>厉害了，我的淘房！</title>
    <link rel="stylesheet" href="http://frontend.house365.com/css/reset.css"/>
    <link rel="stylesheet" type="text/css" href="${ctx}/resources/ranks/style.css"/>
    <script src="http://libs.baidu.com/jquery/2.0.0/jquery.min.js"></script>
</head>

<body>
<div class="top">
    <div class="tit"></div>
</div>
<div class="container">
    <!--查询我的推广数量-->
    <div class="h-tit">
        <h3>
            <i class="icon-tri"></i>
            <span>查询我的推广数量</span>
        </h3>
    </div>
    <div class="from-cont">
        <div class="layer clearfix">
            <label class="layer-l fl">手机号码：</label>
            <div class="layer-r fl">
                <input class="inp" type="text" name="" id="phone" value=""/>
                <p class="on">请填写注册淘房时使用的手机号码哟！</p>
            </div>
        </div>
        <div class="layer clearfix">
            <label class="layer-l fl">验证码：</label>
            <div class="layer-r fl">
                <input type="hidden" id="isWait" value="false"/>
                <input class="inp small" type="text" name="" id="captcha" value=""/>
                <input type="text" id="captchaButton" class="inp-code" readonly="readonly" value="获取验证码"
                       onclick="sendCaptcha()"/>
            </div>
        </div>
        <div class="layer clearfix">
            <label class="layer-l fl">部门：</label>
            <div class="layer-r fl">
                <select id="division">
                    <option value="">请选择</option>
                    <c:forEach items="${dictionaries}" var="dictionary">
                        <option value="${dictionary.id}">${dictionary.dicValue}</option>
                    </c:forEach>
                </select>
            </div>
        </div>
        <div class="layer clearfix">
            <label class="layer-l fl">姓名：</label>
            <div class="layer-r fl">
                <input class="inp" type="text" id="userName" value=""/>
                <p id="bindError">这里是错误信息</p>
            </div>
        </div>
    </div>
    <a href="javascript:bindUserToDivision($('#captchaButton'))" class="btn-inquire">立即查询</a>
</div>

<script src="${ctx}/resources/script/jquery/jquery-1.10.2.min.js"></script>
<script type="text/javascript">
    var timer;
    //获取验证码
    function code(s, name) {
        timer = setInterval(function () {
            if (s <= 0) {
                clearInterval(timer);
                $(name).removeAttr('disabled').val('重新获取')
                $("#isWait").val(false);
                return;
            } else {
                $(name).attr('disabled', 'disabled').val('还剩 ' + s + ' s');
                --s;
            }
        }, 1000);
    }

    function showError(errmsg) {
        $("#bindError").addClass("on").text(errmsg);
    }

    function sendCaptcha() {
        var phone = $("#phone").val();
        if (phone == "" || phone == undefined) {
            showError("请填写手机号！");
            return false;
        }
        if (!(/^1[34578]\d{9}$/.test(phone))) {
            showError("手机号码有误，请重填！");
            return false;
        }
        var isWait = $("#isWait").val();
        if (isWait == "true") {
            return false;
        }
        $("#isWait").val(true);
        $.ajax({
            url: "${ctx}/ranks/sendCaptcha",
            type: "post",
            dateType: "json",
            data: {
                phone: phone
            },
            success: function (data) {
                if (data.resultCode == "10000") {
                    code(60, $("#captchaButton"));
                } else {
                    showError(data.resultMessage);
                }
            },
            error: function () {
                $("#isWait").val(false);
            }
        });
    }

    function bindUserToDivision(name) {
        var phone = $("#phone").val();
        if (phone == "" || phone == undefined) {
            showError("请填写手机号！");
            return false;
        }
        if (!(/^1[34578]\d{9}$/.test(phone))) {
            showError("手机号码有误，请重填！");
            return false;
        }

        var captcha = $("#captcha").val();
        if (captcha == "" || captcha == undefined) {
            showError("请填写验证码！");
            return false;
        }

        var division = $("#division").val();
        if (division == "" || division == undefined) {
            showError("请选择部门！");
            return false;
        }

        var userName = $("#userName").val();
        if (userName == "" || userName == undefined) {
            showError("请填写姓名！");
            return false;
        }
        $.ajax({
            url: "${ctx}/ranks/bindUserToDivision",
            type: "post",
            dateType: "json",
            data: {
                phone: phone,
                captcha: captcha,
                divisionId: division,
                divisionName: $("#division").find("option:selected").text(),
                userName: userName
            },
            success: function (data) {
                if (data.resultCode == "10000") {
                    window.location.href = "${ctx}/ranks/expand";
                } else if (data.resultCode == "-10004") {
                    showError(data.resultMessage);
                } else {
                    showError(data.resultMessage);
                    $("#isWait").val(false);
                    clearInterval(timer);
                    $(name).removeAttr('disabled').val('重新获取')
                }
            },
            error: function () {
                $("#isWait").val(false);
                clearInterval(timer);
                $(name).removeAttr('disabled').val('重新获取')
                $("#isWait").val(false);
            }
        });
    }
</script>
</body>

</html>