<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<!doctype html>
<html lang="en">

<head>
    <meta charset="UTF-8"/>
    <title>厉害了，我的淘房！</title>
    <link rel="stylesheet" href="http://frontend.house365.com/css/reset.css"/>
    <link rel="stylesheet" type="text/css" href="${ctx}/resources/ranks/style.css"/>
    <script src="${ctx}/resources/script/jquery/jquery-1.10.2.min.js"></script>
</head>

<body>
<div class="top">
    <div class="tit"></div>
</div>
<div class="container">
    <!--活动须知-->
    <div class="h-tit">
        <h3>
            <i class="icon-tri"></i>
            <span>活动须知</span>
        </h3>
    </div>
    <div class="cont">
        <p>1.本次活动仅限通过365淘房客户端“邀请码”邀请的用户数量，其他渠道下载或安装不纳入统计。</p>
        <p>2.团队榜单每日00:00:00进行更新，个人榜单实时更新，数据到达会稍有延迟。如遇计数不准确，请刷新页面或等待片刻后继续查看。</p>
        <p>3.本季活动仅统计邀请时间在2017年10月1日至2017年12月31日期间的用户数量，季度奖将在每季度末次月3日进行公布，节假日顺延。</p>
        <p>4.活动所提供的季度类奖品和年度类奖品发放另行通知。</p>
        <p>5.凡通过非正常手段，例如使用软件、工具、刷榜平台等手段恶意增加邀请用户的同事，淘房事业部将保有且不限于清空个人邀请数据、禁止参与活动、全司通报公示等手段以维护此次活动的公平与公正。</p>
    </div>
    <a href="${ctx}/ranks/inquiry" class="btn-inquire">查询我的推广数量</a>
    <p class="tips">*重要提示：请务必至少查询一次自己的推广数量，否则无法进入榜单哦~</p>
    <!--榜单-->
    <div class="tab-hd clearfix">
        <div class="tab-hd-tit fl on">
            <h4>团队榜单</h4>
            <p>当季数据，每日00：00更新</p>
        </div>
        <div class="tab-hd-tit fl">
            <h4>个人榜单</h4>
            <p>实时更新</p>
        </div>
        <div class="tab-hd-tit fl">
            <h4>历史团队榜单</h4>
        </div>
        <div class="tab-hd-tit fl mr0">
            <h4>历史个人榜单</h4>
        </div>
    </div>
    <div class="tab-bd">
        <div class="tab-bd-tit clearfix">
            <p class="rank fl">排名</p>
            <p class="name fl">团队名称</p>
            <p class="avg fr">人均推广</p>
        </div>
        <ul class="tab-list" id="divisionNow">
        </ul>
    </div>
    <div class="tab-bd" style="display: none;">
        <!--没有数据-->
        <%--<div class="img-no"><img src="${ctx}/resources/ranks/img-no.png" width="225" height="265"/></div>--%>
        <!--有数据-->
        <div class="tab-bd-tit clearfix">
            <p class="rank fl">排名</p>
            <p class="name new fl">姓名</p>
            <p class="department fl">部门</p>
            <p class="avg new fr">推广数量</p>
        </div>
        <ul class="tab-list" id="inviteNow">

        </ul>
    </div>
    <div class="tab-bd" style="display: none;">
        <div class="tab-bd-tit clearfix">
            <p class="rank fl">排名</p>
            <p class="name fl">团队名称</p>
            <p class="avg fr">人均推广</p>
        </div>
        <ul class="tab-list" id="divisionHistory">
        </ul>
    </div>
    <div class="tab-bd" style="display: none;">
        <div class="tab-bd-tit clearfix">
            <p class="rank fl">排名</p>
            <p class="name new fl">姓名</p>
            <p class="department fl">部门</p>
            <p class="avg new fr">推广数量</p>
        </div>
        <ul class="tab-list" id="inviteHistory">
        </ul>
    </div>
    <!--奖项设置-->
    <div class="h-tit right">
        <h3>
            <i class="icon-tri"></i>
            <span>奖项设置</span>
        </h3>
    </div>
    <div class="award clearfix">
        <div class="award-l fl">
            <h2><img src="${ctx}/resources/ranks/award-tit1.png"/></h2>
            <div class="award-cont">
                <img src="${ctx}/resources/ranks/award-1.png" alt=""/>
                <div class="award-tit">季度冠军团队奖</div>
                <div class="award-tags">条件：团队人均安装达10个，且人均安装量最高（无达标团队奖金滚入下季度）</div>
            </div>
            <div class="award-cont">
                <img src="${ctx}/resources/ranks/award-3.png" alt=""/>
                <div class="award-tit">年度冠军团队大奖</div>
                <div class="award-tags">
                    条件：<br/>
                    1、团队每季度人均安装达10个，且全年人均安装量最高<br/>
                    2、1-12月淘房APP新增用户次月留存率月度平均值不低于35%
                </div>
            </div>
        </div>
        <div class="award-r fr">
            <h2><img src="${ctx}/resources/ranks/award-tit2.png"/></h2>
            <div class="award-cont">
                <img src="${ctx}/resources/ranks/award-2.png" alt=""/>
                <div class="award-tit">季度个人奖</div>
                <div class="award-tags">
                    <p>专属精美奖品</p>
                    <p>条件：当季安装量前十名</p>
                </div>
            </div>
            <div class="award-cont">
                <img src="${ctx}/resources/ranks/award-4.png" alt=""/>
                <div class="award-tit">年度个人大奖</div>
                <div class="award-tags">
                    <p>丰厚奖金及标杆荣誉，有机会获得年度风尚三六五人提名</p>
                    <p>条件：年度安装量最高个人</p>
                </div>
            </div>
        </div>
    </div>
    <!--参与方法-->
    <div class="h-tit right">
        <h3>
            <i class="icon-tri"></i>
            <span>参与方法</span>
        </h3>
    </div>
    <div class="method"><img src="${ctx}/resources/ranks/img-step.png" alt=""/></div>
</div>
<!--footer-->
<div class="footer">
    <div class="container mb-none">
        <div class="h-tit white">
            <h3>
                <i class="icon-tri"></i>
                <span>活动目的</span>
            </h3>
        </div>
        <div class="clearfix">
            <dl class="purpose-dl fl">
                <dt>增长之年 奠基之年</dt>
                <dd>17年企业文化关键词</dd>
            </dl>
            <dl class="purpose-dl fl">
                <dt>全情投入+实现双赢</dt>
                <dd>助力各站发展移动用户，提高平台影响力</dd>
            </dl>
            <dl class="purpose-dl fr">
                <dt>拥抱变化+修炼内功</dt>
                <dd>使事业部同仁加深产品认识，明确用户需求</dd>
            </dl>
        </div>
        <div class="infos clearfix">
            <ul class="fl">
                <li>【活动主办】 365淘房事业部</li>
                <li>【联合主办】 三六五学院、集团人力资源中心、集团品牌部</li>
                <li>【活动范围】 淘房事业部/分站</li>
            </ul>
            <ul class="fr">
                <li>【活动时间】 2017年4月1日——12月31日</li>
                <li>【活动形式】 团队PK赛+个人挑战赛</li>
                <li>【推广形式】 自由发挥，形式不限</li>
            </ul>
        </div>
        <p class="copyright">本活动最终解释权归365淘房事业部所有</p>
    </div>
</div>
</body>
<script type="text/html" id="ranksTemplate">
    {{if ranks.length !=0}}
    {{each ranks as rank index}}
    <li class="clearfix">
        <p class="rank fl">
            {{if index ==0}}
            <img src="${ctx}/resources/ranks/icon-one.png" width="34" height="50"/>
            {{else if index ==1}}
            <img src="${ctx}/resources/ranks/icon-two.png" width="34" height="50"/>
            {{else if index ==2}}
            <img src="${ctx}/resources/ranks/icon-three.png" width="34" height="50"/>
            {{else}}
            {{index+1}}
            {{/if}}
        </p>
        {{if type == '1' || type == '2'}}
        <p class="name fl">{{rank.name}}</p>
        <p class="avg fr">{{rank.inviteCount}}</p>
        {{/if}}
        {{if type == '3' || type == '4'}}
        <p class="name new fl">{{rank.name}}</p>
        <p class="department fl">{{rank.divisionName}}</p>
        <p class="avg new fr">{{rank.inviteCount}}</p>
        {{/if}}
    </li>
    {{/each}}
    {{else}}
    <!--没有数据-->
    <div class="img-no"><img src="${ctx}/resources/ranks/img-no.png" width="225" height="265"/></div>
    {{/if}}
</script>
<script type="text/javascript" src="${ctx}/resources/ranks/template.js"></script>
<script>

    $(function () {
        $('.tab-hd-tit').on('click', function () {
            $(this).addClass('on').siblings('.tab-hd-tit').removeClass('on');
            var idx = $(this).index();
            $('.tab-bd').eq(idx).show().siblings('.tab-bd').hide();
        })
        loadData();
    });
    function loadData() {
        $.ajax({
            url: "${ctx}/ranks/getRanksByType",
            type: "post",
            dateType: "json",
            data: {
                type: "1"
            },
            success: function (data) {
                var html = template('ranksTemplate', {
                    type: "1",
                    ranks: data
                });
                $("#divisionNow").append(html);
            }
        });
        $.ajax({
            url: "${ctx}/ranks/getRanksByType",
            type: "post",
            dateType: "json",
            data: {
                type: "2"
            },
            success: function (data) {
                var html = template('ranksTemplate', {
                    type: "2",
                    ranks: data
                });
                $("#divisionHistory").append(html);
            }
        });
        $.ajax({
            url: "${ctx}/ranks/getRanksByType",
            type: "post",
            dateType: "json",
            timeout: 5000,
            data: {
                type: "3"
            },
            success: function (data) {
                var html = template('ranksTemplate', {
                    type: "3",
                    ranks: data
                });
                $("#inviteNow").append(html);
            }
        });
        $.ajax({
            url: "${ctx}/ranks/getRanksByType",
            type: "post",
            dateType: "json",
            timeout: 50000,
            data: {
                type: "4"
            },
            success: function (data) {
                var html = template('ranksTemplate', {
                    type: "4",
                    ranks: data
                });
                $("#inviteHistory").append(html);
            }
        });
    }

    function getRanks(ranks) {
        var html = template('ranksTemplate', {
            ranks: ranks
        });
        $("#customers").append(html);
    }
</script>

</html>