<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>上架商品统计信息</title>
</head>
<body>
<%-- <div class="row${fluid}">
    <div class="span6">
        <h2 class="page-title">CmProductStat列表</h2>
    </div>
    <div class="span6 header_buttons">
        <a href="${ctx}/cmproductstat?action=create" class="btn blue pull-right"><i class="icon-plus"></i></a>
    </div>
</div> --%>

<!-- 面包屑 begin -->
<div class="row-fluid">
    <div class="span12">
        <ul class="breadcrumb">
            <!-- <li><a href="/house365-hmc-web/">首页</a> <span class="divider"></span></li> -->
            <li class="active"><span class="divider" style="color:#26a0da;font-weight:bold;">/</span>上架商品统计信息
            </li>
        </ul>
    </div>
</div>
<!-- 面包屑 begin -->

<ul class="nav nav-tabs">
    <li class="active">
        <a href="${ctx}/cmproductstat">列表</a>
    </li>
    <li><a href="${ctx}/cmproductstat/chart">图表</a></li>
</ul>

<div class="page-container">
    <div class="row${fluid}">
        <div class="span12">
            <form id="filterForm" class="form-inline filterForm" action="${ctx}/cmproductstat" method="get">
                <input type="text" class="datetime-picker span2 small" name="search_GTE_statDate" dateLte="#endUpdateTimeInput" id="startUpdateTimeInput"
                       value="${param['search_GTE_statDate']}" date-format="yyyy-mm-dd"  placeholder="开始时间"/>

                <input type="text" class="datetime-picker span2 small" name="search_LTE_andstatDate" id="endUpdateTimeInput" dateGte="#startUpdateTimeInput"
                       value="${param['search_LTE_andstatDate']}" date-format="yyyy-mm-dd"  placeholder="结束时间"/>

                <select class="span2" style="width:220px;height: 20px" name="search_EQ_city" id="citySelect">
                    <option value="">不限(站点)</option>
                    <c:forEach items="${cityList}" var="city">
                        <option value="<c:out value="${city.code}"/>" <c:if test="${param['search_EQ_city'] eq city.code }"> selected="selected"</c:if>><c:out value="${city.name}" /></option>
                    </c:forEach>
                </select>

                <div class="buttons pull-right" style="margin:3px 30px 0 0;">
                    <i class="icon-search icon-2x pointer" onclick="$('#filterForm').submit();" title="搜索"></i>
                    &nbsp;&nbsp;&nbsp;&nbsp;
                    <i class="icon-file icon-2x pointer" onclick="$('#filterForm').attr('action','${ctx}/cmproductstat/exportExcel');$('#filterForm').submit();$('#filterForm').attr('action','${ctx}/cmproductstat');" title="导出Excel"></i>
                    &nbsp;&nbsp;&nbsp;&nbsp;
                </div>
            </form>
        </div>
    </div>
    <table class="table table-striped table-advance table-hover">
        <thead>
        <tr>
            <th width="40" style="text-align:center"><input id="memberCheckAll" type="checkbox"
                                                            onclick="checkAll(this)"/></th>
            <th width="100">id</th>
            <th width="100">商品ID</th>
            <th width="100">商品名</th>
            <th width="100">期初库存</th>
            <th width="100">期末库存</th>
            <th width="100">日期</th>
            <th width="100">商品类型</th>
            <th width="100">城市</th>
            <th width="100">是否秒杀</th>
        </tr>
        </thead>
        <c:forEach items="${cmProductStats}" var="cmProductStat">
            <tr>
                <td nowrap="nowrap" style="text-align:center">
                    <input type="checkbox" name="memberCheck" value="${cmProductStat.id}" onclick="checkMember(this)"/>
                </td>
                <td nowrap="nowrap">
                    <a href="${ctx}/cmproductstat/${cmProductStat.id}"> <c:if
                            test="${null ne cmProductStat.id && '' ne cmProductStat.id}">
                        <c:out value="${cmProductStat.id}"/>
                    </c:if>
                        <c:if test="${null eq cmProductStat.id || '' eq cmProductStat.id}">
                            &nbsp;
                        </c:if>
                    </a>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne cmProductStat.productId && '' ne cmProductStat.productId}">
                        <c:out value="${cmProductStat.productId}"/>
                    </c:if>
                    <c:if test="${null eq cmProductStat.productId || '' eq cmProductStat.productId}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne cmProductStat.productName && '' ne cmProductStat.productName}">
                        <c:out value="${cmProductStat.productName}"/>
                    </c:if>
                    <c:if test="${null eq cmProductStat.productName || '' eq cmProductStat.productName}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">

                    <c:if test="${null ne cmProductStat.beginStock && '' ne cmProductStat.beginStock}">
                        <c:out value="${cmProductStat.beginStock}"/>
                    </c:if>
                    <c:if test="${null eq cmProductStat.beginStock || '' eq cmProductStat.beginStock}">
                        0
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne cmProductStat.endStock && '' ne cmProductStat.endStock}">
                        <c:out value="${cmProductStat.endStock}"/>
                    </c:if>
                    <c:if test="${null eq cmProductStat.endStock || '' eq cmProductStat.endStock}">
                        0
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne cmProductStat.statDate && '' ne cmProductStat.statDate}">
                        <c:out value="${cmProductStat.statDate}"/>
                    </c:if>
                    <c:if test="${null eq cmProductStat.statDate || '' eq cmProductStat.statDate}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:choose>
                        <c:when test="${cmProductStat.productType==1}">
                            虚拟
                        </c:when>
                        <c:when test="${cmProductStat.productType==0}">
                            实物
                        </c:when>
                        <c:otherwise>
                        </c:otherwise>
                    </c:choose>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne cmProductStat.cityName && '' ne cmProductStat.cityName}">
                        <c:out value="${cmProductStat.cityName}"/>
                    </c:if>
                    <c:if test="${null eq cmProductStat.cityName || '' eq cmProductStat.cityName}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:choose>
                        <c:when test="${cmProductStat.isSeckill==1}">
                            <strong style="color:red;">秒杀商品</strong>
                        </c:when>
                        <c:when test="${cmProductStat.isSeckill==0}">
                            普通商品
                        </c:when>
                        <c:otherwise>
                        </c:otherwise>
                    </c:choose>
                </td>
            </tr>
        </c:forEach>
    </table>
    <div class="row${fluid}">
        <house365:pagination page="${page}"/>
    </div>
</div>
<script type="text/javascript">

    //全选
    function checkAll(btn) {
        if (btn.checked) {
            for (i = 0; i < document.all("memberCheck").length; i++) {
                document.all("memberCheck")[i].checked = "checked";
            }
        }
        else {
            for (i = 0; i < document.all("memberCheck").length; i++) {
                document.all("memberCheck")[i].checked = "";
            }
        }
    }

    //单选
    function checkMember(btn) {
        if (btn.checked) {
            var checkAll = true;
            for (i = 0; i < document.all("memberCheck").length; i++) {
                if (document.all("memberCheck")[i].checked == false) {
                    checkAll = false;
                }
            }

            if (checkAll) {
                document.getElementById("memberCheckAll").checked = true;
            }
        }
        else {
            document.getElementById("memberCheckAll").checked = false;
        }
    }

    var deleteById = function (selectedId) {
        /*
         id为空则是多选  判断是否为空
         为空 提示选择
         不为空 确认后删除
         不为空单选确认后删除
         */
        if (selectedId == "") {
            for (i = 0; i < document.getElementsByName('memberCheck').length; i++) {
                if (document.getElementsByName('memberCheck')[i].checked) {
                    selectedId += document.getElementsByName('memberCheck')[i].value + ",";
                }
            }

            var str = "";
            if (selectedId != "") {
                str = selectedId.split(",");

                if (str[str.length - 1] == "") {
                    selectedId = selectedId.substring(0, selectedId.length - 1);
                }
            }
        }

        if (selectedId == "") {
            House365Util.createModal("删除公告", "请至少选择一条公告!", function () {
            });
        }
        else {
            House365Util.createModal("删除公告", "确定要删除该公告？", function () {
                $.ajax({
                    url: '${ctx}/cmproductstat/' + selectedId,
                    type: "DELETE",
                    success: function () {
                        window.location.reload();
                    }
                });
            });
        }

    };

</script>
</body>
</html>
