<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<!DOCTYPE html>
<head>
    <meta charset="utf-8">
    <title>上架商品统计信息</title>

    <link href="${static_common}/script/bootstrap/css/bootstrap.min.css"
          type="text/css" rel="stylesheet" />
</head>
<body>

<ul class="nav nav-tabs">
    <li>
        <a href="${ctx}/cmproductstat">列表</a>
    </li>
    <li class="active"><a href="${ctx}/cmproductstat/chart">图表</a></li>
</ul>

<!-- 为ECharts准备一个具备大小（宽高）的Dom -->
<div id="main" style="height:300px"></div>
<div id="main1" style="height:400px"></div>
<!-- ECharts单文件引入 -->
<script src="${static_common}/script/jquery/jquery-1.10.2.min.js"
        type="text/javascript"></script>
<script src="${static_common}/script/echarts_2.2.7/echarts.js"></script>
<script type="text/javascript">
    // 路径配置
    require.config({
        paths: {
            echarts: '${static_common}/script/echarts_2.2.7'
        }
    });

    // 使用
    require(
            [
                'echarts',
                'echarts/chart/pie',
                'echarts/chart/funnel'
            ],
            function (ec) {
                // 基于准备好的dom，初始化echarts图表
                var myChart = ec.init(document.getElementById('main'));

                var paiOption = {
                    title: {
                        text: '城市统计数据',
                        subtext: '商品数',
                        x: 'center'
                    },
                    tooltip: {
                        trigger: 'item',
                        formatter: "{a} <br/>{b} : {c} ({d}%)"
                    },
                    legend: {
                        orient: 'vertical',
                        x: 'left',
                        data: ${cityJson}
                    },
                    toolbox: {
                        show: true,
                        feature: {
                            mark: {show: true},
                            dataView: {show: true, readOnly: false},
                            magicType: {
                                show: true,
                                type: ['pie', 'funnel'],
                                option: {
                                    funnel: {
                                        x: '25%',
                                        width: '50%',
                                        funnelAlign: 'left',
                                        max: 1548
                                    }
                                }
                            },
                            restore: {show: true},
                            saveAsImage: {show: true}
                        }
                    },
                    calculable: true,
                    series: [
                        {
                            name: '统计站点',
                            type: 'pie',
                            radius: '55%',
                            center: ['50%', '60%'],
                            data: ${cityStat}
                        }
                    ]
                };

                // 为echarts对象加载数据
                myChart.setOption(paiOption);
                myChart.on("click", eConsole);
            }
    );

    function eConsole(param) {
        $.ajax({
            url: "${ctx}/cmproductstat/getCityStatByMonth",
            data: {cityName: param.name},
            type: "POST",
            dataType: "json",
            success: function (data) {
                var obj = eval(data);
                require(
                        [
                            'echarts',
                            'echarts/chart/line',
                            'echarts/chart/bar'
                        ],
                        function (ec) {
                            // 基于准备好的dom，初始化echarts图表
                            var myChart = ec.init(document.getElementById('main1'));

                            var lineOption = {
                                title: {
                                    text: '一月内商品库存数量变化',
                                    subtext: ''
                                },
                                tooltip: {
                                    trigger: 'axis'
                                },
                                legend: {
                                    data: ['商品数量']
                                },
                                toolbox: {
                                    show: true,
                                    feature: {
                                        mark: {show: true},
                                        dataView: {show: true, readOnly: false},
                                        magicType: {show: true, type: ['line', 'bar']},
                                        restore: {show: true},
                                        saveAsImage: {show: true}
                                    }
                                },
                                calculable: true,
                                xAxis: [
                                    {
                                        type: 'category',
                                        boundaryGap: false,
                                        data: eval(data.date)
                                    }
                                ],
                                yAxis: [
                                    {
                                        type: 'value',
                                        axisLabel: {
                                            formatter: '{value} 件'
                                        }
                                    }
                                ],
                                series: [
                                    {
                                        name: '最大数量',
                                        type: 'line',
                                        data: eval(data.productCount),
                                        markPoint: {
                                            data: [
                                                {type: 'max', name: '最大值'},
                                                {type: 'min', name: '最小值'}
                                            ]
                                        },
                                        markLine: {
                                            data: [
                                                {type: 'average', name: '平均值'}
                                            ]
                                        }
                                    }
                                ]
                            };

                            // 为echarts对象加载数据
                            myChart.setOption(lineOption);
                        }
                );


            },
            error: function () {

            },
            complete: function () {

            }
        });

    }

</script>
</body>
</html>
