<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>CmInviteRecord列表</title>
</head>
<body>

<!-- 面包屑 begin -->
<div class="row-fluid">
    <div class="span12">
        <ul class="breadcrumb">
            <!-- <li><a href="/house365-hmc-web/">首页</a> <span class="divider"></span></li> -->
            <li class="active"><span class="divider" style="color:#26a0da;font-weight:bold;">/</span>CmInviteRecord列表
            </li>
        </ul>
    </div>
</div>
<!-- 面包屑 begin -->

<div class="page-container">
    <div class="row${fluid}">
        <div class="span12">
            <form id="filterForm" class="form-inline filterForm" action="${ctx}/cminviterecord" method="get">
                <input type="text" class="span2 date datetime-picker"
                       placeholder="开始时间" value="${param['search_GTE_createTime']}"
                       name="search_GTE_createTime" title="开始时间">
                <input type="text"
                       class="span2 date datetime-picker" placeholder="结束时间" title="结束时间"
                       value="${param['search_LTE_andCreateTime']}"
                       name="search_LTE_andCreateTime">
                <input type="text" name="search_LIKE_id" value="${param['search_LIKE_id']}"
                       class="m-wrap small" placeholder="编号">
                <input type="text" name="search_LIKE_inviter" value="${param['search_LIKE_inviter']}"
                       class="m-wrap small" placeholder="邀请人user_id">
                <input type="text" name="search_LIKE_invitedUser" value="${param['search_LIKE_invitedUser']}"
                       class="m-wrap small" placeholder="被邀请人user_id">
                <input type="text" name="search_LIKE_invitedCode" value="${param['search_LIKE_invitedCode']}"
                       class="m-wrap small" placeholder="邀请码">
                <div class="buttons pull-right" style="margin-left:15px;">
                    <a href="${ctx}/cminviterecord?action=create" class="btn blue pull-right" title="新增"><i
                            class="icon-plus"></i></a>
                </div>
                <div class="buttons pull-right">
                    <a href="javascript:void(0);" onclick="deleteById('')" class="btn blue pull-right" title="删除"><i
                            class="icon-minus"></i></a>
                </div>
                <div class="buttons pull-right" style="margin:3px 30px 0 0;">
                    <i class="icon-search icon-2x pointer" onclick="$('#filterForm').submit();" title="搜索"></i>
                </div>
            </form>
        </div>
    </div>
    <table class="table table-striped table-advance table-hover">
        <thead>
        <tr>
            <th width="40" style="text-align:center">
                <input id="memberCheckAll" type="checkbox" onclick="checkAll(this)"/>
            </th>
            <th width="100">编号</th>
            <th width="100">邀请人user_id</th>
            <th width="100">被邀请人user_id</th>
            <th width="100">邀请码</th>
            <th width="100">创建时间</th>
            <th width="100">更新时间</th>
            <th width="150">操作</th>
        </tr>
        </thead>
        <c:forEach items="${cmInviteRecords}" var="cmInviteRecord">
            <tr>
                <td nowrap="nowrap" style="text-align:center">
                    <input type="checkbox" name="memberCheck" value="${cmInviteRecord.id}" onclick="checkMember(this)"/>
                </td>
                <td nowrap="nowrap">
                    <a href="${ctx}/cminviterecord/${cmInviteRecord.id}"> <c:if
                            test="${null ne cmInviteRecord.id && '' ne cmInviteRecord.id}">
                        <c:out value="${cmInviteRecord.id}"/>
                    </c:if>
                        <c:if test="${null eq cmInviteRecord.id || '' eq cmInviteRecord.id}">
                            &nbsp;
                        </c:if>
                    </a>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne cmInviteRecord.inviter && '' ne cmInviteRecord.inviter}">
                        <c:out value="${cmInviteRecord.inviter}"/>
                    </c:if>
                    <c:if test="${null eq cmInviteRecord.inviter || '' eq cmInviteRecord.inviter}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne cmInviteRecord.invitedUser && '' ne cmInviteRecord.invitedUser}">
                        <c:out value="${cmInviteRecord.invitedUser}"/>
                    </c:if>
                    <c:if test="${null eq cmInviteRecord.invitedUser || '' eq cmInviteRecord.invitedUser}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne cmInviteRecord.invitedCode && '' ne cmInviteRecord.invitedCode}">
                        <c:out value="${cmInviteRecord.invitedCode}"/>
                    </c:if>
                    <c:if test="${null eq cmInviteRecord.invitedCode || '' eq cmInviteRecord.invitedCode}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne cmInviteRecord.createTime && '' ne cmInviteRecord.createTime}">
                        <f:formatDate value='${cmInviteRecord.createTime}' pattern='yyyy-MM-dd HH:mm:ss'/>
                    </c:if>
                    <c:if test="${null eq cmInviteRecord.createTime || '' eq cmInviteRecord.createTime}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne cmInviteRecord.updateTime && '' ne cmInviteRecord.updateTime}">
                        <f:formatDate value='${cmInviteRecord.updateTime}' pattern='yyyy-MM-dd HH:mm:ss'/>
                    </c:if>
                    <c:if test="${null eq cmInviteRecord.updateTime || '' eq cmInviteRecord.updateTime}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <i class="icon-edit pointer icon-large"
                       onclick="window.location='${ctx}/cminviterecord/${cmInviteRecord.id}?action=edit'"></i>
                    &nbsp;&nbsp; <i
                        title="删除"
                        class="icon-minus pointer icon-large"
                        onclick="deleteById('${cmInviteRecord.id}')"> </i>
                </td>
            </tr>
        </c:forEach>
    </table>
    <div class="row${fluid}">
        <house365:pagination page="${page}"/>
    </div>
</div>
<script type="text/javascript">

    //全选
    function checkAll(btn) {
        if (btn.checked) {
            for (i = 0; i < document.all("memberCheck").length; i++) {
                document.all("memberCheck")[i].checked = "checked";
            }
        }
        else {
            for (i = 0; i < document.all("memberCheck").length; i++) {
                document.all("memberCheck")[i].checked = "";
            }
        }
    }

    //单选
    function checkMember(btn) {
        if (btn.checked) {
            var checkAll = true;
            for (i = 0; i < document.all("memberCheck").length; i++) {
                if (document.all("memberCheck")[i].checked == false) {
                    checkAll = false;
                }
            }

            if (checkAll) {
                document.getElementById("memberCheckAll").checked = true;
            }
        }
        else {
            document.getElementById("memberCheckAll").checked = false;
        }
    }

    var deleteById = function (selectedId) {
        /*
         id为空则是多选  判断是否为空
         为空 提示选择
         不为空 确认后删除
         不为空单选确认后删除
         */
        if (selectedId == "") {
            for (i = 0; i < document.getElementsByName('memberCheck').length; i++) {
                if (document.getElementsByName('memberCheck')[i].checked) {
                    selectedId += document.getElementsByName('memberCheck')[i].value + ",";
                }
            }

            var str = "";
            if (selectedId != "") {
                str = selectedId.split(",");

                if (str[str.length - 1] == "") {
                    selectedId = selectedId.substring(0, selectedId.length - 1);
                }
            }
        }

        if (selectedId == "") {
            House365Util.createModal("删除公告", "请至少选择一条公告!", function () {
            });
        }
        else {
            House365Util.createModal("删除公告", "确定要删除该公告？", function () {
                $.ajax({
                    url: '${ctx}/cminviterecord/' + selectedId,
                    type: "DELETE",
                    success: function () {
                        window.location.reload();
                    }
                });
            });
        }

    };

</script>
</body>
</html>
