<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>楼盘回复列表</title>
    <style type="text/css">

        #filterForm input {
            margin-top: 3px;
        }

        #filterForm div {
            margin-top: 3px;
        }

    </style>
</head>
<body>
<%-- <div class="row${fluid}">
    <div class="span6">
        <h2 class="page-title">CmHouseCommentReply列表</h2>
    </div>
    <div class="span6 header_buttons">
        <a href="${ctx}/cmhousecommentreply?action=create" class="btn blue pull-right"><i class="icon-plus"></i></a>
    </div>
</div> --%>

<!-- 面包屑 begin -->
<div class="row-fluid">
    <div class="span12">
        <ul class="breadcrumb">
            <!-- <li><a href="/house365-hmc-web/">首页</a> <span class="divider"></span></li> -->
            <li class="active"><span class="divider" style="color:#26a0da;font-weight:bold;">/</span>楼盘回复列表</li>
        </ul>
    </div>
</div>
<!-- 面包屑 begin -->

<div class="page-container">
    <div class="row${fluid}">
        <div class="span12">
            <form id="filterForm" class="form-inline filterForm" action="${ctx}/cmhousecommentreply" method="get">
                <input type="hidden" id="applyWhiteList" value="${applyWhiteList}"/>
                <input type="hidden" name="houseCommentReplyTag" value="houseCommentReplyTag"/>
                <c:if test="${1 eq userRole}">
                    <select class="span2" style="width:220px;height: 20px" name="search_EQ_cityKey" id="citySelect">
                        <option value="">不限(站点)</option>
                        <option value="zbu" <c:if
                                test="${param['search_EQ_cityKey'] eq 'zbu' }"> selected="selected"</c:if>>事业部
                        </option>
                        <c:forEach items="${cityList}" var="city">
                            <option value="<c:out value="${city.code}"/>" <c:if
                                    test="${param['search_EQ_cityKey'] eq city.code }"> selected="selected"</c:if>>
                                <c:out value="${city.name}"/></option>
                        </c:forEach>
                    </select>
                </c:if>
                <input type="text" name="search_EQ_criticPhone" value="${param['search_EQ_criticPhone']}"
                       class="m-wrap small" placeholder="回复人手机号" style="height: 20px">
                <!-- search_LIKE_criticPhone -->
                <input type="text" name="search_EQ_criticName" value="${param['search_EQ_criticName']}"
                       class="m-wrap small" placeholder="回复人姓名" style="height: 20px">
                <input type="text" name="search_EQ_commentId" value="${param['search_EQ_commentId']}"
                       class="m-wrap small" placeholder="评论ID" style="height: 20px">
                <c:if test="${not empty param['houseCommentTag'] }">
                    <input type="text" name="search_LIKE_content" value="${param['search_LIKE_criticContent']}"
                           class="m-wrap small" placeholder="评论关键字" style="height: 20px">
                </c:if>
                <c:if test="${empty param['houseCommentTag'] }">
                    <input type="text" name="search_LIKE_content" value="${param['search_LIKE_content']}"
                           class="m-wrap small" placeholder="回复关键字" style="height: 20px">
                </c:if>

                <input type="text"
                       class="datetime-picker span2" id="startTime" name="search_GTE_commentTimeStart"
                       value="${param['search_GTE_commentTimeStart']}"
                       date-format="yyyy-mm-dd hh:ii:ss" date-minView="month"
                       placeholder="回复开始时间" dateLte="#endTime">
                <input type="text"
                       class="datetime-picker span2" id="endTime" name="search_LTE_commentTimeEnd"
                       value="${param['search_LTE_commentTimeEnd']}" date-format="yyyy-mm-dd hh:ii:ss"
                       date-minView="month" placeholder="回复结束时间" class="input-large" dateGte="#startTime">
                <select class="span2" name="search_EQ_source"
                        data-placeholder="" style="width:220px;height: 40px">
                    <option value="">不限(评论来源)</option>
                    <option value="1" <c:if test="${param['search_EQ_source'] eq 1 }">selected="selected"</c:if>>APP
                    </option>
                    <option value="2" <c:if test="${param['search_EQ_source'] eq 2 }">selected="selected"</c:if>>WEB
                    </option>
                </select>
                <select class="span2" style="width:220px;height: 20px" onchange="changeComment(this)">
                    <option value="1">评论回复</option>
                    <option value="2">楼盘评论</option>
                </select>
                <select class="span2" name="search_EQ_isReaded"
                        data-placeholder="是否已读" style="width:220px;height: 40px">
                    <option value="">所有(是否已读)</option>
                    <option value="1" <c:if test="${param['search_EQ_isReaded'] eq 1 }">selected="selected"</c:if>>已读
                    </option>
                    <option value="0" <c:if test="${param['search_EQ_isReaded'] eq 0 }">selected="selected"</c:if>>未读
                    </option>
                </select>
                <br/>
                <%-- 状态:&nbsp;&nbsp;&nbsp;&nbsp;<select class="span2" name="search_EQ_isReaded"
                    data-placeholder="状态" style="width:220px;height: 40px">
                    <option value="">全部</option>
                    <option value="0" <c:if test="${param['search_EQ_isReaded'] eq 0 && param['search_EQ_isReaded'] ne ''}">selected="selected"</c:if>>未读</option>
                    <option value="1" <c:if test="${param['search_EQ_isReaded'] eq 1 }">selected="selected"</c:if>>已读</option>
                </select>
                    评分:&nbsp;&nbsp;&nbsp;&nbsp;<select class="span2" name="search_LIKE_averageScore"
                    data-placeholder="评分" style="width:220px;height: 40px">
                    <option value="">全部</option>
                    <option value="1" <c:if test="${param['search_LIKE_averageScore'] eq 1 }">selected="selected"</c:if>>1星</option>
                    <option value="2" <c:if test="${param['search_LIKE_averageScore'] eq 2 }">selected="selected"</c:if>>2星</option>
                    <option value="3" <c:if test="${param['search_LIKE_averageScore'] eq 3 }">selected="selected"</c:if>>3星</option>
                    <option value="4" <c:if test="${param['search_LIKE_averageScore'] eq 4 }">selected="selected"</c:if>>4星</option>
                    <option value="5" <c:if test="${param['search_LIKE_averageScore'] eq 5 }">selected="selected"</c:if>>5星</option>
                </select>
                   其他:&nbsp;&nbsp;&nbsp;&nbsp;<select class="span2" name="search_EQ_other"
                    data-placeholder="其他" style="width:220px;height: 40px">
                    <option value="">不限</option>
                    <option value="1" <c:if test="${param['search_EQ_other'] eq 1 }">selected="selected"</c:if>>有图</option>
                    <option value="2" <c:if test="${param['search_EQ_other'] eq 2 }">selected="selected"</c:if>>置顶</option>
                    <option value="3" <c:if test="${param['search_EQ_other'] eq 3 }">selected="selected"</c:if>>加精</option>
                    <option value="4" <c:if test="${param['search_EQ_other'] eq 4 }">selected="selected"</c:if>>举报</option>
                </select> --%>
                <div class="buttons pull-right" style="margin:3px 30px 0 0;">
                    <i class="icon-search icon-2x pointer" onclick="$('#filterForm').submit();" title="搜索"></i>
                </div>
            </form>
        </div>
    </div>
    <table class="table table-striped table-advance table-hover">
        <thead>
        <tr>
            <th width="40" style="text-align:center"><input id="commentCheckAll" type="checkbox"
                                                            onclick="checkAll(this)"/></th>
            <th width="100">评论ID</th>
            <th width="100">评论内容</th>
            <th width="100">回复人</th>
            <th width="100">回复内容</th>
            <th width="100">来源</th>
            <!-- <th width="100">点赞人数</th> -->
            <th width="100">回复时间</th>
            <th width="150">操作</th>
        </tr>
        </thead>
        <button class="btn blue" type="button" onclick="deleteById('',false)"><i
                class="icon"></i>&nbsp;批量删除
        </button>
        &nbsp;&nbsp;
        <button class="btn blue" type="button" onclick="setReaded()"><i
                class="icon"></i>&nbsp;批量标记已读
        </button>
        <!-- <button class="btn blue" type="button" onclick="deleteById('',true)"><i
              class="icon"></i>&nbsp;批量删除并禁言48小时</button> -->
        <c:forEach items="${cmHouseCommentReplys}" var="cmHouseCommentReply">
            <tr>
                <td nowrap="nowrap" style="text-align:center">
                    <input type="checkbox" id="${cmHouseCommentReply.id}"
                           criticPhone="${cmHouseCommentReply.criticPhone}" name="commentCheck"
                           value="${cmHouseCommentReply.id}"
                           onclick="checkComment(this)"/>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne cmHouseCommentReply.commentId && '' ne cmHouseCommentReply.commentId}">
                        <c:out value="${cmHouseCommentReply.commentId}"/>
                    </c:if>
                    <c:if test="${null eq cmHouseCommentReply.commentId || '' eq cmHouseCommentReply.commentId}">
                        &nbsp;
                    </c:if>
                </td>
                <td width="30%">
                    <c:if test="${null ne cmHouseCommentReply.commentContent && '' ne cmHouseCommentReply.commentContent}">
                        <c:out value="${cmHouseCommentReply.commentContent}"/>
                    </c:if>
                    <c:if test="${null eq cmHouseCommentReply.commentContent || '' eq cmHouseCommentReply.commentContent}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne cmHouseCommentReply.criticName && '' ne cmHouseCommentReply.criticName}">
                        <c:out value="${cmHouseCommentReply.criticName}"/>
                    </c:if>
                    <c:if test="${null eq cmHouseCommentReply.criticName || '' eq cmHouseCommentReply.criticName}">
                        &nbsp;
                    </c:if>
                    <br/>
                    <c:if test="${null ne cmHouseCommentReply.criticPhone && '' ne cmHouseCommentReply.criticPhone && cmHouseCommentReply.criticName ne cmHouseCommentReply.criticPhone}">
                        <c:out value="${cmHouseCommentReply.criticPhone}"/>
                    </c:if>
                    <c:if test="${null eq cmHouseCommentReply.criticPhone || '' eq cmHouseCommentReply.criticPhone}">
                        &nbsp;
                    </c:if>
                </td>
                <td width="30%">
                    <c:if test="${null ne cmHouseCommentReply.content && '' ne cmHouseCommentReply.content}">
                        <c:out value="${cmHouseCommentReply.content}"/>
                    </c:if>
                    <c:if test="${null eq cmHouseCommentReply.content || '' eq cmHouseCommentReply.content}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${0 eq cmHouseCommentReply.source}">
                        APP
                    </c:if>
                    <c:if test="${1 eq cmHouseCommentReply.source}">
                        WEB
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne cmHouseCommentReply.createTime && '' ne cmHouseCommentReply.createTime}">
                        <f:formatDate value='${cmHouseCommentReply.createTime}' pattern='yyyy-MM-dd HH:mm:ss'/>
                    </c:if>
                    <c:if test="${null eq cmHouseCommentReply.createTime || '' eq cmHouseCommentReply.createTime}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <a href="javascript:void(0);"
                       onclick="deleteById('${cmHouseCommentReply.id}',false,'${cmHouseCommentReply.criticPhone}')">删除</a>
                    <br/>
                    <a href="javascript:void(0);"
                       onclick="deleteById('${cmHouseCommentReply.id}',true,'${cmHouseCommentReply.criticPhone}')">删除并禁言48小时</a>
                    <br/>
                    <c:if test="${1 eq cmHouseCommentReply.isReaded}">
                        已读
                    </c:if>
                    <c:if test="${0 eq cmHouseCommentReply.isReaded || '' eq cmHouseCommentReply.isReaded || empty cmHouseCommentReply.isReaded}">
                        <a href="javascript:void(0);" onclick="setReadedSingle('${cmHouseCommentReply.id}')">标记已读</a>
                    </c:if>
                </td>
            </tr>
        </c:forEach>
    </table>
    <div class="row${fluid}">
        <house365:pagination page="${page}"/>
    </div>
</div>
<script type="text/javascript">

    $(function () {
        //默认选择城市
        $("#citySelect").val("${param['search_EQ_cityKey']}");
        $('#citySelect').trigger("chosen:updated");
    });

    //全选
    function checkAll(btn) {
        if (btn.checked) {
            if (document.all("commentCheck").length != undefined) {
                for (i = 0; i < document.all("commentCheck").length; i++) {
                    document.all("commentCheck")[i].checked = "checked";
                }
            }
            else {
                document.all("commentCheck").checked = "checked";
            }
        }
        else {
            if (document.all("commentCheck").length != undefined) {
                for (i = 0; i < document.all("commentCheck").length; i++) {
                    document.all("commentCheck")[i].checked = "";
                }
            }
            else {
                document.all("commentCheck").checked = "";
            }
        }
    }

    //单选
    function checkComment(btn) {
        if (btn.checked) {
            var checkAll = true;
            for (i = 0; i < document.all("commentCheck").length; i++) {
                if (document.all("commentCheck")[i].checked == false) {
                    checkAll = false;
                }
            }

            if (checkAll) {
                document.getElementById("commentCheckAll").checked = true;
            }
        }
        else {
            document.getElementById("commentCheckAll").checked = false;
        }
    }

    var deleteById = function (selectedId, isNoTalk, criticPhone) {
        /*
         id为空则是多选  判断是否为空
         为空 提示选择
         不为空 确认后删除
         不为空单选确认后删除
         */
        var applyWhiteList = $("#applyWhiteList").val().split(",");
        var arrlength = $("input[name=commentCheck]:checked").length;
        if (selectedId == "") {
            for (var i = 0; i < document.getElementsByName('commentCheck').length; i++) {
                if (document.getElementsByName('commentCheck')[i].checked) {
                    criticPhone = $("#" + document.getElementsByName('commentCheck')[i].value).attr("criticPhone");
                    if (applyWhiteList.indexOf(criticPhone) > -1) {
                        continue;
                    }
                    if (i == arrlength) {
                        selectedId += document.getElementsByName('commentCheck')[i].value;
                    } else {
                        selectedId += document.getElementsByName('commentCheck')[i].value + ",";
                    }
                }
            }
            criticPhone = "";
            var str = "";
            if (selectedId != "") {
                str = selectedId.split(",");

                if (str[str.length - 1] == "") {
                    selectedId = selectedId.substring(0, selectedId.length - 1);
                }
            }
        } else {
            arrlength = 1;
        }

        if (arrlength == 0) {
            House365Util.createModal("删除回复", "请至少选择一条回复!", function () {
            });
        } else {
            if (applyWhiteList.indexOf(criticPhone) > -1 || selectedId == "") {
                House365Util.createModal("提示", "该点评人在白名单中!", function () {
                });
                return;
            }
            var isNoTalkTip = "确定要删除这些回复吗？";
            if (isNoTalk) {
                isNoTalkTip = "确定删除并禁言48小时？";
            }
            House365Util.createModal("提示", isNoTalkTip, function () {
                $.ajax({
                    url: '${ctx}/cmhousecommentreply/' + selectedId + "?isGaged=" + isNoTalk,
                    type: "DELETE",
                    success: function () {
                        window.location.reload();
                    }
                });
            });
        }

    };

    //批量标记已读
    function setReaded() {
        var selectedId = "";
        for (i = 0; i < document.getElementsByName('commentCheck').length; i++) {
            if (document.getElementsByName('commentCheck')[i].checked) {
                selectedId += document.getElementsByName('commentCheck')[i].value + ",";
            }
        }

        var str = "";
        if (selectedId != "") {
            str = selectedId.split(",");

            if (str[str.length - 1] == "") {
                selectedId = selectedId.substring(0, selectedId.length - 1);
            }
        }

        if (selectedId == "") {
            House365Util.createModal("标记已读", "请至少选择一条点评!", function () {
            });
        }
        else {
            House365Util.createModal("标记已读", "确定要标记已读这些点评吗？", function () {
                $.ajax({
                    url: '${ctx}/cmhousecommentreply/setReaded',
                    type: "POST",
                    data: {"ids": selectedId},
                    success: function () {
                        window.location.reload();
                    }
                });
            });
        }
    }
    function setReadedSingle(singleSelectedId) {
        House365Util.createModal("标记已读", "确定要标记已读这条点评吗？", function () {
            $.ajax({
                url: '${ctx}/cmhousecommentreply/setReaded',
                type: "POST",
                data: {"ids": singleSelectedId},
                success: function () {
                    window.location.reload();
                }
            });
        });

    }

    //切换评论
    function changeComment(btn) {
        //alert(btn.value);
        if (btn.value == 2) {
            $("#filterForm").attr("action", "${ctx}/cmhousecomment");
            $("#filterForm").submit();
            //window.location = "/house365-cm-web/cmhousecomment";
        }
    }


</script>
</body>
</html>
