<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>楼盘点评列表</title>
    <style type="text/css">
        img {
            cursor: pointer;
        }

        #filterForm input {
            margin-top: 3px;
        }

        #filterForm div {
            margin-top: 3px;
        }

    </style>
    <script type="text/javascript" src="${ctx}/resources/customize/js/imageModal.js"></script>
</head>
<body>

<!-- 面包屑 begin -->
<div class="row-fluid">
    <div class="span12">
        <ul class="breadcrumb">
            <li class="active"><span class="divider" style="color:#26a0da;font-weight:bold;">/</span>楼盘点评列表</li>
        </ul>
    </div>
</div>
<!-- 面包屑 begin -->

<div class="page-container">
    <div class="row${fluid}">
        <div class="span12">
            <form id="filterForm" class="form-inline filterForm valid" action="${ctx}/cmhousecomment" method="get">
                <input type="hidden" id="applyWhiteList" value="${applyWhiteList}"/>
                <input type="hidden" name="houseCommentTag" value="houseCommentTag"/>
                <c:if test="${1 eq userRole}">
                    <select class="span2" style="width:220px;height: 20px" name="search_EQ_cityKey" id="citySelect">
                        <option value="">不限(站点)</option>
                        <option value="zbu" <c:if
                                test="${param['search_EQ_cityKey'] eq 'zbu' }"> selected="selected"</c:if>>事业部
                        </option>
                        <c:forEach items="${cityList}" var="city">
                            <option value="<c:out value="${city.code}"/>" <c:if
                                    test="${param['search_EQ_cityKey'] eq city.code }"> selected="selected"</c:if>>
                                <c:out value="${city.name}"/></option>
                        </c:forEach>
                    </select>
                </c:if>
                <input type="text" name="search_EQ_criticPhone" value="${param['search_EQ_criticPhone']}"
                       class="m-wrap small" placeholder="用户手机" style="height: 20px">
                <input type="text" name="search_EQ_criticName" value="${param['search_EQ_criticName']}"
                       class="m-wrap small" placeholder="用户名" style="height: 20px">

                <input type="text" name="search_LIKE_houseName" value="${param['search_LIKE_houseName']}"
                       class="m-wrap small" placeholder="楼盘名称" style="height: 20px">
                <select class="span2" style="width:220px;height: 20px" onchange="changeComment(this)">
                    <option value="0">楼盘点评</option>
                    <option value="1">点评回复</option>
                </select>
                <c:if test="${not empty param['houseCommentReplyTag'] }">
                    <input type="text" name="search_LIKE_criticContent" value="${param['search_LIKE_ontent']}"
                           class="m-wrap small" placeholder="点评关键字" style="height: 20px">
                </c:if>
                <c:if test="${empty param['houseCommentReplyTag'] }">
                    <input type="text" name="search_LIKE_criticContent" value="${param['search_LIKE_criticContent']}"
                           class="m-wrap small" placeholder="点评关键字" style="height: 20px">
                </c:if>

                <input type="text"
                       class="datetime-picker span2" name="search_GTE_commentTimeStart" dateLte="#endValidTimeInput"
                       id="startValidTimeInput"
                       value="${param['search_GTE_commentTimeStart']}"
                       date-format="yyyy-mm-dd hh:ii:ss" date-minView="month"
                       placeholder="点评开始时间">
                <input type="text"
                       class="datetime-picker span2" name="search_LTE_commentTimeEnd" id="endValidTimeInput"
                       dateGte="#startValidTimeInput"
                       value="${param['search_LTE_commentTimeEnd']}" date-format="yyyy-mm-dd hh:ii:ss"
                       date-minView="month" placeholder="点评结束时间" class="input-large">
                <select class="span2" name="search_EQ_isReaded"
                        data-placeholder="状态" style="width:220px;height: 40px">
                    <option value="">状态(不限)</option>
                    <option value="0"
                            <c:if test="${param['search_EQ_isReaded'] eq 0 && param['search_EQ_isReaded'] ne ''}">selected="selected"</c:if>>
                        未读
                    </option>
                    <option value="1" <c:if test="${param['search_EQ_isReaded'] eq 1 }">selected="selected"</c:if>>已读
                    </option>
                </select>
                <select class="span2" name="search_LIKE_averageScore"
                        data-placeholder="评分" style="width:220px;height: 40px">
                    <option value="">评分等级(不限)</option>
                    <option value="1."
                            <c:if test="${param['search_LIKE_averageScore'] eq '1.' }">selected="selected"</c:if>>1星
                    </option>
                    <option value="2."
                            <c:if test="${param['search_LIKE_averageScore'] eq '2.' }">selected="selected"</c:if>>2星
                    </option>
                    <option value="3."
                            <c:if test="${param['search_LIKE_averageScore'] eq '3.' }">selected="selected"</c:if>>3星
                    </option>
                    <option value="4."
                            <c:if test="${param['search_LIKE_averageScore'] eq '4.' }">selected="selected"</c:if>>4星
                    </option>
                    <option value="5"
                            <c:if test="${param['search_LIKE_averageScore'] eq '5.' }">selected="selected"</c:if>>5星
                    </option>
                </select>
                <select class="span2" name="search_EQ_other"
                        data-placeholder="其他" style="width:220px;height: 40px">
                    <option value="">其他标记(不限)</option>
                    <option value="1" <c:if test="${param['search_EQ_other'] eq 1 }">selected="selected"</c:if>>有图
                    </option>
                    <option value="2" <c:if test="${param['search_EQ_other'] eq 2 }">selected="selected"</c:if>>置顶
                    </option>
                    <option value="3" <c:if test="${param['search_EQ_other'] eq 3 }">selected="selected"</c:if>>加精
                    </option>
                    <option value="4" <c:if test="${param['search_EQ_other'] eq 4 }">selected="selected"</c:if>>举报
                    </option>
                </select>
                <select class="span2" name="search_EQ_source"
                        data-placeholder="点评来源" style="width:220px;height: 40px">
                    <option value="">点评来源(不限)</option>
                    <option value="0"
                            <c:if test="${!empty param['search_EQ_source'] and '0' eq param['search_EQ_source']}">selected="selected"</c:if>>
                        APP
                    </option>
                    <option value="1"
                            <c:if test="${!empty param['search_EQ_source'] and '1' eq param['search_EQ_source']}">selected="selected"</c:if>>
                        WEB
                    </option>
                </select>
                <select class="span2" name="search_EQ_checkStatus"
                        data-placeholder="其他" style="width:220px;height: 40px">
                    <option value="">审核状态</option>
                    <option value="0" <c:if test="${param['search_EQ_checkStatus'] eq '0' }">selected="selected"</c:if>>
                        未审核
                    </option>
                    <option value="1" <c:if test="${param['search_EQ_checkStatus'] eq '1' }">selected="selected"</c:if>>
                        已审核
                    </option>
                    <option value="2" <c:if test="${param['search_EQ_checkStatus'] eq '2' }">selected="selected"</c:if>>
                        审核未通过
                    </option>
                </select>
                &nbsp;&nbsp;&nbsp;&nbsp;
                <input id="isMute" name="search_EQ_mute" type="checkbox"
                       <c:if test="${!empty param['search_EQ_mute']}">checked</c:if>/>
                <strong>已禁言</strong>
                &nbsp;&nbsp;&nbsp;&nbsp;
                <input id="isUnCheckReply" name="search_EQ_unCheckReply" type="checkbox"
                       <c:if test="${!empty param['search_EQ_unCheckReply']}">checked</c:if>/>
                <strong>未审核回复</strong>
                <div class="buttons pull-right" style="margin:3px 30px 0 0;">
                    <i class="icon-search icon-2x pointer" onclick="$('#filterForm').submit();" title="搜索"></i>
                </div>
            </form>
        </div>
    </div>
    <button class="btn blue" type="button" onclick="deleteById('',false)"><i
            class="icon"></i>&nbsp;批量删除
    </button>
    &nbsp;
    <button class="btn blue" type="button" onclick="setReaded()"><i
            class="icon"></i>&nbsp;批量标记已读
    </button>
    &nbsp;
    <c:if test="${needCheck}">
        <button class="btn blue" type="button" onclick="batchCheck()"><i
                class="icon"></i>&nbsp;批量审核
        </button>
    </c:if>

    <table class="table table-striped table-advance table-hover">
        <thead>
        <tr>
            <th width="40" style="text-align:center"><input id="commentCheckAll" type="checkbox"
                                                            onclick="checkAll(this)"/></th>
            <th width="100">点评ID</th>
            <c:if test="${needCheck}">
                <th width="100">审核状态</th>
            </c:if>
            <th width="100">楼盘名称</th>
            <th width="100">点评内容</th>
            <th width="130">图片</th>
            <th width="100">评分</th>
            <th width="100">点评人</th>
            <th width="100">来源</th>
            <th width="100">时间</th>
            <th width="150">操作</th>
        </tr>
        </thead>
        <c:forEach items="${cmHouseComments}" var="cmHouseComment">
            <tr>
                <td nowrap="nowrap" style="text-align:center">
                    <input type="checkbox" id="${cmHouseComment.id}"
                           criticPhone="${cmHouseComment.criticPhone}"
                           name="commentCheck" value="${cmHouseComment.id}"
                           onclick="checkComment(this)"/>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne cmHouseComment.id && '' ne cmHouseComment.id}">
                        <c:out value="${cmHouseComment.id}"/>
                    </c:if>
                    <c:if test="${null eq cmHouseComment.id || '' eq cmHouseComment.id}">
                        &nbsp;
                    </c:if>
                </td>
                <c:if test="${needCheck}">
                    <td nowrap="nowrap">
                        <c:if test="${null ne cmHouseComment.checkStatus}">
                            <c:choose>
                                <c:when test="${cmHouseComment.checkStatus eq '0'}">
                                    未审核
                                </c:when>
                                <c:when test="${cmHouseComment.checkStatus eq '1'}">
                                    已审核
                                </c:when>
                                <c:when test="${cmHouseComment.checkStatus eq '2'}">
                                    审核未通过
                                </c:when>
                                <c:otherwise>
                                </c:otherwise>
                            </c:choose>
                        </c:if>
                        <c:if test="${null eq cmHouseComment.checkStatus}">
                            已审核&nbsp;
                        </c:if>
                    </td>
                </c:if>
                <td nowrap="nowrap">
                    <c:if test="${null ne cmHouseComment.houseName && '' ne cmHouseComment.houseName}">
                        <c:out value="${cmHouseComment.houseName}"/>
                    </c:if>
                    <c:if test="${null eq cmHouseComment.houseName || '' eq cmHouseComment.houseName}">
                        &nbsp;
                    </c:if>
                </td>
                <td>
                    <p style="width:300px;">${cmHouseComment.criticContent}</p>
                </td>
                <td nowrap="nowrap" style="width:200px;">
                    <c:forEach items="${cmHouseComment.picList}" var="criticPicture">
                        <img class="commentImage" src="${criticPicture}" style="height:50px;width:50px;margin:1px;">
                    </c:forEach>
                        <%-- <c:if test="${null ne cmHouseComment.criticPictures && '' ne cmHouseComment.criticPictures}">
                            <c:out value="${cmHouseComment.criticPictures}" />
                            <img src="${ctx}/resources/image/default.jpg" style="height: 50px" width="50px">
                            <img src="${ctx}/resources/image/default.jpg" style="height: 50px" width="50px">
                            <img src="${ctx}/resources/image/default.jpg" style="height: 50px" width="50px">
                            <img src="${ctx}/resources/image/default.jpg" style="height: 50px" width="50px">
                            <img src="${ctx}/resources/image/default.jpg" style="height: 50px" width="50px">
                        </c:if>
                        <c:if test="${null eq cmHouseComment.criticPictures || '' eq cmHouseComment.criticPictures}">
                            &nbsp;
                        </c:if> --%>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne cmHouseComment.averageScore && '' ne cmHouseComment.averageScore}">
                        <c:out value="${cmHouseComment.averageScore}"/>
                    </c:if>
                    <c:if test="${null eq cmHouseComment.averageScore || '' eq cmHouseComment.averageScore}">
                        &nbsp;
                    </c:if>
                    分
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne cmHouseComment.criticName && '' ne cmHouseComment.criticName}">
                        <c:out value="${cmHouseComment.criticName}"/>
                    </c:if>
                    <c:if test="${null eq cmHouseComment.criticName || '' eq cmHouseComment.criticName}">
                        &nbsp;
                    </c:if>
                    <br>
                    <c:if test="${null ne cmHouseComment.criticPhone && '' ne cmHouseComment.criticPhone}">
                        <c:out value="${cmHouseComment.criticPhone}"/>
                    </c:if>
                    <c:if test="${null eq cmHouseComment.criticPhone || '' eq cmHouseComment.criticPhone}">
                        &nbsp;
                    </c:if>
                    <c:if test="${fn:indexOf(applyWhiteList,cmHouseComment.criticPhone) >= 0 }">
                        (白名单)
                    </c:if>
                </td>

                <td nowrap="nowrap">
                    <c:if test="${0 eq cmHouseComment.source}">
                        APP
                    </c:if>
                    <c:if test="${1 eq cmHouseComment.source}">
                        WEB
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne cmHouseComment.commentDate && '' ne cmHouseComment.commentDate}">
                        <f:formatDate value='${cmHouseComment.commentDate}' pattern='yyyy-MM-dd HH:mm:ss'/>
                    </c:if>
                    <c:if test="${null eq cmHouseComment.commentDate || '' eq cmHouseComment.commentDate}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <a href="${ctx}/cmhousecomment/${cmHouseComment.id}">详情(${cmHouseComment.commentAmount})</a>
                    <br/>

                    <c:choose>
                        <c:when test="${cmHouseComment.checkStatus eq 0 or cmHouseComment.checkStatus eq 2}">
                            <a href="###"
                               onclick="checkThis('${cmHouseComment.id}')">审核</a>
                        </c:when>
                        <c:otherwise>
                        </c:otherwise>
                    </c:choose>

                    <c:if test="${1 eq cmHouseComment.isExcellent }">
                        <a href="###"
                           onclick="updateComment('${cmHouseComment.id}','','','2')">取消加精</a>
                    </c:if>
                    <c:if test="${0 eq cmHouseComment.isExcellent || 2 eq cmHouseComment.isExcellent || '' eq cmHouseComment.isExcellent || empty cmHouseComment.isExcellent}">
                        <a href="###"
                           onclick="updateComment('${cmHouseComment.id}','','','1')">加精</a>
                    </c:if>
                    <br/>
                    <c:if test="${1 eq cmHouseComment.isSticked}">
                        <a href="###"
                           onclick="updateComment('${cmHouseComment.id}','0','','')">取消置顶</a>
                    </c:if>
                    <c:if test="${0 eq cmHouseComment.isSticked || '' eq cmHouseComment.isSticked || empty cmHouseComment.isSticked}">
                        <a href="###"
                           onclick="updateComment('${cmHouseComment.id}','1','','')">置顶</a>
                        <a href="###"
                           onclick="updateComment('${cmHouseComment.id}','-1','','')">沉底</a>
                    </c:if>
                    <c:if test="${-1 eq cmHouseComment.isSticked}">
                        <a href="###"
                           onclick="updateComment('${cmHouseComment.id}','0','','')">取消沉底</a>
                    </c:if>

                        <%-- <label id="kickLab${cmBrokerComment.id}"></label> --%>

                    <br/>
                    <c:if test="${1 eq cmHouseComment.isReaded}">
                        已读
                    </c:if>
                    <c:if test="${0 eq cmHouseComment.isReaded || '' eq cmHouseComment.isReaded || empty cmHouseComment.isReaded}">
                        <a href="###" onclick="updateComment('${cmHouseComment.id}','','${cmHouseComment.isReaded }','')">标记已读</a>
                    </c:if>
                    <br/>
                    <a href="###" onclick="deleteById('${cmHouseComment.id}',false,'${cmHouseComment.criticPhone}')">删除</a>
                    <br/>

                    <c:choose>
                        <c:when test="${cmHouseComment.isDeleted gt 0 or cmHouseComment.cityId gt 0}">
                            已禁言(剩余
                            <c:if test="${cmHouseComment.isDeleted gt 0}">
                                ${cmHouseComment.isDeleted}小时
                            </c:if>
                            ${cmHouseComment.cityId}分钟)
                        </c:when>
                        <c:otherwise>
                            <c:if test="${fn:indexOf(applyWhiteList,cmHouseComment.criticPhone) < 0 }">
                                <a href="###" onclick="showForbid('${cmHouseComment.id}','${cmHouseComment.criticPhone}')">删除并禁言</a>
                            </c:if>
                        </c:otherwise>
                    </c:choose>

                </td>
            </tr>
        </c:forEach>
    </table>
</div>

<div class="row${fluid}">
    <house365:pagination page="${page}"/>
</div>


<div id="dialog" title="提示:" style="display: none;">
    <input type="hidden" id="delId" name="delId">
    <p>禁言时间:<input type="text" id="forbidHours" name="forbidHours" size="8">小时</p>
</div>

<div id="checkDialog" title="提示:" style="display: none;">
    请选择审核操作, 已审核通过的记录选择审核不通过不会生效。
</div>

<script type="text/javascript" src="${static_common}/script/jquery-ui-1.11.4.custom/jquery-ui.min.js"></script>

<script type="text/javascript">

    $(function () {
        //默认选择城市
        $("#citySelect").val("${param['search_EQ_cityKey']}");
        $('#citySelect').trigger("chosen:updated");


    });

    function batchCheck() {
        var selectedId = "";
        for (var i = 0; i < document.getElementsByName('commentCheck').length; i++) {
            if (document.getElementsByName('commentCheck')[i].checked) {
                selectedId += document.getElementsByName('commentCheck')[i].value + ",";
            }
        }

        var str = "";
        if (selectedId != "") {
            str = selectedId.split(",");

            if (str[str.length - 1] == "") {
                selectedId = selectedId.substring(0, selectedId.length - 1);
            }
        }

        if (selectedId == "") {
            House365Util.createModal("标记已读", "请至少选择一条点评!", function () {
            });
        }
        else {
            checkThis(selectedId);
        }

    }

    function checkThis(commentId) {
        $("#checkDialog").dialog({
            height: 200,
            width: 450,
            modal: true,
            closeOnEscape: false,
            resizable: false,
            autoOpen: false,
            buttons: {
                "审核通过": function () {
                    $("#checkDialog").dialog("close");
                    $.ajax({
                        url: '${ctx}/cmhousecomment/check/' + commentId + "?op=pass",
                        type: "GET",
                        success: function () {
                            window.location.reload();
                        }
                    });
                },
                "审核不通过": function () {
                    $("#checkDialog").dialog("close");
                    $.ajax({
                        url: '${ctx}/cmhousecomment/check/' + commentId + "?op=forbid",
                        type: "GET",
                        success: function () {
                            window.location.reload();
                        }
                    });
                },
                "关闭": function () {
                    $("#checkDialog").dialog("close");
                }
            }
        }).dialog("open");
    }

    function showForbid(commentId, criticPhone) {
        var applyWhiteList = $("#applyWhiteList").val().split(",");
        if (applyWhiteList.indexOf(criticPhone) > -1) {
            var bool = window.confirm("该点评人在白名单中,是否确认删除?");
            if (!bool) {
                return;
            }
        }
        $("#dialog").dialog({
            height: 200,
            width: 450,
            modal: true,
            closeOnEscape: false,
            resizable: false,
            autoOpen: false,
            open: function () {
                jQuery(".ui-dialog-titlebar", $("#dialog").parent()).hide();
                $("#dialog").parent().css({background: "#e40000", "font-weight": "bold", border: "none"});
                $("#dialog").css({background: "#e40000", color: "#ffffff"});
            },
            buttons: {
                "确认": function () {
                    if (!$.isNumeric($("#forbidHours").val())) {
                        alert("请输入数字!");
                    } else {
                        var isNoTalkTip = "确定删除并禁言" + $("#forbidHours").val() + "小时？";
                        House365Util.createModal("提示", isNoTalkTip, function () {
                            $.ajax({
                                url: '${ctx}/cmhousecomment/' + commentId + "?isNoTalk=true&forbidHours=" + $("#forbidHours").val(),
                                type: "DELETE",
                                success: function () {
                                    window.location.reload();
                                }
                            });
                        });
                    }
                },
                "关闭": function () {
                    $("#dialog").dialog("close");
                }
            }
        }).dialog("open");
    }

    //全选
    function checkAll(btn) {
        if (btn.checked) {
            if (document.all("commentCheck").length != undefined) {
                for (var i = 0; i < document.all("commentCheck").length; i++) {
                    document.all("commentCheck")[i].checked = "checked";
                }
            }
            else {
                document.all("commentCheck").checked = "checked";
            }
        }
        else {
            if (document.all("commentCheck").length != undefined) {
                for (var i = 0; i < document.all("commentCheck").length; i++) {
                    document.all("commentCheck")[i].checked = "";
                }
            }
            else {
                document.all("commentCheck").checked = "";
            }
        }
    }

    //单选
    function checkComment(btn) {
        if (btn.checked) {
            var checkAll = true;
            for (var i = 0; i < document.all("commentCheck").length; i++) {
                if (document.all("commentCheck")[i].checked == false) {
                    checkAll = false;
                }
            }

            if (checkAll) {
                document.getElementById("commentCheckAll").checked = true;
            }
        }
        else {
            document.getElementById("commentCheckAll").checked = false;
        }
    }

    var deleteById = function (selectedId, isNoTalk, criticPhone) {
        /*
         id为空则是多选  判断是否为空
         为空 提示选择
         不为空 确认后删除
         不为空单选确认后删除
         */
        var applyWhiteList = $("#applyWhiteList").val().split(",");

        var arrlength = $("input[name=commentCheck]:checked").length;
        if (selectedId == "") {
            var count = 0;
            for (var i = 0; i < document.getElementsByName('commentCheck').length; i++) {
                if (document.getElementsByName('commentCheck')[i].checked) {
                    criticPhone = $("#" + document.getElementsByName('commentCheck')[i].value).attr("criticPhone");
//                    if (applyWhiteList.indexOf(criticPhone) > -1) {
//                        continue;
//                    }
                    if (count == arrlength) {
                        selectedId += document.getElementsByName('commentCheck')[i].value;
                    } else {
                        selectedId += document.getElementsByName('commentCheck')[i].value + ",";
                    }
                } else {
                    count += 1;
                }
            }
            criticPhone = "";
            var str = "";
            if (selectedId != "") {
                str = selectedId.split(",");
                if (str[str.length - 1] == "") {
                    selectedId = selectedId.substring(0, selectedId.length - 1);
                }
            }
        } else {
            arrlength = 1;
        }

        if (arrlength == 0) {
            House365Util.createModal("删除点评", "请至少选择一条点评!", function () {
            });
        } else {
            if (applyWhiteList.indexOf(criticPhone) > -1 || selectedId == "") {
                var bool = window.confirm("点评人在白名单中,是否确认删除?");
                if (!bool) {
                    return;
                }
            }

            var isNoTalkTip = "确定删除选中的" + arrlength + "条点评吗？";
            if (isNoTalk) {
                isNoTalkTip = "确定删除并禁言48小时？";
            }
            House365Util.createModal("提示", isNoTalkTip, function () {
                $.ajax({
                    url: '${ctx}/cmhousecomment/' + selectedId + "?isNoTalk=" + isNoTalk,
                    type: "DELETE",
                    success: function () {
                        window.location.reload();
                    }
                });
            });
        }

    };

    //修改点评属性(置顶，已读)
    function updateComment(commentId, isKicked, isReaded, isExcellent) {


        var text = "";

        if (isKicked == 1)//取消置顶
        {
            text = "确定要将此评论置顶吗？";
            House365Util.createModal("提示", text, function () {
                $.ajax({
                    url: '${ctx}/cmhousecomment/' + commentId + '?action=updateComment&isKicked=' + isKicked + '&isReaded=' + isReaded + '&isExcellent=' + isExcellent,
                    type: "POST",
                    success: function () {
                        window.location.reload();
                    }
                });
            });

        } else if (isKicked == -1) {

            text = "确定要将此评论沉底吗？";
            House365Util.createModal("提示", text, function () {
                $.ajax({
                    url: '${ctx}/cmhousecomment/' + commentId + '?action=updateComment&isKicked=' + isKicked + '&isReaded=' + isReaded + '&isExcellent=' + isExcellent,
                    type: "POST",
                    success: function () {
                        window.location.reload();
                    }
                });
            });

        } else {

            if (isReaded == 0 && isReaded != "")//已读
            {
                isReaded = 1;
            }

            $.ajax({
                url: '${ctx}/cmhousecomment/' + commentId + '?action=updateComment&isKicked=' + isKicked + '&isReaded=' + isReaded + '&isExcellent=' + isExcellent,
                type: "POST",
                success: function () {
                    window.location.reload();
                }
            });
        }

    }

    //批量标记已读
    function setReaded() {
        var selectedId = "";
        for (var i = 0; i < document.getElementsByName('commentCheck').length; i++) {
            if (document.getElementsByName('commentCheck')[i].checked) {
                selectedId += document.getElementsByName('commentCheck')[i].value + ",";
            }
        }

        var str = "";
        if (selectedId != "") {
            str = selectedId.split(",");

            if (str[str.length - 1] == "") {
                selectedId = selectedId.substring(0, selectedId.length - 1);
            }
        }

        if (selectedId == "") {
            House365Util.createModal("标记已读", "请至少选择一条点评!", function () {
            });
        }
        else {
            House365Util.createModal("标记已读", "确定要标记已读这些点评吗？", function () {
                $.ajax({
                    url: '${ctx}/cmhousecomment/' + selectedId + '?action=updateComment&isReaded=1',
                    type: "POST",
                    success: function () {
                        window.location.reload();
                    }
                });
            });
        }
    }

    //切换子点评
    function changeComment(btn) {
        //alert(btn.value);
        if (btn.value == 2) {
            $("#filterForm").attr("action", "${ctx}/cmhousecommentreply");
            $("#filterForm").submit();
        }
    }

</script>
</body>
</html>
