<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>评论举报列表</title>
    <style type="text/css">
        img {
            cursor: pointer;
        }

        #filterForm input {
            margin-top: 3px;
        }

        #filterForm div {
            margin-top: 3px;
        }
    </style>
    <script type="text/javascript" src="${ctx}/resources/customize/js/imageModal.js"></script>
</head>
<body>
<%-- <div class="row${fluid}">
    <div class="span6">
        <h2 class="page-title">CmCommentReport列表</h2>
    </div>
    <div class="span6 header_buttons">
        <a href="${ctx}/cmcommentreport?action=create" class="btn blue pull-right"><i class="icon-plus"></i></a>
    </div>
</div> --%>

<!-- 面包屑 begin -->
<div class="row-fluid">
    <div class="span12">
        <ul class="breadcrumb">
            <!-- <li><a href="/house365-hmc-web/">首页</a> <span class="divider"></span></li> -->
            <li class="active"><span class="divider" style="color:#26a0da;font-weight:bold;">/</span>评论举报列表</li>
        </ul>
    </div>
</div>
<!-- 面包屑 begin -->

<div class="page-container">
    <div class="row${fluid}">
        <div class="span12">
            <form id="filterForm" class="form-inline filterForm valid" action="${ctx}/cmcommentreport" method="get">
                <select class="span2" style="width:220px;height: 20px" name="search_searchType">
                    <option value="1" <c:if test="${param['search_searchType'] eq 1 }">selected="selected"</c:if>>用户名
                    </option>
                    <option value="2" <c:if test="${param['search_searchType'] eq 2 }">selected="selected"</c:if>>手机号
                    </option>
                </select>
                <input type="text" name="search_searchContent" value="${param['search_searchContent']}"
                       class="m-wrap small" placeholder="" style="height: 20px">
                <input type="text"
                       class="datetime-picker span2" id="startTime" name="search_GTE_publishTimeStart"
                       value="${param['search_GTE_publishTimeStart']}"
                       date-format="yyyy-mm-dd hh:ii:ss" date-minView="month"
                       placeholder="举报开始时间" dateLte="#endTime">
                <input type="text"
                       class="datetime-picker span2" id="endTime" name="search_LTE_publishTimeEnd"
                       value="${param['search_LTE_publishTimeEnd']}" date-format="yyyy-mm-dd hh:ii:ss"
                       date-minView="month" placeholder="举报结束时间" class="input-large" dateGte="#startTime">
                &nbsp;&nbsp;&nbsp;&nbsp;<select class="span2" name="search_EQ_commentType"
                                                data-placeholder="状态" style="width:220px;height: 40px">
                <option value="">点评类别(不限)</option>
                <option value="1"
                        <c:if test="${param['search_EQ_commentType'] eq 1 && param['search_EQ_commentType'] ne ''}">selected="selected"</c:if>>
                    楼盘点评
                </option>
                <option value="2" <c:if test="${param['search_EQ_commentType'] eq 2 }">selected="selected"</c:if>>
                    楼盘点评回复
                </option>
            </select>

                &nbsp;&nbsp;&nbsp;&nbsp;<select class="span2" name="search_EQ_reportReason"
                                                data-placeholder="评分" style="width:220px;height: 40px">
                <option value="">举报原因(不限)</option>
                <option value="1" <c:if test="${param['search_EQ_reportReason'] eq 1 }">selected="selected"</c:if>>
                    色情低俗
                </option>
                <option value="2" <c:if test="${param['search_EQ_reportReason'] eq 2 }">selected="selected"</c:if>>广告
                </option>
                <option value="3" <c:if test="${param['search_EQ_reportReason'] eq 3 }">selected="selected"</c:if>>谩骂
                </option>
                <option value="4" <c:if test="${param['search_EQ_reportReason'] eq 4 }">selected="selected"</c:if>>反动
                </option>
                <option value="5" <c:if test="${param['search_EQ_reportReason'] eq 5 }">selected="selected"</c:if>>其他
                </option>
            </select>
                &nbsp;&nbsp;&nbsp;&nbsp;<input id="isPic" name="search_EQ_other" type="checkbox" onclick="havePic()"
                                               <c:if test="${!empty param['search_EQ_other']}">checked</c:if>/>
                <strong>有图</strong>
                &nbsp;&nbsp;&nbsp;&nbsp;<input id="isMute" name="search_EQ_mute" type="checkbox"
                                               <c:if test="${!empty param['search_EQ_mute']}">checked</c:if>/>
                <strong>已禁言</strong>
                <!-- <input type="hidden" id="other" value=""> -->
                <div class="buttons pull-right" style="margin:3px 5px 0 0;">
                    <i class="icon-search icon-2x pointer" onclick="$('#filterForm').submit();" title="搜索"></i>
                </div>
            </form>
        </div>
    </div>
    <table class="table table-striped table-advance table-hover">
        <thead>
        <tr>
            <th width="40" style="text-align:center"><input id="memberCheckAll" type="checkbox"
                                                            onclick="checkAll(this)"/></th>
            <th width="100">举报ID</th>
            <th width="100">点评人</th>
            <th width="100">点评内容</th>
            <th width="100">点评类别</th>
            <th width="100">举报原因</th>
            <th width="100">此评论被举报次数</th>
            <th width="100">会员被累计举报次数</th>
            <th width="100">举报时间</th>
            <th width="150">操作</th>
        </tr>
        </thead>
        <button class="btn blue" type="button" onclick="deleteById('',false,false)"><i
                class="icon"></i>&nbsp;批量删除
        </button>
        &nbsp;
        <button class="btn blue" type="button" onclick="deleteById('',false,true)"><i
                class="icon"></i>&nbsp;批量忽略
        </button>
        &nbsp;
        <button class="btn blue" type="button" onclick="deleteById('',true,false)"><i
                class="icon"></i>&nbsp;批量删除并禁言
        </button>
        &nbsp;

        <c:forEach items="${cmCommentReports}" var="cmCommentReport">
            <tr>
                <td nowrap="nowrap" style="text-align:center">
                    <input type="checkbox" name="memberCheck" value="${cmCommentReport.id}"
                           onclick="checkMember(this)"/>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne cmCommentReport.id && '' ne cmCommentReport.id}">
                        <c:out value="${cmCommentReport.id}"/>
                    </c:if>
                    <c:if test="${null eq cmCommentReport.id || '' eq cmCommentReport.id}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne cmCommentReport.criticName && '' ne cmCommentReport.criticName}">
                        <c:out value="${cmCommentReport.criticName}"/>
                    </c:if>
                    <c:if test="${null eq cmCommentReport.criticName || '' eq cmCommentReport.criticName}">
                        &nbsp;
                    </c:if>
                    <br/>
                    <c:if test="${null ne cmCommentReport.criticPhone && '' ne cmCommentReport.criticPhone}">
                        <c:out value="${cmCommentReport.criticPhone}"/>
                    </c:if>
                    <c:if test="${null eq cmCommentReport.criticPhone || '' eq cmCommentReport.criticPhone}">
                        &nbsp;
                    </c:if>
                </td>
                <td width="25%">
                    <c:if test="${null ne cmCommentReport.content && '' ne cmCommentReport.content}">
                        <c:out value="${cmCommentReport.content}"/>
                    </c:if>
                    <c:if test="${null eq cmCommentReport.content || '' eq cmCommentReport.content}">
                        &nbsp;
                    </c:if>
                    <br/>
                        <%-- <c:if test="${null ne cmCommentReport.criticPictures && '' ne cmCommentReport.criticPictures}">
                            <c:out value="${cmCommentReport.criticPictures}" />
                        </c:if>
                        <c:if test="${null eq cmCommentReport.criticPictures || '' eq cmCommentReport.criticPictures}">
                            &nbsp;
                        </c:if> --%>
                    <c:forEach items="${cmCommentReport.picList}" var="criticPicture">
                        <img src="${criticPicture}" class="commentImage" style="height: 50px" width="50px">
                    </c:forEach>
                    <br/>
                    <c:if test="${null ne cmCommentReport.commentTime && '' ne cmCommentReport.commentTime}">
                        <f:formatDate value='${cmCommentReport.commentTime}' pattern='yyyy-MM-dd HH:mm:ss'/>
                    </c:if>
                    <c:if test="${null eq cmCommentReport.commentTime || '' eq cmCommentReport.commentTime}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne cmCommentReport.commentType && '' ne cmCommentReport.commentType}">
                        <c:if test="${cmCommentReport.commentType eq '1' }">楼盘点评</c:if>
                        <c:if test="${cmCommentReport.commentType eq '2' }">楼盘点评回复</c:if>
                        <c:if test="${cmCommentReport.commentType eq '3' }">经纪人点评</c:if>
                    </c:if>
                    <c:if test="${null eq cmCommentReport.commentType || '' eq cmCommentReport.commentType}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne cmCommentReport.reportReason && '' ne cmCommentReport.reportReason}">
                        <c:if test="${cmCommentReport.reportReason eq '1' }">色情低俗</c:if>
                        <c:if test="${cmCommentReport.reportReason eq '2' }">广告</c:if>
                        <c:if test="${cmCommentReport.reportReason eq '3' }">谩骂</c:if>
                        <c:if test="${cmCommentReport.reportReason eq '4' }">反动</c:if>
                        <c:if test="${cmCommentReport.reportReason eq '5' }">其他</c:if>
                    </c:if>
                    <c:if test="${null eq cmCommentReport.reportReason || '' eq cmCommentReport.reportReason}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne cmCommentReport.reportCount && '' ne cmCommentReport.reportCount}">
                        <c:out value="${cmCommentReport.reportCount}"/>
                    </c:if>
                    <c:if test="${null eq cmCommentReport.reportCount || '' eq cmCommentReport.reportCount}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne cmCommentReport.criticReportedCount && '' ne cmCommentReport.criticReportedCount}">
                        <c:out value="${cmCommentReport.criticReportedCount}"/>
                    </c:if>
                    <c:if test="${null eq cmCommentReport.criticReportedCount || '' eq cmCommentReport.criticReportedCount}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne cmCommentReport.createTime && '' ne cmCommentReport.createTime}">
                        <f:formatDate value='${cmCommentReport.createTime}' pattern='yyyy-MM-dd HH:mm:ss'/>
                    </c:if>
                    <c:if test="${null eq cmCommentReport.createTime || '' eq cmCommentReport.createTime}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <a href="javascript:void(0);" onclick="deleteById('${cmCommentReport.id}',false,true)">忽略</a>
                    <br/>
                    <a href="javascript:void(0);" onclick="deleteById('${cmCommentReport.id}',false,false)">删除</a>
                    <br/>

                    <c:choose>
                        <c:when test="${cmCommentReport.isDeleted gt 0 or cmCommentReport.isIgnored gt 0}">
                            已禁言(剩余
                            <c:if test="${cmCommentReport.isDeleted gt 0}">
                                ${cmCommentReport.isDeleted}小时
                            </c:if>
                            ${cmCommentReport.isIgnored}分钟)
                        </c:when>
                        <c:otherwise>
                            <a href="javascript:void(0);" onclick="showForbid('${cmCommentReport.id}')">删除并禁言</a>
                        </c:otherwise>
                    </c:choose>

                </td>
            </tr>
        </c:forEach>
    </table>
    <div class="row${fluid}">
        <house365:pagination page="${page}"/>
    </div>
</div>

<div id="dialog" title="提示:" style="display: none;">
    <input type="hidden" id="delId" name="delId">
    <p>禁言时间:<input type="text" id="forbidHours" name="forbidHours" size="8">小时</p>
</div>

<script type="text/javascript" src="${static_common}/script/jquery-ui-1.11.4.custom/jquery-ui.min.js"></script>


<script type="text/javascript">

    function showForbid(commentId) {
        $("#dialog").dialog({
            height: 200,
            width: 450,
            modal: true,
            closeOnEscape: false,
            resizable: false,
            autoOpen: false,
            open: function () {
                jQuery(".ui-dialog-titlebar", $("#dialog").parent()).hide();
                $("#dialog").parent().css({background: "#e40000", "font-weight": "bold", border: "none"});
                $("#dialog").css({background: "#e40000", color: "#ffffff"});
            },
            buttons: {
                "确认": function () {
                    if (!$.isNumeric($("#forbidHours").val())) {
                        alert("请输入数字!");
                    } else {
                        var isNoTalkTip = "确定删除并禁言" + $("#forbidHours").val() + "小时？";
                        House365Util.createModal("提示", isNoTalkTip, function () {
                            $.ajax({
                                url: '${ctx}/cmcommentreport/' + commentId + "?isNoTalk=true&forbidHours=" + $("#forbidHours").val(),
                                type: "DELETE",
                                success: function () {
                                    window.location.reload();
                                }
                            });
                        });
                    }
                },
                "关闭": function () {
                    $("#dialog").dialog("close");
                }
            }
        }).dialog("open");
    }

    //全选
    function checkAll(btn) {
        if (btn.checked) {
            for (i = 0; i < document.all("memberCheck").length; i++) {
                document.all("memberCheck")[i].checked = "checked";
            }
        }
        else {
            for (i = 0; i < document.all("memberCheck").length; i++) {
                document.all("memberCheck")[i].checked = "";
            }
        }
    }

    //单选
    function checkMember(btn) {
        if (btn.checked) {
            var checkAll = true;
            for (i = 0; i < document.all("memberCheck").length; i++) {
                if (document.all("memberCheck")[i].checked == false) {
                    checkAll = false;
                }
            }

            if (checkAll) {
                document.getElementById("memberCheckAll").checked = true;
            }
        }
        else {
            document.getElementById("memberCheckAll").checked = false;
        }
    }

    var deleteById = function (selectedId, isNoTalk, isIgnored) {

        if (selectedId == "") {
            for (i = 0; i < document.getElementsByName('memberCheck').length; i++) {
                if (document.getElementsByName('memberCheck')[i].checked) {
                    selectedId += document.getElementsByName('memberCheck')[i].value + ",";
                }
            }

            var str = "";
            if (selectedId != "") {
                str = selectedId.split(",");

                if (str[str.length - 1] == "") {
                    selectedId = selectedId.substring(0, selectedId.length - 1);
                }
            }
        }
        if (isNoTalk) {
            if (selectedId == "") {
                House365Util.createModal("删除并禁言举报", "请至少选择一条举报!", function () {
                });
            }
            else {
                showForbid(selectedId);
            }
        }
        else if (isIgnored) {
            if (selectedId == "") {
                House365Util.createModal("忽略举报", "请至少选择一条举报!", function () {
                });
            }
            else {
                House365Util.createModal("忽略举报", "确定要忽略这些举报？", function () {
                    $.ajax({
                        url: '${ctx}/cmcommentreport/' + selectedId + "?isIgnored=true",
                        type: "DELETE",
                        success: function () {
                            window.location.reload();
                        }
                    });
                });
            }
        }
        else {
            if (selectedId == "") {
                House365Util.createModal("删除举报", "请至少选择一条举报!", function () {
                });
            }
            else {
                House365Util.createModal("删除举报", "确定删除选中的" + selectedId.split(",").length + "条点评吗？", function () {
                    $.ajax({
                        url: '${ctx}/cmcommentreport/' + selectedId,
                        type: "DELETE",
                        success: function () {
                            window.location.reload();
                        }
                    });
                });
            }
        }
    };

    //是否有图
    function havePic() {
        if (document.getElementById("isPic").checked) {
            $("#isPic").val('true');
        }
        else {
            $("#isPic").val();
        }
    }

</script>
</body>
</html>
