package com.house365.web.controller;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.house365.rest.context.CmConstant;
import com.house365.rest.context.ServiceConstant;
import com.house365.web.system.controller.BaseController;

/**
 * 登录、登出、首页等
 */
@Controller
@RequestMapping
public class IndexController extends BaseController {


    /**
     * home page
     *
     * @param response
     * @param request
     * @return
     */
    @SuppressWarnings("all")
    @RequestMapping(value = {"", "/", "/index"}, method = {RequestMethod.GET})
    public String index(Model model, HttpServletResponse response, HttpServletRequest request) {
        //  Integer loginID = UserUtils.getLoginId();
        //Map<String, Object> map = UserUtils.getUserAttributes();

        String accountName = (String) request.getSession().getAttribute(CmConstant.USER_NAME);
        String phone = (String) request.getSession().getAttribute(CmConstant.USER_PHONE);
        String city = (String) request.getSession().getAttribute(ServiceConstant.CITY_ID);
        model.addAttribute("accountName", accountName);
        model.addAttribute("phone", phone);
        model.addAttribute("city", city);

        //KlfCityListRequest cityRequest = new KlfCityListRequest();
        //Map<String, Object> citySearchParams = new HashMap<String, Object>();
        //citySearchParams.put("EQ_used", 1);
        //cityRequest.setSearchParams(citySearchParams);

        //KlfCityListResponse cityRes = klfCity.getKlfCityList(cityRequest);
        //model.addAttribute("klfCities", cityRes.getObjectList());
        return getAutoUrl();
    }

    /**
     * 切换城市
     *
     * @param session  用户会话
     * @param city     城市代码
     * @param cityName 城市名称
     * @author chengjianfang
     * @version [版本号, 2015年5月15日]
     */
    @RequestMapping(value = "changeCity", method = {RequestMethod.POST})
    @ResponseBody
    @ResponseStatus(HttpStatus.OK)
    public void changeCity(HttpSession session, String city, String cityName) {
        session.setAttribute(ServiceConstant.CITY_ID, city);
        // KlfCityResponse res = klfCity.getKlfCityById(Integer.parseInt(city));
        //session.setAttribute(ServiceConstant.CITY_CODE, res.getEntity().getCode());
        session.setAttribute(CmConstant.CITY_NAME, cityName);
    }
}
