/**
 * Description: 商品促销关联控制器
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2016-09-01 上午 10:52:46
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-01   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.web.controller;

import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import org.springside.modules.web.Servlets;

import com.house365.beans.system.Page;

import com.house365.beans.entity.CmPromotionProductEntity;
import com.house365.beans.vo.CmPromotionProductVo;

import com.house365.web.system.controller.BaseController;
import com.house365.web.util.StringUtils;
import com.house365.ws.beans.response.CmBrokerLabelResponse;

import com.house365.ws.beans.request.CmPromotionProductListRequest;
import com.house365.ws.beans.request.CmPromotionProductRequest;
import com.house365.ws.beans.response.CmPromotionProductListResponse;
import com.house365.ws.beans.response.CmPromotionProductResponse;
import com.house365.ws.interfaces.server.ICmPromotionProduct;

/**
 * 商品促销关联控制器<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-01
 * @see
 * @since 1.0
 */
@Controller
@RequestMapping("/cmpromotionproduct")
public class CmPromotionProductController extends BaseController {

	/**
	 * 自动注入商品促销关联WS实现
	 */
	@Autowired
	private ICmPromotionProduct cmPromotionProduct;

	/**
	 * 去新增商品促销关联
	 * 
	 * @return 结果视图
	 */
	@RequestMapping(value = "", params = "action=create")
	public String createForm(Model model){
		model.addAttribute("action", "create");
		return getAutoUrl("form");
	}

	/**
	 * 新增商品促销关联
	 * 
	 * @param cmPromotionProduct 商品促销关联页面表单对象
	 * @param result 表单验证数据
	 * @param page 分页配置
	 * @param request 请求对象
	 * @return 结果视图
	 */
	@RequestMapping(value = "", method = { RequestMethod.POST})
	public String createCmPromotionProduct(@Valid CmPromotionProductVo vo, BindingResult result, RedirectAttributes redirectAttributes, Model model){
		CmPromotionProductEntity entity = vo.getEntity();
		model.addAttribute("entity", entity);
		// subValidation(result, entity);
		// 表单验证无误,进行提交
		if (result.hasErrors()) {
		    model.addAttribute("action", "create");
            addErrorMessage(model, result.getFieldError().getDefaultMessage());
            return getAutoUrl("form");
		} else {
		    try {
                CmPromotionProductRequest request = new CmPromotionProductRequest();
                request.setEntity(entity);
                CmPromotionProductResponse response = cmPromotionProduct
                        .addCmPromotionProduct(request);
                Integer id = response.getEntity().getId();
                return "redirect:/cmpromotionproduct/" + id;
            } catch (Exception ex) {
                addErrorMessage(model, ex.getMessage());
                model.addAttribute("action", "create");
                return getAutoUrl("form");
            }
		}
	}

	/**
	 * 删除商品促销关联
	 * 
	 * @param id 商品促销关联页面表单对象唯一标识
	 * @param page 分页配置
	 * @param request 请求对象
	 * @return 结果视图
	 */
	@RequestMapping(value = "/{id}", method = { RequestMethod.DELETE })
	@ResponseStatus(HttpStatus.OK)
	public void delete(@PathVariable String id){
	    if(!StringUtils.isEmpty(id))
        {
            if(id.contains(","))
            {
                String[] ids = id.split(",");
                for (int i = 0; i < ids.length; i++) {
                    CmPromotionProductResponse response = cmPromotionProduct.deleteCmPromotionProductById(Integer.valueOf(ids[i]));
                }
            }
            else
            {
                CmPromotionProductResponse response = cmPromotionProduct.deleteCmPromotionProductById(Integer.valueOf(id));
            }
        }
	}

	/**
	 * 去查看商品促销关联
	 * 
	 * @param id
	 *            商品促销关联页面表单对象唯一标识
	 * @param request
	 *            请求对象
	 * @return 结果视图
	 */
	@RequestMapping(value = "/{id}", method = { RequestMethod.GET })
	public String showForm(@PathVariable(value = "id") Integer id, Model model) {
        CmPromotionProductResponse response = cmPromotionProduct
                .getCmPromotionProductById(id);
        model.addAttribute("entity", response.getEntity());
        return getAutoUrl("form");
	}

	/**
	 * 去修改商品促销关联
	 * 
	 * @param id 商品促销关联页面表单对象唯一标识
	 * @param request 请求对象
	 * @return 结果视图
	 */
	@RequestMapping(value = "/{id}", method = { RequestMethod.GET}, params = "action=edit")
	public String updateForm(@PathVariable(value = "id") Integer id, Model model){
        CmPromotionProductResponse response = cmPromotionProduct
                .getCmPromotionProductById(id);
        model.addAttribute("entity", response.getEntity());
		model.addAttribute("action", "edit");
		return getAutoUrl("form");
	}

	/**
	 * 修改商品促销关联
	 * 
	 * @param cmPromotionProduct 商品促销关联页面表单对象
	 * @param result 表单验证数据
	 * @param page 分页配置
	 * @param request 请求对象
	 * @return 结果视图
	 */
	@RequestMapping(value = "/{id}", method = { RequestMethod.POST})
	public String updateCmPromotionProduct(@Valid CmPromotionProductVo vo, BindingResult result, @PathVariable Integer id, RedirectAttributes redirectAttributes, Model model){
		CmPromotionProductEntity entity = vo.getEntity();
		model.addAttribute("entity", entity);
		// subValidation(result, entity);
		// 表单验证无误,进行提交
		if (result.hasErrors()) {
		    model.addAttribute("action", "create");
            addErrorMessage(model, result.getFieldError().getDefaultMessage());
            return getAutoUrl("form");
		} else {
            try {
                CmPromotionProductRequest request = new CmPromotionProductRequest();
                request.setEntity(entity);
                @SuppressWarnings("unused")
                CmPromotionProductResponse rersponse = cmPromotionProduct
                        .updateCmPromotionProduct(request);
                redirectAttributes.addAttribute("message", "更新成功");
                return "redirect:/cmpromotionproduct/" + entity.getId();
            } catch (Exception ex) {
                addErrorMessage(model, ex.getMessage());
                model.addAttribute("action", "edit");
                return getAutoUrl("form");
            }
		}
	}

	/**
	 * 查询商品促销关联
	 * 
	 * @param cmPromotionProduct 商品促销关联页面表单对象
	 * @param page 分页配置
	 * @param request 请求对象
	 * @return 结果视图
	 */
	@RequestMapping(value = "", method = RequestMethod.GET)
	public String list (Integer number, Model model, HttpServletRequest request) {
		// 获取查询条件
		Map<String, Object> searchParams = Servlets.getParametersStartingWith(
				request, "search_");
		Page page = new Page();
		if (null != number) {
			page.setCurrentPage(number);
		}
		CmPromotionProductListRequest listRequest = new CmPromotionProductListRequest();
        listRequest.setPaging(page);
        listRequest.setSearchParams(searchParams);
        CmPromotionProductListResponse response = cmPromotionProduct.getCmPromotionProductList(listRequest);
        model.addAttribute("page", response.getPaging());
        model.addAttribute("cmPromotionProducts", response.getObjectList());
        model.addAttribute("searchParams", Servlets
                .encodeParameterStringWithPrefix(searchParams, "search_"));
		return getAutoUrl();
	}
}
