/**
 * Description: CmPromotionConfig控制器
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2016-09-01 上午 10:52:47
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-01   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.web.controller;

import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import org.springside.modules.web.Servlets;

import com.house365.beans.system.Page;

import com.house365.beans.entity.CmPromotionConfigEntity;
import com.house365.beans.vo.CmPromotionConfigVo;

import com.house365.web.system.controller.BaseController;
import com.house365.web.util.StringUtils;
import com.house365.ws.beans.response.CmBrokerLabelResponse;

import com.house365.ws.beans.request.CmPromotionConfigListRequest;
import com.house365.ws.beans.request.CmPromotionConfigRequest;
import com.house365.ws.beans.response.CmPromotionConfigListResponse;
import com.house365.ws.beans.response.CmPromotionConfigResponse;
import com.house365.ws.interfaces.server.ICmPromotionConfig;

/**
 * CmPromotionConfig控制器<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-01
 * @see
 * @since 1.0
 */
@Controller
@RequestMapping("/cmpromotionconfig")
public class CmPromotionConfigController extends BaseController {

	/**
	 * 自动注入CmPromotionConfigWS实现
	 */
	@Autowired
	private ICmPromotionConfig cmPromotionConfig;

	/**
	 * 去新增CmPromotionConfig
	 * 
	 * @return 结果视图
	 */
	@RequestMapping(value = "", params = "action=create")
	public String createForm(Model model){
		model.addAttribute("action", "create");
		return getAutoUrl("form");
	}

	/**
	 * 新增CmPromotionConfig
	 * 
	 * @param result 表单验证数据
	 * @return 结果视图
	 */
	@RequestMapping(value = "", method = { RequestMethod.POST})
	public String createCmPromotionConfig(@Valid CmPromotionConfigVo vo, BindingResult result, RedirectAttributes redirectAttributes, Model model){
		CmPromotionConfigEntity entity = vo.getEntity();
		model.addAttribute("entity", entity);
		// subValidation(result, entity);
		// 表单验证无误,进行提交
		if (result.hasErrors()) {
		    model.addAttribute("action", "create");
            addErrorMessage(model, result.getFieldError().getDefaultMessage());
            return getAutoUrl("form");
		} else {
		    try {
                CmPromotionConfigRequest request = new CmPromotionConfigRequest();
                request.setEntity(entity);
                CmPromotionConfigResponse response = cmPromotionConfig
                        .addCmPromotionConfig(request);
                Integer id = response.getEntity().getId();
                return "redirect:/cmpromotionconfig/" + id;
            } catch (Exception ex) {
                addErrorMessage(model, ex.getMessage());
                model.addAttribute("action", "create");
                return getAutoUrl("form");
            }
		}
	}

	/**
	 * 删除CmPromotionConfig
	 * 
	 * @param id CmPromotionConfig页面表单对象唯一标识
	 * @return 结果视图
	 */
	@RequestMapping(value = "/{id}", method = { RequestMethod.DELETE })
	@ResponseStatus(HttpStatus.OK)
	public void delete(@PathVariable String id){
	    if(!StringUtils.isEmpty(id))
        {
            if(id.contains(","))
            {
                String[] ids = id.split(",");
                for (int i = 0; i < ids.length; i++) {
                    CmPromotionConfigResponse response = cmPromotionConfig.deleteCmPromotionConfigById(Integer.valueOf(ids[i]));
                }
            }
            else
            {
                CmPromotionConfigResponse response = cmPromotionConfig.deleteCmPromotionConfigById(Integer.valueOf(id));
            }
        }
	}

	/**
	 * 去查看CmPromotionConfig
	 * 
	 * @param id
	 *            CmPromotionConfig页面表单对象唯一标识
	 * @param request
	 *            请求对象
	 * @return 结果视图
	 */
	@RequestMapping(value = "/{id}", method = { RequestMethod.GET })
	public String showForm(@PathVariable(value = "id") Integer id, Model model) {
        CmPromotionConfigResponse response = cmPromotionConfig
                .getCmPromotionConfigById(id);
        model.addAttribute("entity", response.getEntity());
        return getAutoUrl("form");
	}

	/**
	 * 去修改CmPromotionConfig
	 * 
	 * @param id CmPromotionConfig页面表单对象唯一标识
	 * @param request 请求对象
	 * @return 结果视图
	 */
	@RequestMapping(value = "/{id}", method = { RequestMethod.GET}, params = "action=edit")
	public String updateForm(@PathVariable(value = "id") Integer id, Model model){
        CmPromotionConfigResponse response = cmPromotionConfig
                .getCmPromotionConfigById(id);
        model.addAttribute("entity", response.getEntity());
		model.addAttribute("action", "edit");
		return getAutoUrl("form");
	}

	/**
	 * 修改CmPromotionConfig
	 * 
	 * @param cmPromotionConfig CmPromotionConfig页面表单对象
	 * @param result 表单验证数据
	 * @param page 分页配置
	 * @param request 请求对象
	 * @return 结果视图
	 */
	@RequestMapping(value = "/{id}", method = { RequestMethod.POST})
	public String updateCmPromotionConfig(@Valid CmPromotionConfigVo vo, BindingResult result, @PathVariable Integer id, RedirectAttributes redirectAttributes, Model model){
		CmPromotionConfigEntity entity = vo.getEntity();
		model.addAttribute("entity", entity);
		// subValidation(result, entity);
		// 表单验证无误,进行提交
		if (result.hasErrors()) {
		    model.addAttribute("action", "create");
            addErrorMessage(model, result.getFieldError().getDefaultMessage());
            return getAutoUrl("form");
		} else {
            try {
                CmPromotionConfigRequest request = new CmPromotionConfigRequest();
                request.setEntity(entity);
                @SuppressWarnings("unused")
                CmPromotionConfigResponse rersponse = cmPromotionConfig
                        .updateCmPromotionConfig(request);
                redirectAttributes.addAttribute("message", "更新成功");
                return "redirect:/cmpromotionconfig/" + entity.getId();
            } catch (Exception ex) {
                addErrorMessage(model, ex.getMessage());
                model.addAttribute("action", "edit");
                return getAutoUrl("form");
            }
		}
	}

	/**
	 * 查询CmPromotionConfig
	 * 
	 * @param cmPromotionConfig CmPromotionConfig页面表单对象
	 * @param page 分页配置
	 * @param request 请求对象
	 * @return 结果视图
	 */
	@RequestMapping(value = "", method = RequestMethod.GET)
	public String list (Integer number, Model model, HttpServletRequest request) {
		// 获取查询条件
		Map<String, Object> searchParams = Servlets.getParametersStartingWith(
				request, "search_");
		Page page = new Page();
		if (null != number) {
			page.setCurrentPage(number);
		}
		CmPromotionConfigListRequest listRequest = new CmPromotionConfigListRequest();
        listRequest.setPaging(page);
        listRequest.setSearchParams(searchParams);
        CmPromotionConfigListResponse response = cmPromotionConfig.getCmPromotionConfigList(listRequest);
        model.addAttribute("page", response.getPaging());
        model.addAttribute("cmPromotionConfigs", response.getObjectList());
        model.addAttribute("searchParams", Servlets
                .encodeParameterStringWithPrefix(searchParams, "search_"));
		return getAutoUrl();
	}
}
