/**
 * Description: CmHouseComment控制器
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2015-08-10 下午 17:06:15
 * <p/>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-08-10   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.web.controller;

import com.google.common.base.Strings;
import com.house365.beans.constant.CommentConstant;
import com.house365.beans.entity.*;
import com.house365.beans.system.Page;
import com.house365.beans.vo.CmHouseCommentVo;
import com.house365.rest.context.CmConstant;
import com.house365.rest.parameter.House365RestResponse;
import com.house365.web.system.controller.BaseController;
import com.house365.web.util.CityUtil;
import com.house365.web.util.StringUtils;
import com.house365.ws.beans.request.*;
import com.house365.ws.beans.response.*;
import com.house365.ws.interfaces.server.*;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import org.springside.modules.web.Servlets;

import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import java.util.*;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/**
 * CmHouseComment控制器<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-08-10
 * @see
 * @since 1.0
 */
@Controller
@RequestMapping("/cmhousecomment")
public class CmHouseCommentController extends BaseController {
    Logger commentLogger = LoggerFactory.getLogger(getClass());

    /**
     * 自动注入CmHouseCommentWS实现
     */
    @Autowired
    private ICmHouseComment cmHouseComment;

    @Autowired
    private ICmHouse cmHouse;

    /**
     * 自动注入CmHouseCommentReplyWS实现
     */
    @Autowired
    private ICmHouseCommentReply cmHouseCommentReply;

    @Autowired
    private ICmUser cmUser;

    @Autowired
    private ICmCreditRecord cmCreditRecord;

    @Autowired
    private ICmDictionary cmDictionary;

    /**
     * 被禁言时间
     */
    @Value("#{system.gagTimeInMinutes}")
    private Integer gagTimeInMinutes;


    /**
     * 去新增CmHouseComment
     *
     * @return 结果视图
     */
    @RequestMapping(value = "", params = "action=create")
    public String createForm(Model model) {
        model.addAttribute("action", "create");
        return getAutoUrl("form");
    }


    /**
     * 新增CmHouseComment
     *
     * @param result 表单验证数据
     * @return 结果视图
     */
    @RequestMapping(value = "", method = {RequestMethod.POST})
    public String createCmHouseComment(
            @Valid CmHouseCommentVo vo, BindingResult result, RedirectAttributes redirectAttributes, Model model
    ) {
        CmHouseCommentEntity entity = vo.getEntity();
        model.addAttribute("entity", entity);
        // subValidation(result, entity);
        // 表单验证无误,进行提交
        if (result.hasErrors()) {
            model.addAttribute("action", "create");
            addErrorMessage(model, result.getFieldError().getDefaultMessage());
            return getAutoUrl("form");
        } else {
            try {
                CmHouseCommentRequest request = new CmHouseCommentRequest();
                request.setEntity(entity);
                CmHouseCommentResponse response = cmHouseComment.addCmHouseComment(request);
                Integer id = response.getEntity().getId();
                return "redirect:/cmhousecomment/" + id;
            } catch (Exception ex) {
                addErrorMessage(model, ex.getMessage());
                model.addAttribute("action", "create");
                return getAutoUrl("form");
            }
        }
    }

    /**
     * 删除CmHouseComment
     *
     * @param id      CmHouseComment页面表单对象唯一标识
     * @param request 请求对象
     * @return 结果视图
     */
    @RequestMapping(value = "/{id}", method = {RequestMethod.DELETE})
    @ResponseStatus(HttpStatus.OK)
    public void delete(@PathVariable String id, HttpServletRequest request) {
        String forbidHours = (Strings.isNullOrEmpty(request.getParameter("forbidHours")) || !StringUtils.isNumeric(
                request.getParameter("forbidHours"))) ? "0" : request.getParameter("forbidHours");
        if (!StringUtils.isEmpty(id)) {
            if (id.contains(",")) {
                String[] ids = id.split(",");
                for (String tempId : ids) {
                    CmHouseCommentEntity entity = deleteComment(forbidHours, tempId);
                    if (entity.getSource() == CommentConstant.COMMENT_SOURCE_WEB) {
                        continue;
                    }
                    //扣除积分
                    cmCreditRecord.removeCredit(Integer.valueOf(tempId), CmConstant.CREDITS_RULE_HOUSE_COMMENT);
                }
            } else {
                CmHouseCommentEntity entity = deleteComment(forbidHours, id);
                if (entity.getSource() == CommentConstant.COMMENT_SOURCE_WEB) {
                    return;
                }
                //扣除积分
                cmCreditRecord.removeCredit(Integer.valueOf(id), CmConstant.CREDITS_RULE_HOUSE_COMMENT);
            }
        }
    }

    private CmHouseCommentEntity deleteComment(String isNoTalk, String tempId) {
        CmHouseCommentResponse response = cmHouseComment.getCmHouseCommentById(Integer.valueOf(tempId));
        CmHouseCommentEntity entity = response.getEntity();
        //数据逻辑删除
        entity.setIsDeleted(1);
        //禁言48小时
        if (!Strings.isNullOrEmpty(isNoTalk) && !"0".equals(isNoTalk)) {
            Calendar c = Calendar.getInstance();
            c.add(Calendar.HOUR,
                    Long.parseLong(isNoTalk) > Integer.MAX_VALUE ? Integer.MAX_VALUE : Integer.parseInt(isNoTalk));
            CmUserEntity userEntity = cmUser.getCmUserById(entity.getCriticId()).getEntity();
            if (userEntity.getGagTime() == null || userEntity.getGagTime().compareTo(new Date()) <= 0) {
                userEntity.setGagTime(c.getTime());
                CmUserRequest userRequest = new CmUserRequest();
                userRequest.setEntity(userEntity);
                cmUser.updateCmUser(userRequest);
            }
        }
        CmHouseCommentRequest commentRequest = new CmHouseCommentRequest();
        commentRequest.setEntity(entity);
        cmHouseComment.updateCmHouseComment(commentRequest);

        final Integer id = entity.getHouseId();
        ExecutorService fixedThreadPool = Executors.newFixedThreadPool(1);
        fixedThreadPool.submit(new Runnable() {
            @Override
            public void run() {
                cmHouseComment.removeCache(id);
            }
        });

        //更新楼盘评论数
        decreaseHouseCommentAmountAndHouseScore(entity.getHouseId(), entity.getCriticPictures(), entity);
        return entity;
    }

    /**
     * 去查看CmHouseComment
     *
     * @param id      CmHouseComment页面表单对象唯一标识
     * @param request 请求对象
     * @return 结果视图
     */
    @RequestMapping(value = "/{id}", method = {RequestMethod.GET})
    public String showForm(@PathVariable(value = "id") Integer id, Model model, HttpServletRequest request) {
        CmHouseCommentResponse response = cmHouseComment.getCmHouseCommentById(id);
        Map<String, Object> searchParams = Servlets.getParametersStartingWith(request, "search_");
        Page page = new Page(Page.TWENTY_PAGE_SIZE);
        /*if (null != number) {
            page.setCurrentPage(number);
        }*/
        //图片列表
        CmHouseCommentEntity entity = response.getEntity();
        if (entity != null) {

            List<String> picList = new ArrayList<String>();

            String criticPics = entity.getCriticPictures();
            if (!StringUtils.isEmpty(criticPics)) {
                if (criticPics.contains(",")) {
                    String[] picArr = criticPics.split(",");
                    for (String string : picArr) {
                        picList.add(string);
                    }
                } else {
                    picList.add(criticPics);
                }
            }

            entity.setPicList(picList);
        }

        model.addAttribute("entity", response.getEntity());

        boolean needCheck = false;
        String sessionCity = String.valueOf(request.getSession().getAttribute(CmConstant.CITY_KEY));
        CmDictionaryResponse dictionary = cmDictionary.getCmDictionaryById(16);
        if (dictionary.getEntity() != null) {
            CmDictionaryEntity dic = dictionary.getEntity();
            String cities = "," + dic.getDicValue() + ",";
            if (cities.contains("," + sessionCity + ",")) {
                needCheck = true;
            }

        }

        model.addAttribute("needCheck", needCheck);

        //该评论的回复列表
        searchParams.put("EQ_commentId", id);
        searchParams.put("EQ_isDeleted", "on");
        CmHouseCommentReplyListRequest listRequest = new CmHouseCommentReplyListRequest();
        listRequest.setPaging(page);
        listRequest.setSearchParams(searchParams);
        listRequest.setOrderColumn("is_reply_by_manager");
        listRequest.setOrderMode("desc");
        CmHouseCommentReplyListResponse replyListResponse = cmHouseCommentReply.getCmHouseCommentReplyList(listRequest);
        if (replyListResponse.getObjectList() != null && replyListResponse.getObjectList().size() != 0) {
            model.addAttribute("managerReplied", replyListResponse.getObjectList().get(0).getIsReplyByManager());
        }
        model.addAttribute("page", replyListResponse.getPaging());
        model.addAttribute("cmHouseCommentReplys", replyListResponse.getObjectList());

        return getAutoUrl("form");
    }

    /**
     * 去修改CmHouseComment
     *
     * @param id    CmHouseComment页面表单对象唯一标识
     * @param model 请求对象
     * @return 结果视图
     */
    @RequestMapping(value = "/{id}", method = {RequestMethod.GET}, params = "action=edit")
    public String updateForm(@PathVariable(value = "id") Integer id, Model model) {
        CmHouseCommentResponse response = cmHouseComment.getCmHouseCommentById(id);
        model.addAttribute("entity", response.getEntity());
        model.addAttribute("action", "edit");
        return getAutoUrl("form");
    }

    /**
     * 修改CmHouseComment
     *
     * @param vo     CmHouseComment页面表单对象
     * @param result 表单验证数据
     * @return 结果视图
     */
    @RequestMapping(value = "/{id}", method = {RequestMethod.POST})
    public String updateCmHouseComment(
            @Valid CmHouseCommentVo vo, BindingResult result, @PathVariable Integer id,
            RedirectAttributes redirectAttributes, Model model
    ) {
        CmHouseCommentEntity entity = vo.getEntity();
        model.addAttribute("entity", entity);
        // subValidation(result, entity);
        // 表单验证无误,进行提交
        if (result.hasErrors()) {
            model.addAttribute("action", "create");
            addErrorMessage(model, result.getFieldError().getDefaultMessage());
            return getAutoUrl("form");
        } else {
            try {
                CmHouseCommentRequest request = new CmHouseCommentRequest();
                request.setEntity(entity);
                @SuppressWarnings("unused") CmHouseCommentResponse rersponse = cmHouseComment.updateCmHouseComment(
                        request);
                redirectAttributes.addAttribute("message", "更新成功");
                return "redirect:/cmhousecomment/" + entity.getId();
            } catch (Exception ex) {
                addErrorMessage(model, ex.getMessage());
                model.addAttribute("action", "edit");
                return getAutoUrl("form");
            }
        }
    }

    /**
     * 修改CmBrokerComment
     *
     * @param model   CmBrokerComment页面表单对象
     * @param request 请求对象
     * @return 结果视图
     */
    @RequestMapping(value = "/{id}", method = {RequestMethod.POST}, params = "action=updateComment")
    @ResponseStatus(HttpStatus.OK)
    public void updateComment(@PathVariable String id, Model model, HttpServletRequest request) {
        try {

            String isExcellent = request.getParameter("isExcellent");
            String isReaded = request.getParameter("isReaded");
            String isKicked = request.getParameter("isKicked");

            if (id.contains(",")) {
                String[] ids = id.split(",");
                for (int i = 0; i < ids.length; i++) {
                    CmHouseCommentResponse response = cmHouseComment.getCmHouseCommentById(Integer.valueOf(ids[i]));

                    CmHouseCommentEntity entity = response.getEntity();


                    CmHouseCommentRequest commentRequest = new CmHouseCommentRequest();

                    entity.setIsReaded(1);

                    commentRequest.setEntity(entity);

                    cmHouseComment.updateCmHouseComment(commentRequest);
                }
            } else {
                CmHouseCommentResponse response = cmHouseComment.getCmHouseCommentById(Integer.valueOf(id));

                CmHouseCommentEntity entity = response.getEntity();

                CmHouseCommentRequest commentRequest = new CmHouseCommentRequest();

                if (!StringUtils.isEmpty(isReaded)) {
                    entity.setIsReaded(Integer.valueOf(isReaded));
                }
                if (!StringUtils.isEmpty(isKicked)) {
                    entity.setIsSticked(Integer.valueOf(isKicked));
                }
                if (!StringUtils.isEmpty(isExcellent)) {
                    Integer isE = Integer.valueOf(isExcellent);
                    //加精
                    if ((entity.getIsExcellent() == 0 || entity.getIsExcellent() == 2) && isE == 1) {
                        CmHouseEntity houseEntity = cmHouse.getCmHouseById(entity.getHouseId()).getEntity();
                        houseEntity.increaseExcellentCount();
                        CmHouseRequest cr = new CmHouseRequest();
                        cr.setEntity(houseEntity);
                        cmHouse.updateCmHouse(cr);
                        //加精积分
                        if (entity.getIsExcellent() == 0) {
                            CmUserEntity user = cmUser.getCmUserById(entity.getCriticId()).getEntity();
                            if (user != null) {
                                CmCreditRecordEntity record = cmCreditRecord.saveAddExcellentRecord(user,
                                        entity.getId());
                                //user credit exsit null data
                                Integer userCredit = user.getCredits() == null ? 0 : user.getCredits();
                                user.setCredits(userCredit + record.getAmount());
                                CmUserRequest userReq = new CmUserRequest();
                                userReq.setEntity(user);
                                cmUser.updateCmUser(userReq);
                            }
                        }
                    }
                    //取消加精
                    if (entity.getIsExcellent() == 2 || isE == 1) {
                        //加精过的为2
                        isE = 1;
                        CmHouseEntity houseEntity = cmHouse.getCmHouseById(entity.getHouseId()).getEntity();
                        houseEntity.decreaseExcellentCount();
                        CmHouseRequest cr = new CmHouseRequest();
                        cr.setEntity(houseEntity);
                        cmHouse.updateCmHouse(cr);
                    }
                    entity.setIsExcellent(isE);
                }
                commentRequest.setEntity(entity);
                cmHouseComment.updateCmHouseComment(commentRequest);
            }

        } catch (Exception ex) {
            ex.printStackTrace();
            addErrorMessage(model, ex.getMessage());
            model.addAttribute("action", "edit");
        }
    }

    @RequestMapping(value = "check/{id}", method = RequestMethod.GET)
    @ResponseBody
    public String check(@PathVariable String id, Model model, HttpServletRequest request, @RequestParam String op) {

        House365RestResponse restResponse = new House365RestResponse();
        if (Strings.isNullOrEmpty(id)) {
            restResponse.setResult("0");
            restResponse.setMsg("记录不存在");
            return JSONObject.fromObject(restResponse).toString();
        }

        String userName = String.valueOf(request.getSession().getAttribute(CmConstant.USER_NAME));
        commentLogger.info("user {} check comments [{}]", userName, id);

        try {
            restResponse = cmHouseComment.checkHouseComment(id, op);
        } catch (Exception e) {
            e.printStackTrace();
            restResponse.setResult("0");
            restResponse.setMsg(e.getMessage());
        }

        return JSONObject.fromObject(restResponse).toString();
    }

    /**
     * 查询CmHouseComment
     *
     * @param request 请求对象
     * @return 结果视图
     */
    @RequestMapping(value = "", method = RequestMethod.GET)
    public String list(Integer number, Model model, HttpServletRequest request) {
        boolean needCheck = false;
        String sessionCity = String.valueOf(request.getSession().getAttribute(CmConstant.CITY_KEY));
        CmDictionaryResponse dictionary = cmDictionary.getCmDictionaryById(16);
        if (dictionary.getEntity() != null) {
            CmDictionaryEntity dic = dictionary.getEntity();
            String cities = "," + dic.getDicValue() + ",";
            if (cities.contains("," + sessionCity + ",")) {
                needCheck = true;
            }

        }

        model.addAttribute("needCheck", needCheck);
        // 获取查询条件
        Map<String, Object> searchParams = Servlets.getParametersStartingWith(request, "search_");
        String userRole = String.valueOf(request.getSession().getAttribute(CmConstant.USER_ROLE));
        //获取用户角色
        if (!userRole.equals(CmConstant.ROLE_ADMIN)) {
            String cityKey = (String) request.getSession().getAttribute(CmConstant.CITY_KEY);
            // 区分城市,默认城市南京
            if (StringUtils.isEmpty(cityKey)) {
                return null;
            }
        }

        //获取城市列表
        List<KlfCityEntity> cityList = CityUtil.getCityList();
        model.addAttribute("cityList", cityList);

        String other = (String) searchParams.get("EQ_other");
        String mute = (String) searchParams.get("EQ_mute");
        String unCheckReply = (String) searchParams.get("EQ_unCheckReply");
        String searchType = (String) searchParams.get("searchType");
        String searchContent = (String) searchParams.get("searchContent");

        //不限  1 有图  2 置顶 3 加精 4 举报
        if (!StringUtils.isEmpty(other)) {

            if ("1".equals(other)) {

            } else {
                searchParams.remove("EQ_other");
                if ("2".equals(other)) {
                    searchParams.put("EQ_isSticked", 1);
                }
                if ("3".equals(other)) {
                    searchParams.put("EQ_isExcellent", 1);
                }
                if ("4".equals(other)) {
                    searchParams.put("EQ_isReported", 1);
                }
            }
        } else {
            searchParams.remove("EQ_other");
        }
        if (StringUtils.isEmpty(mute)) {
            searchParams.remove("EQ_mute");
        }
        if (StringUtils.isEmpty(unCheckReply)) {
            searchParams.remove("EQ_unCheckReply");
        }

        if (searchParams.containsKey("LIKE_averageScore")) {
            String as = String.valueOf(searchParams.get("LIKE_averageScore"));
            if (!Strings.isNullOrEmpty(as) && as.split("\\.").length > 0) {
                Integer min = Integer.valueOf(as.split("\\.")[0]);
                searchParams.put("GTE_averageScore", min);
                searchParams.put("LT_andAverageScore", min + 1);
                searchParams.remove("LIKE_averageScore");
            }
        }

        searchParams.remove("searchType");
        searchParams.remove("searchContent");
        //1用户名  2 手机号
        if (!StringUtils.isEmpty(searchType)) {
            if ("1".equals(searchType)) {
                searchParams.put("EQ_criticName", searchContent);
            }
            if ("2".equals(searchType)) {
                searchParams.put("EQ_criticPhone", searchContent);
            }
        }

        // 开始时间 结束时间
        if (searchParams.get("GTE_commentTimeStart") != "" && searchParams.get("GTE_commentTimeStart") != null) {
            String commentTimeStart = searchParams.get("GTE_commentTimeStart") + " 00:00:00";
            searchParams.put("GTE_commentTimeStart", commentTimeStart);
        }
        if (searchParams.get("LTE_commentTimeEnd") != "" && searchParams.get("LTE_commentTimeEnd") != null) {
            String commentTimeEnd = searchParams.get("LTE_commentTimeEnd") + " 23:59:59";
            searchParams.put("LTE_commentTimeEnd", commentTimeEnd);
        }

        Page page = new Page(Page.TWENTY_PAGE_SIZE);
        if (null != number) {
            page.setCurrentPage(number);
        }
        CmHouseCommentListRequest listRequest = new CmHouseCommentListRequest();
        //去除删除的
        searchParams.put("EQ_isDeleted", 0);
        listRequest.setPaging(page);
        listRequest.setSearchParams(searchParams);
        listRequest.setOrderColumn("comment_date");
        listRequest.setOrderMode("desc");
        CmHouseCommentListResponse response = cmHouseComment.getCmHouseCommentList(listRequest);


        List<CmHouseCommentEntity> list = response.getObjectList();
        List<CmHouseCommentEntity> newList = new ArrayList<>();
        for (CmHouseCommentEntity cmHouseCommentEntity : list) {
            List<String> picList = new ArrayList<>();

            String criticPics = cmHouseCommentEntity.getCriticPictures();
            if (!StringUtils.isEmpty(criticPics)) {
                if (criticPics.contains(",")) {
                    String[] picArr = criticPics.split(",");
                    for (String string : picArr) {
                        picList.add(string);
                    }
                } else {
                    picList.add(criticPics);
                }
            }

            CmUserEntity user = cmUser.getCmUserById(cmHouseCommentEntity.getCriticId()).getEntity();
            Date now = new Date();
            if (user != null && user.getGagTime() != null && user.getGagTime().compareTo(now) > 0) {
                int remainHours = Integer.parseInt(
                        "" + ((user.getGagTime().getTime() - now.getTime()) / 1000 / 60 / 60));
                int remainMinutes = Integer.parseInt(
                        "" + ((user.getGagTime().getTime() - now.getTime()) / 1000 / 60 % 60));
                cmHouseCommentEntity.setIsDeleted(remainHours);
                cmHouseCommentEntity.setCityId(remainMinutes);
            }

            cmHouseCommentEntity.setPicList(picList);

            newList.add(cmHouseCommentEntity);
        }

        CmDictionaryResponse cmDictionaryResponse = cmDictionary.getCmDictionaryById(2);
        model.addAttribute("applyWhiteList", cmDictionaryResponse.getEntity().getDicValue());

        model.addAttribute("page", response.getPaging());
        model.addAttribute("cmHouseComments", list);
        model.addAttribute("searchParams", Servlets.encodeParameterStringWithPrefix(searchParams, "search_"));
        return getAutoUrl();
    }

    /**
     * 新房评论减一
     * 功能描述: <br>
     * 〈功能详细描述〉
     *
     * @param houseId
     * @author yinchangming
     * @version [v1.0.0, 2015年11月6日]
     * @since [产品/模块版本](可选)
     */

    private void decreaseHouseCommentAmountAndHouseScore(Integer houseId, String images, CmHouseCommentEntity entity) {
        try {
            CmHouseResponse house = cmHouse.getCmHouseById(houseId);
            CmHouseEntity houseEntity = house.getEntity();
            int leftAmount = houseEntity.getTotolCommetAmount() - 1;
            //五个分数值
            houseEntity.setEnviromentScore(
                    ((houseEntity.getEnviromentScore() * houseEntity.getTotolCommetAmount()) - entity.getEnvironmentScore()) / leftAmount);
            houseEntity.setInfrastructureScore(
                    ((houseEntity.getInfrastructureScore() * houseEntity.getTotolCommetAmount()) - entity.getInfrastructureScore()) / leftAmount);
            houseEntity.setPriceScore(
                    ((houseEntity.getPriceScore() * houseEntity.getTotolCommetAmount()) - entity.getPriceScore()) / leftAmount);
            houseEntity.setTrafficScore(
                    ((houseEntity.getTrafficScore() * houseEntity.getTotolCommetAmount()) - entity.getTrafficScore()) / leftAmount);
            houseEntity.setPlaceScore(
                    ((houseEntity.getPlaceScore() * houseEntity.getTotolCommetAmount()) - entity.getPlaceScore()) / leftAmount);
            houseEntity.setIntegrationScore(houseEntity.countIntegratedScore());
            houseEntity.setTotolCommetAmount(leftAmount);

            if (images != null && !(images.trim().equals(""))) {
                int withpc = houseEntity.getWithPictureCount() == null ? 1 : houseEntity.getWithPictureCount();
                houseEntity.setWithPictureCount((withpc - 1) < 0 ? 0 : (withpc - 1));
            } else {
                int nopc = houseEntity.getNoPictureCount() == null ? 1 : houseEntity.getNoPictureCount();
                houseEntity.setNoPictureCount((nopc - 1) < 0 ? 0 : (nopc - 1));
            }

            CmHouseRequest houseRequest = new CmHouseRequest();
            houseRequest.setEntity(houseEntity);
            cmHouse.updateCmHouse(houseRequest);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
