/**
 * Description: 只包含楼盘和经纪人评论删除后的扣分控制器
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2015-08-10 下午 17:06:10
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-08-10   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.web.controller;

import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import org.springside.modules.web.Servlets;

import com.house365.beans.system.Page;

import com.house365.beans.entity.CmCreditRemoveRecordEntity;
import com.house365.beans.vo.CmCreditRemoveRecordVo;

import com.house365.web.system.controller.BaseController;
import com.house365.web.util.StringUtils;
import com.house365.ws.beans.response.CmBrokerLabelResponse;

import com.house365.ws.beans.request.CmCreditRemoveRecordListRequest;
import com.house365.ws.beans.request.CmCreditRemoveRecordRequest;
import com.house365.ws.beans.response.CmCreditRemoveRecordListResponse;
import com.house365.ws.beans.response.CmCreditRemoveRecordResponse;
import com.house365.ws.interfaces.server.ICmCreditRemoveRecord;

/**
 * 只包含楼盘和经纪人评论删除后的扣分控制器<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-08-10
 * @see
 * @since 1.0
 */
@Controller
@RequestMapping("/cmcreditremoverecord")
public class CmCreditRemoveRecordController extends BaseController {

	/**
	 * 自动注入只包含楼盘和经纪人评论删除后的扣分WS实现
	 */
	@Autowired
	private ICmCreditRemoveRecord cmCreditRemoveRecord;

	/**
	 * 去新增只包含楼盘和经纪人评论删除后的扣分
	 * 
	 * @return 结果视图
	 */
	@RequestMapping(value = "", params = "action=create")
	public String createForm(Model model){
		model.addAttribute("action", "create");
		return getAutoUrl("form");
	}

	/**
	 * 新增只包含楼盘和经纪人评论删除后的扣分
	 * 
	 * @param cmCreditRemoveRecord 只包含楼盘和经纪人评论删除后的扣分页面表单对象
	 * @param result 表单验证数据
	 * @param page 分页配置
	 * @param request 请求对象
	 * @return 结果视图
	 */
	@RequestMapping(value = "", method = { RequestMethod.POST})
	public String createCmCreditRemoveRecord(@Valid CmCreditRemoveRecordVo vo, BindingResult result, RedirectAttributes redirectAttributes, Model model){
		CmCreditRemoveRecordEntity entity = vo.getEntity();
		model.addAttribute("entity", entity);
		// subValidation(result, entity);
		// 表单验证无误,进行提交
		if (result.hasErrors()) {
		    model.addAttribute("action", "create");
            addErrorMessage(model, result.getFieldError().getDefaultMessage());
            return getAutoUrl("form");
		} else {
		    try {
                CmCreditRemoveRecordRequest request = new CmCreditRemoveRecordRequest();
                request.setEntity(entity);
                CmCreditRemoveRecordResponse response = cmCreditRemoveRecord
                        .addCmCreditRemoveRecord(request);
                Integer id = response.getEntity().getId();
                return "redirect:/cmcreditremoverecord/" + id;
            } catch (Exception ex) {
                addErrorMessage(model, ex.getMessage());
                model.addAttribute("action", "create");
                return getAutoUrl("form");
            }
		}
	}

	/**
	 * 删除只包含楼盘和经纪人评论删除后的扣分
	 * 
	 * @param id 只包含楼盘和经纪人评论删除后的扣分页面表单对象唯一标识
	 * @param page 分页配置
	 * @param request 请求对象
	 * @return 结果视图
	 */
	@RequestMapping(value = "/{id}", method = { RequestMethod.DELETE })
	@ResponseStatus(HttpStatus.OK)
	public void delete(@PathVariable String id){
	    if(!StringUtils.isEmpty(id))
        {
            if(id.contains(","))
            {
                String[] ids = id.split(",");
                for (int i = 0; i < ids.length; i++) {
                    CmCreditRemoveRecordResponse response = cmCreditRemoveRecord.deleteCmCreditRemoveRecordById(Integer.valueOf(ids[i]));
                }
            }
            else
            {
                CmCreditRemoveRecordResponse response = cmCreditRemoveRecord.deleteCmCreditRemoveRecordById(Integer.valueOf(id));
            }
        }
	}

	/**
	 * 去查看只包含楼盘和经纪人评论删除后的扣分
	 * 
	 * @param id
	 *            只包含楼盘和经纪人评论删除后的扣分页面表单对象唯一标识
	 * @param request
	 *            请求对象
	 * @return 结果视图
	 */
	@RequestMapping(value = "/{id}", method = { RequestMethod.GET })
	public String showForm(@PathVariable(value = "id") Integer id, Model model) {
        CmCreditRemoveRecordResponse response = cmCreditRemoveRecord
                .getCmCreditRemoveRecordById(id);
        model.addAttribute("entity", response.getEntity());
        return getAutoUrl("form");
	}

	/**
	 * 去修改只包含楼盘和经纪人评论删除后的扣分
	 * 
	 * @param id 只包含楼盘和经纪人评论删除后的扣分页面表单对象唯一标识
	 * @param request 请求对象
	 * @return 结果视图
	 */
	@RequestMapping(value = "/{id}", method = { RequestMethod.GET}, params = "action=edit")
	public String updateForm(@PathVariable(value = "id") Integer id, Model model){
        CmCreditRemoveRecordResponse response = cmCreditRemoveRecord
                .getCmCreditRemoveRecordById(id);
        model.addAttribute("entity", response.getEntity());
		model.addAttribute("action", "edit");
		return getAutoUrl("form");
	}

	/**
	 * 修改只包含楼盘和经纪人评论删除后的扣分
	 * 
	 * @param cmCreditRemoveRecord 只包含楼盘和经纪人评论删除后的扣分页面表单对象
	 * @param result 表单验证数据
	 * @param page 分页配置
	 * @param request 请求对象
	 * @return 结果视图
	 */
	@RequestMapping(value = "/{id}", method = { RequestMethod.POST})
	public String updateCmCreditRemoveRecord(@Valid CmCreditRemoveRecordVo vo, BindingResult result, @PathVariable Integer id, RedirectAttributes redirectAttributes, Model model){
		CmCreditRemoveRecordEntity entity = vo.getEntity();
		model.addAttribute("entity", entity);
		// subValidation(result, entity);
		// 表单验证无误,进行提交
		if (result.hasErrors()) {
		    model.addAttribute("action", "create");
            addErrorMessage(model, result.getFieldError().getDefaultMessage());
            return getAutoUrl("form");
		} else {
            try {
                CmCreditRemoveRecordRequest request = new CmCreditRemoveRecordRequest();
                request.setEntity(entity);
                @SuppressWarnings("unused")
                CmCreditRemoveRecordResponse rersponse = cmCreditRemoveRecord
                        .updateCmCreditRemoveRecord(request);
                redirectAttributes.addAttribute("message", "更新成功");
                return "redirect:/cmcreditremoverecord/" + entity.getId();
            } catch (Exception ex) {
                addErrorMessage(model, ex.getMessage());
                model.addAttribute("action", "edit");
                return getAutoUrl("form");
            }
		}
	}

	/**
	 * 查询只包含楼盘和经纪人评论删除后的扣分
	 * 
	 * @param cmCreditRemoveRecord 只包含楼盘和经纪人评论删除后的扣分页面表单对象
	 * @param page 分页配置
	 * @param request 请求对象
	 * @return 结果视图
	 */
	@RequestMapping(value = "", method = RequestMethod.GET)
	public String list (Integer number, Model model, HttpServletRequest request) {
		// 获取查询条件
		Map<String, Object> searchParams = Servlets.getParametersStartingWith(
				request, "search_");
		Page page = new Page(Page.TWENTY_PAGE_SIZE);
		if (null != number) {
			page.setCurrentPage(number);
		}
		CmCreditRemoveRecordListRequest listRequest = new CmCreditRemoveRecordListRequest();
        listRequest.setPaging(page);
        listRequest.setSearchParams(searchParams);
        CmCreditRemoveRecordListResponse response = cmCreditRemoveRecord.getCmCreditRemoveRecordList(listRequest);
        model.addAttribute("page", response.getPaging());
        model.addAttribute("cmCreditRemoveRecords", response.getObjectList());
        model.addAttribute("searchParams", Servlets
                .encodeParameterStringWithPrefix(searchParams, "search_"));
		return getAutoUrl();
	}
}
