/**
 * Description: CmBroker控制器
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2015-08-10 下午 18:47:32
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-08-10   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.web.controller;

import com.house365.beans.entity.CmBrokerEntity;
import com.house365.beans.system.Page;
import com.house365.beans.vo.CmBrokerVo;
import com.house365.web.system.controller.BaseController;
import com.house365.web.util.StringUtils;
import com.house365.ws.beans.request.CmBrokerListRequest;
import com.house365.ws.beans.request.CmBrokerRequest;
import com.house365.ws.beans.response.CmBrokerListResponse;
import com.house365.ws.beans.response.CmBrokerResponse;
import com.house365.ws.interfaces.server.ICmBroker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import org.springside.modules.web.Servlets;

import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import java.util.Map;

/**
 * CmBroker控制器<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-08-10
 * @see
 * @since 1.0
 */
@Controller
@RequestMapping("/cmbroker")
public class CmBrokerController extends BaseController {

    /**
     * 自动注入CmBrokerWS实现
     */
    @Autowired
    private ICmBroker cmBroker;

    /**
     * 去新增CmBroker
     *
     * @return 结果视图
     */
    @RequestMapping(value = "", params = "action=create")
    public String createForm(Model model) {
        model.addAttribute("action", "create");
        return getAutoUrl("form");
    }

    /**
     * 新增CmBroker
     *
     * @param vo     CmBroker页面表单对象
     * @param result 表单验证数据
     * @return 结果视图
     */
    @RequestMapping(value = "", method = {RequestMethod.POST})
    public String createCmBroker(@Valid CmBrokerVo vo, BindingResult result, RedirectAttributes redirectAttributes, Model model) {
        CmBrokerEntity entity = vo.getEntity();
        model.addAttribute("entity", entity);
        // subValidation(result, entity);
        // 表单验证无误,进行提交
        if (result.hasErrors()) {
            model.addAttribute("action", "create");
            addErrorMessage(model, result.getFieldError().getDefaultMessage());
            return getAutoUrl("form");
        } else {
            try {
                CmBrokerRequest request = new CmBrokerRequest();
                request.setEntity(entity);
                CmBrokerResponse response = cmBroker
                        .addCmBroker(request);
                Integer id = response.getEntity().getId();
                return "redirect:/cmbroker/" + id;
            } catch (Exception ex) {
                addErrorMessage(model, ex.getMessage());
                model.addAttribute("action", "create");
                return getAutoUrl("form");
            }
        }
    }

    /**
     * 删除CmBroker
     *
     * @param id CmBroker页面表单对象唯一标识
     * @return 结果视图
     */
    @RequestMapping(value = "/{id}", method = {RequestMethod.DELETE})
    @ResponseStatus(HttpStatus.OK)
    public void delete(@PathVariable String id) {
        if (!StringUtils.isEmpty(id)) {
            if (id.contains(",")) {
                String[] ids = id.split(",");
                for (int i = 0; i < ids.length; i++) {
                    cmBroker.deleteCmBrokerById(Integer.valueOf(ids[i]));
                }
            } else {
                cmBroker.deleteCmBrokerById(Integer.valueOf(id));
            }
        }
    }

    /**
     * 去查看CmBroker
     *
     * @param id CmBroker页面表单对象唯一标识
     * @return 结果视图
     */
    @RequestMapping(value = "/{id}", method = {RequestMethod.GET})
    public String showForm(@PathVariable(value = "id") Integer id, Model model) {
        CmBrokerResponse response = cmBroker
                .getCmBrokerById(id);
        model.addAttribute("entity", response.getEntity());
        return getAutoUrl("form");
    }

    /**
     * 去修改CmBroker
     *
     * @param id CmBroker页面表单对象唯一标识
     * @return 结果视图
     */
    @RequestMapping(value = "/{id}", method = {RequestMethod.GET}, params = "action=edit")
    public String updateForm(@PathVariable(value = "id") Integer id, Model model) {
        CmBrokerResponse response = cmBroker
                .getCmBrokerById(id);
        model.addAttribute("entity", response.getEntity());
        model.addAttribute("action", "edit");
        return getAutoUrl("form");
    }

    /**
     * 修改CmBroker
     *
     * @param vo     CmBroker页面表单对象
     * @param result 表单验证数据
     * @return 结果视图
     */
    @RequestMapping(value = "/{id}", method = {RequestMethod.POST})
    public String updateCmBroker(@Valid CmBrokerVo vo, BindingResult result, @PathVariable Integer id, RedirectAttributes redirectAttributes, Model model) {
        CmBrokerEntity entity = vo.getEntity();
        model.addAttribute("entity", entity);
        // subValidation(result, entity);
        // 表单验证无误,进行提交
        if (result.hasErrors()) {
            model.addAttribute("action", "create");
            addErrorMessage(model, result.getFieldError().getDefaultMessage());
            return getAutoUrl("form");
        } else {
            try {
                CmBrokerRequest request = new CmBrokerRequest();
                request.setEntity(entity);
                @SuppressWarnings("unused")
                CmBrokerResponse rersponse = cmBroker.updateCmBroker(request);
                redirectAttributes.addAttribute("message", "更新成功");
                return "redirect:/cmbroker/" + entity.getId();
            } catch (Exception ex) {
                addErrorMessage(model, ex.getMessage());
                model.addAttribute("action", "edit");
                return getAutoUrl("form");
            }
        }
    }

    /**
     * 查询CmBroker
     *
     * @param request 请求对象
     * @return 结果视图
     */
    @RequestMapping(value = "", method = RequestMethod.GET)
    public String list(Integer number, Model model, HttpServletRequest request) {
        // 获取查询条件
        Map<String, Object> searchParams = Servlets.getParametersStartingWith(request, "search_");
        Page page = new Page(Page.TWENTY_PAGE_SIZE);
        if (null != number) {
            page.setCurrentPage(number);
        }
        CmBrokerListRequest listRequest = new CmBrokerListRequest();
        listRequest.setPaging(page);
        listRequest.setSearchParams(searchParams);
        CmBrokerListResponse response = cmBroker.getCmBrokerList(listRequest);
        model.addAttribute("page", response.getPaging());
        model.addAttribute("cmBrokers", response.getObjectList());
        model.addAttribute("searchParams", Servlets
                .encodeParameterStringWithPrefix(searchParams, "search_"));
        return getAutoUrl();
    }
}
