/**
 * Description: KlfCity数据库实体/领域对象
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2015-07-10 上午 10:47:22
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-07-10   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.beans.entity;

import com.house365.beans.system.DomainObject;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;

/**
 * KlfCity数据库实体/领域对象<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-07-10
 * @see
 * @since 1.0
 */
public class KlfCityEntity extends DomainObject {

    private static final long serialVersionUID = 1L;

    /**
     * 城市名称
     */
    @Length(max = 60, message = "长度需要大于0且小于60")
    @NotEmpty(message = "城市名称不能为空！")
    private String name;

    /**
     * 是否使用-0:未使用，1:已使用
     */
    private Integer used;

    @NotEmpty(message = "城市编码不能为空！")
    private String code;

    /**
     * 拼音
     */
    private String py;

    public String getPy() {
        return py;
    }

    public void setPy(String py) {
        this.py = py;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    /**
     * 设置城市名称
     * @param name 城市名称
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * 获取城市名称
     * @return 城市名称
     */
    public String getName() {
        return this.name;
    }

    /**
     * 设置是否使用-0:未使用，1:已使用
     * @param used 是否使用-0:未使用，1:已使用
     */
    public void setUsed(Integer used) {
        this.used = used;
    }

    /**
     * 获取是否使用-0:未使用，1:已使用
     * @return 是否使用-0:未使用，1:已使用
     */
    public Integer getUsed() {
        return this.used;
    }

    /**
     * 实体的toString方法
     * @return 实体字符串
     */
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
                .append("Id", getId())
                .append("Name", getName())
                .append("Used", getUsed())
                .toString();
    }

    /**
     * 获取hash码
     * @return HASH码
     */
    public int hashCode() {
        return new HashCodeBuilder()
                .append(getId())
                .toHashCode();
    }

    /**
     * 对象比较
     * @param obj 待比较对象
     * @return 是否相同<li>true--相同<li>false--不相同
     */
    public boolean equals(Object obj) {
        if (obj instanceof KlfCityEntity == false) return false;
        if (this == obj) return true;
        KlfCityEntity other = (KlfCityEntity) obj;
        return new EqualsBuilder()
                .append(getId(), other.getId())
                .isEquals();
    }
}

