/**
 * Description: CmUser数据库实体/领域对象
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2015-08-10 下午 17:06:21
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-08-10   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.beans.entity;

import com.house365.beans.system.DomainObject;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;

import java.util.Date;

/**
 * CmUser数据库实体/领域对象<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-08-10
 * @see
 * @since 1.0
 */
public class CmUserEntity extends DomainObject {
    /**
     *
     */
    private static final long serialVersionUID = 1L;

    //可以直接使用: @Length(max=50,message="用户名长度不能大于50")显示错误消息
    /**
     * 注册手机
     */
    @Length(max = 20, message = "长度需要大于0且小于20")
    private String phoneNumber;

    /**
     * 用户名
     */
    @Length(max = 20, message = "长度需要大于0且小于20")
    private String userName;

    /**
     * 用户姓名
     */
    @Length(max = 20, message = "长度需要大于0且小于20")
    private String realName;

    /**
     * 积分
     */

    private Integer credits;

    /**
     * 用户中心
     */
    @Length(max = 64, message = "长度需要大于0且小于64")
    private String userId;

    /**
     * 邀请总人数
     */
    private Integer inviteCount;
    /**
     * 邀请总积分数
     */
    private Integer inviteCredits;
    /**
     * 第二用户中心
     */
    @Length(max = 64, message = "长度需要大于0且小于64")
    private String secondUserId;

    /**
     * 城市ID
     */
    @Length(max = 64, message = "长度需要大于0且小于64")
    private String cityId;

    /**
     * 城市
     */
    @Length(max = 64, message = "长度需要大于0且小于64")
    private String city;

    /**
     * 创建时间
     */
    private java.util.Date createTime;

    /**
     * 更新时间
     */

    private java.util.Date updateTime;

    /**
     * 用户状态，0:正常，1:停用
     */

    private Integer status;

    /**
     * 是否删除 0:否
     */

    private Integer isDeleted;

    /**
     * 禁言期限
     */

    private java.util.Date gagTime;

    /**
     * 被举报次数
     */
    private Integer reportedCount;

    /**
     * 邀请人Id
     */
    private Integer inviter;

    /**
     * 邀请码
     */
    private Integer inviteCode;

    /**
     * 事业部id
     */
    private Integer divisionId;

    /**
     * 事业部id
     */
    private String divisionName;

    /**
     * 邀请一个人积分
     */
    private Integer inviteScore;

    /**
     * 最近一次签到时间
     */
    private Date lastSignTime;
    /**
     * 最近一次签到大转盘抽奖时间
     */
    private Date lastSignLotteryTime;

    /**
     * 连续签到天数
     */
    private Integer continuousSignCount;

    /**
     * 今日签到积分
     */
    private Integer todaySignedCredits;

    /**
     * 用户来源 1:app 2:网站 3:触屏
     */
    private Integer source;

    /**
     * 用户ID类型：1:用户中心账号 2:其他库账号
     */
    private Integer useridType;

    /**
     * 用户头像（没传为默认头像）
     */
    private String userPhoto;

    /**
     * 用户头像（没传为空）
     */
    private String userTruePhoto;

    /**
     * 0:未签到 1：签到
     */
    private Integer isSignedToday;

    /**
     * 0:未抽奖 1：抽奖
     */
    private Integer isLotterySignedToday;
    /**
     * 兑换次数相关
     */
    private Integer exchangeCountLimit;//周期累计数量上限
    private Integer exchangeCountCircle;//累计周期 天数
    private Integer exchangeCount;//周期累计订单数量
    private Integer limitProductOrderCount;//周期累计限购商品订单数量
    //今日签到可获得积分
    private Integer canGetSignCreditToday;
    //明日签到可获得积分
    private Integer canGetSignCreditTomorrow;
    private String deviceid;
    private Integer unreadReply;
    //用户是否注销（0未注销-1注销）
    private int code;

    public Integer getUnreadReply() {
        return unreadReply;
    }

    public void setUnreadReply(Integer unreadReply) {
        this.unreadReply = unreadReply;
    }

    public Integer getIsLotterySignedToday() {
        return isLotterySignedToday;
    }

    public void setIsLotterySignedToday(Integer isLotterySignedToday) {
        this.isLotterySignedToday = isLotterySignedToday;
    }

    public String getDeviceid() {
        return deviceid;
    }

    public void setDeviceid(String deviceid) {
        this.deviceid = deviceid;
    }

    public Integer getLimitProductOrderCount() {
        return limitProductOrderCount;
    }

    public void setLimitProductOrderCount(Integer limitProductOrderCount) {
        this.limitProductOrderCount = limitProductOrderCount;
    }

    public Integer getCanGetSignCreditToday() {
        return canGetSignCreditToday;
    }

    public void setCanGetSignCreditToday(Integer canGetSignCreditToday) {
        this.canGetSignCreditToday = canGetSignCreditToday;
    }

    public Integer getCanGetSignCreditTomorrow() {
        return canGetSignCreditTomorrow;
    }

    public void setCanGetSignCreditTomorrow(Integer canGetSignCreditTomorrow) {
        this.canGetSignCreditTomorrow = canGetSignCreditTomorrow;
    }

    public String getUserTruePhoto() {
        return userTruePhoto;
    }

    public void setUserTruePhoto(String userTruePhoto) {
        this.userTruePhoto = userTruePhoto;
    }

    public Integer getIsSignedToday() {
        return isSignedToday;
    }

    public void setIsSignedToday(Integer isSignedToday) {
        this.isSignedToday = isSignedToday;
    }

    public Integer getExchangeCountLimit() {
        return exchangeCountLimit;
    }

    public void setExchangeCountLimit(Integer exchangeCountLimit) {
        this.exchangeCountLimit = exchangeCountLimit;
    }

    public Integer getExchangeCountCircle() {
        return exchangeCountCircle;
    }

    public void setExchangeCountCircle(Integer exchangeCountCircle) {
        this.exchangeCountCircle = exchangeCountCircle;
    }

    public Integer getExchangeCount() {
        return exchangeCount;
    }

    public void setExchangeCount(Integer exchangeCount) {
        this.exchangeCount = exchangeCount;
    }

    public String getUserPhoto() {
        return userPhoto;
    }

    public void setUserPhoto(String userPhoto) {
        this.userPhoto = userPhoto;
    }

    public Integer getTodaySignedCredits() {
        return todaySignedCredits;
    }

    public void setTodaySignedCredits(Integer todaySignedCredits) {
        this.todaySignedCredits = todaySignedCredits;
    }

    public Integer getDivisionId() {
        return divisionId;
    }

    public void setDivisionId(Integer divisionId) {
        this.divisionId = divisionId;
    }

    public String getDivisionName() {
        return divisionName;
    }

    public void setDivisionName(String divisionName) {
        this.divisionName = divisionName;
    }

    public Integer getInviteScore() {
        return inviteScore;
    }

    public void setInviteScore(Integer inviteScore) {
        this.inviteScore = inviteScore;
    }

    public Integer getSource() {
        return source;
    }

    public void setSource(Integer source) {
        this.source = source;
    }

    public Integer getUseridType() {
        return useridType;
    }

    public void setUseridType(Integer useridType) {
        this.useridType = useridType;
    }

    public java.util.Date getGagTime() {
        return gagTime;
    }

    public void setGagTime(java.util.Date gagTime) {
        this.gagTime = gagTime;
    }

    public Date getLastSignLotteryTime() {
        return lastSignLotteryTime;
    }

    public void setLastSignLotteryTime(Date lastSignLotteryTime) {
        this.lastSignLotteryTime = lastSignLotteryTime;
    }

    public Integer getReportedCount() {
        return reportedCount;
    }

    public void setReportedCount(Integer reportedCount) {
        this.reportedCount = reportedCount;
    }

    /**
     * 获取注册手机
     *
     * @return 注册手机
     */
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    /**
     * 设置注册手机
     *
     * @param phoneNumber 注册手机
     */
    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    /**
     * 获取用户姓名
     *
     * @return 用户姓名
     */
    public String getUserName() {
        return this.userName;
    }

    /**
     * 设置用户姓名
     *
     * @param userName 用户姓名
     */
    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getRealName() {
        return realName;
    }

    public void setRealName(String realName) {
        this.realName = realName;
    }

    public Date getLastSignTime() {
        return lastSignTime;
    }

    public void setLastSignTime(Date lastSignTime) {
        this.lastSignTime = lastSignTime;
    }

    public Integer getContinuousSignCount() {
        return continuousSignCount;
    }

    public void setContinuousSignCount(Integer continuousSignCount) {
        this.continuousSignCount = continuousSignCount;
    }

    /**
     * 获取积分
     *
     * @return 积分
     */
    public Integer getCredits() {
        return this.credits;
    }

    /**
     * 设置积分
     *
     * @param credits 积分
     */
    public void setCredits(Integer credits) {
        this.credits = credits;
    }

    /**
     * 获取用户中心
     *
     * @return 用户中心
     */
    public String getUserId() {
        return this.userId;
    }

    /**
     * 设置用户中心
     *
     * @param userId 用户中心
     */
    public void setUserId(String userId) {
        this.userId = userId;
    }

    /**
     * 获取第二用户中心
     *
     * @return 第二用户中心
     */
    public String getSecondUserId() {
        return this.secondUserId;
    }

    /**
     * 设置第二用户中心
     *
     * @param secondUserId 第二用户中心
     */
    public void setSecondUserId(String secondUserId) {
        this.secondUserId = secondUserId;
    }

    /**
     * 获取城市ID
     *
     * @return 城市ID
     */
    public String getCityId() {
        return this.cityId;
    }

    /**
     * 设置城市ID
     *
     * @param cityId 城市ID
     */
    public void setCityId(String cityId) {
        this.cityId = cityId;
    }

    /**
     * 获取城市名
     *
     * @return 城市
     */
    public String getCity() {
        return this.city;
    }

    /**
     * 设置城市
     *
     * @param city 城市
     */
    public void setCity(String city) {
        this.city = city;
    }

    /**
     * 设置创建时间字符串格式
     *
     * @param createTime 创建时间
     */
    public void setCreateTimeStr(String createTime) {
        if (!com.house365.web.util.StringUtils.isBlank(createTime)) {
            try {
                this.createTime = java.text.DateFormat.getDateTimeInstance().parse(createTime);
            } catch (java.text.ParseException ex) {
                ex.printStackTrace();
            }
        }
    }

    public Integer getInviteCount() {
        return inviteCount;
    }

    public void setInviteCount(Integer inviteCount) {
        this.inviteCount = inviteCount;
    }

    public Integer getInviteCredits() {
        return inviteCredits;
    }

    public void setInviteCredits(Integer inviteCredits) {
        this.inviteCredits = inviteCredits;
    }

    public Integer getInviter() {
        return inviter;
    }

    public void setInviter(Integer inviter) {
        this.inviter = inviter;
    }

    public Integer getInviteCode() {
        return inviteCode;
    }

    public void setInviteCode(Integer inviteCode) {
        this.inviteCode = inviteCode;
    }

    /**
     * 获取创建时间
     *
     * @return 创建时间
     */
    public java.util.Date getCreateTime() {
        return this.createTime;
    }

    /**
     * 设置创建时间
     *
     * @param createTime 创建时间
     */
    public void setCreateTime(java.util.Date createTime) {
        this.createTime = createTime;
    }

    /**
     * 设置更新时间字符串格式
     *
     * @param updateTime 更新时间
     */
    public void setUpdateTimeStr(String updateTime) {
        if (!com.house365.web.util.StringUtils.isBlank(updateTime)) {
            try {
                this.updateTime = java.text.DateFormat.getDateTimeInstance().parse(updateTime);
            } catch (java.text.ParseException ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取更新时间
     *
     * @return 更新时间
     */
    public java.util.Date getUpdateTime() {
        return this.updateTime;
    }

    /**
     * 设置更新时间
     *
     * @param updateTime 更新时间
     */
    public void setUpdateTime(java.util.Date updateTime) {
        this.updateTime = updateTime;
    }

    /**
     * 获取用户状态，0:正常，1:停用
     *
     * @return 用户状态，0:正常，1:停用
     */
    public Integer getStatus() {
        return this.status;
    }

    /**
     * 设置用户状态，0:正常，1:停用
     *
     * @param status 用户状态，0:正常，1:停用
     */
    public void setStatus(Integer status) {
        this.status = status;
    }

    /**
     * 获取是否删除 0:否
     *
     * @return 是否删除 0:否
     */
    public Integer getIsDeleted() {
        return this.isDeleted;
    }

    /**
     * 设置是否删除 0:否
     *
     * @param isDeleted 是否删除 0:否
     */
    public void setIsDeleted(Integer isDeleted) {
        this.isDeleted = isDeleted;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    /**
     * 实体的toString方法
     *
     * @return 实体字符串
     */
    @Override
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE).append("Id", getId()).append("PhoneNumber",
                getPhoneNumber()).append(
                "UserName", getUserName()).append("Credits", getCredits()).append("UserId", getUserId()).append(
                "SecondUserId", getSecondUserId()).append("CityId", getCityId()).append("City", getCity()).append(
                "CreateTime", getCreateTime()).append("UpdateTime", getUpdateTime()).append("Status", getStatus()).append(
                "IsDeleted", getIsDeleted()).toString();
    }

    /**
     * 获取hash码
     *
     * @return HASH码
     */
    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(getId()).toHashCode();
    }

    /**
     * 对象比较
     *
     * @param obj 待比较对象
     * @return 是否相同<li>true--相同<li>false--不相同
     */
    @Override
    public boolean equals(Object obj) {
        if (obj instanceof CmUserEntity == false) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        CmUserEntity other = (CmUserEntity) obj;
        return new EqualsBuilder().append(getId(), other.getId()).isEquals();
    }
}

