/**
 * Description: KlfSmsCode数据库实体/领域对象
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2015-07-06 下午 14:00:59
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-07-06   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.beans.entity;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;

import com.house365.beans.system.DomainObject;

/**
 * KlfSmsCode数据库实体/领域对象<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-07-06
 * @see
 * @since 1.0
 */
public class CmSmsCodeEntity extends DomainObject{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	//可以直接使用: @Length(max=50,message="用户名长度不能大于50")显示错误消息
	//columns START
	/**
	 * 手机号
	 */
	@Length(max=30, message="长度需要大于0且小于30")
	private String phone;
	
	/**
	 * 验证码
	 */
	@Length(max=30, message="长度需要大于0且小于30")
	private String authCode;
	
	/**
	 * 发送时间
	 */
	
	private java.util.Date sendTime;
	
	/**
	 * 发送当天时间
	 */
	
	private java.util.Date todayDate;
	
	/**
	 * 城市
	 */
	@Length(max=30, message="长度需要大于0且小于30")
	private String city;
	
	/**
	 * 短信发送次数
	 */
	
	private Integer smsCount;
	
	/**
	 * 创建者ID
	 */
	
	private Integer createUserId;
	
	/**
	 * 创建者姓名
	 */
	@Length(max=30, message="长度需要大于0且小于30")
	private String createUserName;
	
	/**
	 * 创建时间
	 */
	
	private java.util.Date createTime;
	
	//columns END
	/*
	public KlfSmsCode(){
	}

	public KlfSmsCode(
		Integer id
	){
		this.id = id;
	}

    */

	/**
	 * 设置手机号
	 * @param phone 手机号
	 */
	public void setPhone(String phone) {
		this.phone = phone;
	}

	/**
	 * 获取手机号
	 * @return 手机号
	 */
	public String getPhone() {
		return this.phone;
	}

	/**
	 * 设置验证码
	 * @param authCode 验证码
	 */
	public void setAuthCode(String authCode) {
		this.authCode = authCode;
	}

	/**
	 * 获取验证码
	 * @return 验证码
	 */
	public String getAuthCode() {
		return this.authCode;
	}

	/**
	 * 设置发送时间
	 * @param sendTime 发送时间
	 */
	public void setSendTime(java.util.Date sendTime) {
		this.sendTime = sendTime;
	}

	/**
	 * 设置发送时间字符串格式
	 * @param sendTime 发送时间
	 */
	public void setSendTimeStr(String sendTime) {
		if (!com.house365.web.util.StringUtils.isBlank(sendTime)) {
			try {
				this.sendTime = java.text.DateFormat.getDateTimeInstance().parse(sendTime);
			} catch (java.text.ParseException ex) {
				ex.printStackTrace();
			}
		}
	}

	/**
	 * 获取发送时间
	 * @return 发送时间
	 */
	public java.util.Date getSendTime() {
		return this.sendTime;
	}

	/**
	 * 设置发送当天时间
	 * @param todayDate 发送当天时间
	 */
	public void setTodayDate(java.util.Date todayDate) {
		this.todayDate = todayDate;
	}

	/**
	 * 设置发送当天时间字符串格式
	 * @param todayDate 发送当天时间
	 */
	public void setTodayDateStr(String todayDate) {
		if (!com.house365.web.util.StringUtils.isBlank(todayDate)) {
			try {
				this.todayDate = java.text.DateFormat.getDateTimeInstance().parse(todayDate);
			} catch (java.text.ParseException ex) {
				ex.printStackTrace();
			}
		}
	}

	/**
	 * 获取发送当天时间
	 * @return 发送当天时间
	 */
	public java.util.Date getTodayDate() {
		return this.todayDate;
	}

	/**
	 * 设置城市
	 * @param city 城市
	 */
	public void setCity(String city) {
		this.city = city;
	}

	/**
	 * 获取城市
	 * @return 城市
	 */
	public String getCity() {
		return this.city;
	}

	/**
	 * 设置短信发送次数
	 * @param smsCount 短信发送次数
	 */
	public void setSmsCount(Integer smsCount) {
		this.smsCount = smsCount;
	}

	/**
	 * 获取短信发送次数
	 * @return 短信发送次数
	 */
	public Integer getSmsCount() {
		return this.smsCount;
	}

	/**
	 * 设置创建者ID
	 * @param createUserId 创建者ID
	 */
	public void setCreateUserId(Integer createUserId) {
		this.createUserId = createUserId;
	}

	/**
	 * 获取创建者ID
	 * @return 创建者ID
	 */
	public Integer getCreateUserId() {
		return this.createUserId;
	}

	/**
	 * 设置创建者姓名
	 * @param createUserName 创建者姓名
	 */
	public void setCreateUserName(String createUserName) {
		this.createUserName = createUserName;
	}

	/**
	 * 获取创建者姓名
	 * @return 创建者姓名
	 */
	public String getCreateUserName() {
		return this.createUserName;
	}

	/**
	 * 设置创建时间
	 * @param createTime 创建时间
	 */
	public void setCreateTime(java.util.Date createTime) {
		this.createTime = createTime;
	}

	/**
	 * 设置创建时间字符串格式
	 * @param createTime 创建时间
	 */
	public void setCreateTimeStr(String createTime) {
		if (!com.house365.web.util.StringUtils.isBlank(createTime)) {
			try {
				this.createTime = java.text.DateFormat.getDateTimeInstance().parse(createTime);
			} catch (java.text.ParseException ex) {
				ex.printStackTrace();
			}
		}
	}

	/**
	 * 获取创建时间
	 * @return 创建时间
	 */
	public java.util.Date getCreateTime() {
		return this.createTime;
	}

    /**
     * 实体的toString方法
     * @return 实体字符串
     */
	public String toString() {
		return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
			.append("Id",getId())
			.append("Phone",getPhone())
			.append("AuthCode",getAuthCode())
			.append("SendTime",getSendTime())
			.append("TodayDate",getTodayDate())
			.append("City",getCity())
			.append("SmsCount",getSmsCount())
			.append("CreateUserId",getCreateUserId())
			.append("CreateUserName",getCreateUserName())
			.append("CreateTime",getCreateTime())
			.toString();
	}

	/**
	 * 获取hash码
	 * @return HASH码
	 */
	public int hashCode() {
		return new HashCodeBuilder()
			.append(getId())
			.toHashCode();
	}

	/**
	 * 对象比较
	 * @param obj 待比较对象
	 * @return 是否相同<li>true--相同<li>false--不相同
	 */
	public boolean equals(Object obj) {
		if(obj instanceof CmSmsCodeEntity == false) return false;
		if(this == obj) return true;
		CmSmsCodeEntity other = (CmSmsCodeEntity)obj;
		return new EqualsBuilder()
			.append(getId(),other.getId())
			.isEquals();
	}
}

