/**
 * Description: CmSeckillBooked数据库实体/领域对象
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2015-11-29 下午 14:08:43
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-11-29   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.beans.entity;

import javax.validation.constraints.*;
import com.house365.beans.system.DomainObject;
import org.hibernate.validator.constraints.*;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * CmSeckillBooked数据库实体/领域对象<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-11-29
 * @see
 * @since 1.0
 */
public class CmSeckillBookedEntity extends DomainObject{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	//可以直接使用: @Length(max=50,message="用户名长度不能大于50")显示错误消息
	//columns START
	/**
	 * 用户ID
	 */
	@Length(max=20, message="长度需要大于0且小于20")
	private String userId;
	
	/**
	 * 用户手机
	 */
	@Length(max=100, message="长度需要大于0且小于100")
	private String userPhone;
	
	/**
	 * 商品ID
	 */
	
	private Integer goodId;
	
	/**
	 * 秒杀开始时间
	 */
	
	private java.util.Date remindTime;
	
	/**
	 * 创建时间
	 */
	
	private java.util.Date createTime;
	
	/**
	 * 状态 0:未提交订单 1:失效
	 */
	
	private Integer status;
	
	//columns END
	/*
	public CmSeckillBooked(){
	}

	public CmSeckillBooked(
		Integer id
	){
		this.id = id;
	}

    */

	/**
	 * 设置用户ID
	 * @param userId 用户ID
	 */
	public void setUserId(String userId) {
		this.userId = userId;
	}

	/**
	 * 获取用户ID
	 * @return 用户ID
	 */
	public String getUserId() {
		return this.userId;
	}

	/**
	 * 设置用户手机
	 * @param userPhone 用户手机
	 */
	public void setUserPhone(String userPhone) {
		this.userPhone = userPhone;
	}

	/**
	 * 获取用户手机
	 * @return 用户手机
	 */
	public String getUserPhone() {
		return this.userPhone;
	}

	/**
	 * 设置商品ID
	 * @param goodId 商品ID
	 */
	public void setGoodId(Integer goodId) {
		this.goodId = goodId;
	}

	/**
	 * 获取商品ID
	 * @return 商品ID
	 */
	public Integer getGoodId() {
		return this.goodId;
	}

	/**
	 * 设置秒杀开始时间
	 * @param remindTime 秒杀开始时间
	 */
	public void setRemindTime(java.util.Date remindTime) {
		this.remindTime = remindTime;
	}

	/**
	 * 设置秒杀开始时间字符串格式
	 * @param remindTime 秒杀开始时间
	 */
	public void setRemindTimeStr(String remindTime) {
		if (!com.house365.web.util.StringUtils.isBlank(remindTime)) {
			try {
				this.remindTime = java.text.DateFormat.getDateTimeInstance().parse(remindTime);
			} catch (java.text.ParseException ex) {
				ex.printStackTrace();
			}
		}
	}

	/**
	 * 获取秒杀开始时间
	 * @return 秒杀开始时间
	 */
	public java.util.Date getRemindTime() {
		return this.remindTime;
	}

	/**
	 * 设置创建时间
	 * @param createTime 创建时间
	 */
	public void setCreateTime(java.util.Date createTime) {
		this.createTime = createTime;
	}

	/**
	 * 设置创建时间字符串格式
	 * @param createTime 创建时间
	 */
	public void setCreateTimeStr(String createTime) {
		if (!com.house365.web.util.StringUtils.isBlank(createTime)) {
			try {
				this.createTime = java.text.DateFormat.getDateTimeInstance().parse(createTime);
			} catch (java.text.ParseException ex) {
				ex.printStackTrace();
			}
		}
	}

	/**
	 * 获取创建时间
	 * @return 创建时间
	 */
	public java.util.Date getCreateTime() {
		return this.createTime;
	}

	/**
	 * 设置状态 0:未提交订单 1:失效
	 * @param status 状态 0:未提交订单 1:失效
	 */
	public void setStatus(Integer status) {
		this.status = status;
	}

	/**
	 * 获取状态 0:未提交订单 1:失效
	 * @return 状态 0:未提交订单 1:失效
	 */
	public Integer getStatus() {
		return this.status;
	}

    /**
     * 实体的toString方法
     * @return 实体字符串
     */
	public String toString() {
		return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
			.append("Id",getId())
			.append("UserId",getUserId())
			.append("UserPhone",getUserPhone())
			.append("GoodId",getGoodId())
			.append("RemindTime",getRemindTime())
			.append("CreateTime",getCreateTime())
			.append("Status",getStatus())
			.toString();
	}

	/**
	 * 获取hash码
	 * @return HASH码
	 */
	public int hashCode() {
		return new HashCodeBuilder()
			.append(getId())
			.toHashCode();
	}

	/**
	 * 对象比较
	 * @param obj 待比较对象
	 * @return 是否相同<li>true--相同<li>false--不相同
	 */
	public boolean equals(Object obj) {
		if(obj instanceof CmSeckillBookedEntity == false) return false;
		if(this == obj) return true;
		CmSeckillBookedEntity other = (CmSeckillBookedEntity)obj;
		return new EqualsBuilder()
			.append(getId(),other.getId())
			.isEquals();
	}
}

