/**
 * Description: CmRemoveGoods数据库实体/领域对象
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2015-08-10 下午 17:06:20
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-08-10   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.beans.entity;

import javax.validation.constraints.*;
import com.house365.beans.system.DomainObject;
import org.hibernate.validator.constraints.*;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * CmRemoveGoods数据库实体/领域对象<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-08-10
 * @see
 * @since 1.0
 */
public class CmRemoveGoodsEntity extends DomainObject{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	//可以直接使用: @Length(max=50,message="用户名长度不能大于50")显示错误消息
	//columns START
	/**
	 * 商品ID
	 */
	
	private Integer goodsId;
	
	/**
	 * 商品名称
	 */
	@Length(max=30, message="长度需要大于0且小于30")
	private String goodsName;
	
	/**
	 * 商品数量
	 */
	
	private Integer goodsAmount;
	
	/**
	 * 下架时间
	 */
	
	private java.util.Date undercarriageTime;
	
	/**
	 * 城市编号
	 */
	
	private Integer cityId;
	
	/**
	 * 城市名称
	 */
	@Length(max=20, message="长度需要大于0且小于20")
	private String cityName;
	
	/**
	 * 操作人员编号
	 */
	
	private Integer operatorId;
	
	/**
	 * 操作人员名称
	 */
	@Length(max=20, message="长度需要大于0且小于20")
	private String operatorName;
	
	//columns END
	/*
	public CmRemoveGoods(){
	}

	public CmRemoveGoods(
		Integer id
	){
		this.id = id;
	}

    */

	/**
	 * 设置商品ID
	 * @param goodsId 商品ID
	 */
	public void setGoodsId(Integer goodsId) {
		this.goodsId = goodsId;
	}

	/**
	 * 获取商品ID
	 * @return 商品ID
	 */
	public Integer getGoodsId() {
		return this.goodsId;
	}

	/**
	 * 设置商品名称
	 * @param goodsName 商品名称
	 */
	public void setGoodsName(String goodsName) {
		this.goodsName = goodsName;
	}

	/**
	 * 获取商品名称
	 * @return 商品名称
	 */
	public String getGoodsName() {
		return this.goodsName;
	}

	/**
	 * 设置商品数量
	 * @param goodsAmount 商品数量
	 */
	public void setGoodsAmount(Integer goodsAmount) {
		this.goodsAmount = goodsAmount;
	}

	/**
	 * 获取商品数量
	 * @return 商品数量
	 */
	public Integer getGoodsAmount() {
		return this.goodsAmount;
	}

	/**
	 * 设置下架时间
	 * @param undercarriageTime 下架时间
	 */
	public void setUndercarriageTime(java.util.Date undercarriageTime) {
		this.undercarriageTime = undercarriageTime;
	}

	/**
	 * 设置下架时间字符串格式
	 * @param undercarriageTime 下架时间
	 */
	public void setUndercarriageTimeStr(String undercarriageTime) {
		if (!com.house365.web.util.StringUtils.isBlank(undercarriageTime)) {
			try {
				this.undercarriageTime = java.text.DateFormat.getDateTimeInstance().parse(undercarriageTime);
			} catch (java.text.ParseException ex) {
				ex.printStackTrace();
			}
		}
	}

	/**
	 * 获取下架时间
	 * @return 下架时间
	 */
	public java.util.Date getUndercarriageTime() {
		return this.undercarriageTime;
	}

	/**
	 * 设置城市编号
	 * @param cityId 城市编号
	 */
	public void setCityId(Integer cityId) {
		this.cityId = cityId;
	}

	/**
	 * 获取城市编号
	 * @return 城市编号
	 */
	public Integer getCityId() {
		return this.cityId;
	}

	/**
	 * 设置城市名称
	 * @param cityName 城市名称
	 */
	public void setCityName(String cityName) {
		this.cityName = cityName;
	}

	/**
	 * 获取城市名称
	 * @return 城市名称
	 */
	public String getCityName() {
		return this.cityName;
	}

	/**
	 * 设置操作人员编号
	 * @param operatorId 操作人员编号
	 */
	public void setOperatorId(Integer operatorId) {
		this.operatorId = operatorId;
	}

	/**
	 * 获取操作人员编号
	 * @return 操作人员编号
	 */
	public Integer getOperatorId() {
		return this.operatorId;
	}

	/**
	 * 设置操作人员名称
	 * @param operatorName 操作人员名称
	 */
	public void setOperatorName(String operatorName) {
		this.operatorName = operatorName;
	}

	/**
	 * 获取操作人员名称
	 * @return 操作人员名称
	 */
	public String getOperatorName() {
		return this.operatorName;
	}

    /**
     * 实体的toString方法
     * @return 实体字符串
     */
	public String toString() {
		return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
			.append("Id",getId())
			.append("GoodsId",getGoodsId())
			.append("GoodsName",getGoodsName())
			.append("GoodsAmount",getGoodsAmount())
			.append("UndercarriageTime",getUndercarriageTime())
			.append("CityId",getCityId())
			.append("CityName",getCityName())
			.append("OperatorId",getOperatorId())
			.append("OperatorName",getOperatorName())
			.toString();
	}

	/**
	 * 获取hash码
	 * @return HASH码
	 */
	public int hashCode() {
		return new HashCodeBuilder()
			.append(getId())
			.toHashCode();
	}

	/**
	 * 对象比较
	 * @param obj 待比较对象
	 * @return 是否相同<li>true--相同<li>false--不相同
	 */
	public boolean equals(Object obj) {
		if(obj instanceof CmRemoveGoodsEntity == false) return false;
		if(this == obj) return true;
		CmRemoveGoodsEntity other = (CmRemoveGoodsEntity)obj;
		return new EqualsBuilder()
			.append(getId(),other.getId())
			.isEquals();
	}
}

