/**
 * Description: 商品促销关联数据库实体/领域对象
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2016-09-01 下午 14:16:03
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-01   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.beans.entity;

import javax.validation.constraints.*;
import com.house365.beans.system.DomainObject;
import org.hibernate.validator.constraints.*;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * 商品促销关联数据库实体/领域对象<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-01
 * @see
 * @since 1.0
 */
public class CmPromotionProductEntity extends DomainObject{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	//可以直接使用: @Length(max=50,message="用户名长度不能大于50")显示错误消息
	//columns START
	/**
	 * productId
	 */
	@NotNull 
	private Integer productId;
	
	/**
	 * promotionId
	 */
	@NotNull 
	private Integer promotionId;
	
	/**
	 * 配置信息
	 */
	@Length(max=200, message="长度需要大于0且小于200")
	private String configKey;
	
	/**
	 * creater
	 */
	@Length(max=45, message="长度需要大于0且小于45")
	private String creater;
	
	/**
	 * createTime
	 */
	
	private java.util.Date createTime;
	
	/**
	 * 1 有效 0 无效
	 */
	@NotNull 
	private Integer status;
	
	/**
	 * 配置项值
	 */
	@Length(max=200, message="长度需要大于0且小于200")
	private String configValue;
	
	//columns END
	/*
	public CmPromotionProduct(){
	}

	public CmPromotionProduct(
		Integer id
	){
		this.id = id;
	}

    */

	/**
	 * 设置productId
	 * @param productId productId
	 */
	public void setProductId(Integer productId) {
		this.productId = productId;
	}

	/**
	 * 获取productId
	 * @return productId
	 */
	public Integer getProductId() {
		return this.productId;
	}

	/**
	 * 设置promotionId
	 * @param promotionId promotionId
	 */
	public void setPromotionId(Integer promotionId) {
		this.promotionId = promotionId;
	}

	/**
	 * 获取promotionId
	 * @return promotionId
	 */
	public Integer getPromotionId() {
		return this.promotionId;
	}

	/**
	 * 设置配置信息
	 * @param configKey 配置信息
	 */
	public void setConfigKey(String configKey) {
		this.configKey = configKey;
	}

	/**
	 * 获取配置信息
	 * @return 配置信息
	 */
	public String getConfigKey() {
		return this.configKey;
	}

	/**
	 * 设置creater
	 * @param creater creater
	 */
	public void setCreater(String creater) {
		this.creater = creater;
	}

	/**
	 * 获取creater
	 * @return creater
	 */
	public String getCreater() {
		return this.creater;
	}

	/**
	 * 设置createTime
	 * @param createTime createTime
	 */
	public void setCreateTime(java.util.Date createTime) {
		this.createTime = createTime;
	}

	/**
	 * 设置createTime字符串格式
	 * @param createTime createTime
	 */
	public void setCreateTimeStr(String createTime) {
		if (!com.house365.web.util.StringUtils.isBlank(createTime)) {
			try {
				this.createTime = java.text.DateFormat.getDateTimeInstance().parse(createTime);
			} catch (java.text.ParseException ex) {
				ex.printStackTrace();
			}
		}
	}

	/**
	 * 获取createTime
	 * @return createTime
	 */
	public java.util.Date getCreateTime() {
		return this.createTime;
	}

	/**
	 * 设置1 有效 0 无效
	 * @param status 1 有效 0 无效
	 */
	public void setStatus(Integer status) {
		this.status = status;
	}

	/**
	 * 获取1 有效 0 无效
	 * @return 1 有效 0 无效
	 */
	public Integer getStatus() {
		return this.status;
	}

	/**
	 * 设置配置项值
	 * @param configValue 配置项值
	 */
	public void setConfigValue(String configValue) {
		this.configValue = configValue;
	}

	/**
	 * 获取配置项值
	 * @return 配置项值
	 */
	public String getConfigValue() {
		return this.configValue;
	}

    /**
     * 实体的toString方法
     * @return 实体字符串
     */
	public String toString() {
		return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
			.append("Id",getId())
			.append("ProductId",getProductId())
			.append("PromotionId",getPromotionId())
			.append("ConfigKey",getConfigKey())
			.append("Creater",getCreater())
			.append("CreateTime",getCreateTime())
			.append("Status",getStatus())
			.append("ConfigValue",getConfigValue())
			.toString();
	}

	/**
	 * 获取hash码
	 * @return HASH码
	 */
	public int hashCode() {
		return new HashCodeBuilder()
			.append(getId())
			.toHashCode();
	}

	/**
	 * 对象比较
	 * @param obj 待比较对象
	 * @return 是否相同<li>true--相同<li>false--不相同
	 */
	public boolean equals(Object obj) {
		if(obj instanceof CmPromotionProductEntity == false) return false;
		if(this == obj) return true;
		CmPromotionProductEntity other = (CmPromotionProductEntity)obj;
		return new EqualsBuilder()
			.append(getId(),other.getId())
			.isEquals();
	}
}

