/**
 * Description: CmPromotionConfig数据库实体/领域对象
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2016-09-01 下午 13:46:22
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-01   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.beans.entity;

import javax.validation.constraints.*;
import com.house365.beans.system.DomainObject;
import org.hibernate.validator.constraints.*;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * CmPromotionConfig数据库实体/领域对象<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-01
 * @see
 * @since 1.0
 */
public class CmPromotionConfigEntity extends DomainObject{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	//可以直接使用: @Length(max=50,message="用户名长度不能大于50")显示错误消息
	//columns START
	/**
	 * promotionId
	 */
	@NotNull 
	private Integer promotionId;
	
	/**
	 * 配置项名称
	 */
	@NotBlank @Length(max=100, message="长度需要大于0且小于100")
	private String configName;
	
	/**
	 * 配置项类型 string 
	 */
	@NotBlank @Length(max=100, message="长度需要大于0且小于100")
	private String configType;
	
	/**
	 * description
	 */
	@Length(max=200, message="长度需要大于0且小于200")
	private String description;
	
	//columns END
	/*
	public CmPromotionConfig(){
	}

	public CmPromotionConfig(
		Integer id
	){
		this.id = id;
	}

    */

	/**
	 * 设置promotionId
	 * @param promotionId promotionId
	 */
	public void setPromotionId(Integer promotionId) {
		this.promotionId = promotionId;
	}

	/**
	 * 获取promotionId
	 * @return promotionId
	 */
	public Integer getPromotionId() {
		return this.promotionId;
	}

	/**
	 * 设置配置项名称
	 * @param configName 配置项名称
	 */
	public void setConfigName(String configName) {
		this.configName = configName;
	}

	/**
	 * 获取配置项名称
	 * @return 配置项名称
	 */
	public String getConfigName() {
		return this.configName;
	}

	/**
	 * 设置配置项类型 string 
	 * @param configType 配置项类型 string 
	 */
	public void setConfigType(String configType) {
		this.configType = configType;
	}

	/**
	 * 获取配置项类型 string 
	 * @return 配置项类型 string 
	 */
	public String getConfigType() {
		return this.configType;
	}

	/**
	 * 设置description
	 * @param description description
	 */
	public void setDescription(String description) {
		this.description = description;
	}

	/**
	 * 获取description
	 * @return description
	 */
	public String getDescription() {
		return this.description;
	}

    /**
     * 实体的toString方法
     * @return 实体字符串
     */
	public String toString() {
		return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
			.append("Id",getId())
			.append("PromotionId",getPromotionId())
			.append("ConfigName",getConfigName())
			.append("ConfigType",getConfigType())
			.append("Description",getDescription())
			.toString();
	}

	/**
	 * 获取hash码
	 * @return HASH码
	 */
	public int hashCode() {
		return new HashCodeBuilder()
			.append(getId())
			.toHashCode();
	}

	/**
	 * 对象比较
	 * @param obj 待比较对象
	 * @return 是否相同<li>true--相同<li>false--不相同
	 */
	public boolean equals(Object obj) {
		if(obj instanceof CmPromotionConfigEntity == false) return false;
		if(this == obj) return true;
		CmPromotionConfigEntity other = (CmPromotionConfigEntity)obj;
		return new EqualsBuilder()
			.append(getId(),other.getId())
			.isEquals();
	}
}

