/**
 * Description: CmPraise数据库实体/领域对象
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2015-08-10 下午 17:06:19
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-08-10   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.beans.entity;

import javax.validation.constraints.*;
import com.house365.beans.system.DomainObject;
import org.hibernate.validator.constraints.*;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * CmPraise数据库实体/领域对象<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-08-10
 * @see
 * @since 1.0
 */
public class CmPraiseEntity extends DomainObject{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	//可以直接使用: @Length(max=50,message="用户名长度不能大于50")显示错误消息
	//columns START
	/**
	 * 点赞人ID
	 */
	@NotNull 
	private Integer userId;
	
	/**
	 * 楼盘评价ID
	 */
	@NotNull 
	private Integer houseCriticId;
	
	//columns END
	/*
	public CmPraise(){
	}

	public CmPraise(
		Integer id
	){
		this.id = id;
	}

    */

	/**
	 * 设置点赞人ID
	 * @param userId 点赞人ID
	 */
	public void setUserId(Integer userId) {
		this.userId = userId;
	}

	/**
	 * 获取点赞人ID
	 * @return 点赞人ID
	 */
	public Integer getUserId() {
		return this.userId;
	}

	/**
	 * 设置楼盘评价ID
	 * @param houseCriticId 楼盘评价ID
	 */
	public void setHouseCriticId(Integer houseCriticId) {
		this.houseCriticId = houseCriticId;
	}

	/**
	 * 获取楼盘评价ID
	 * @return 楼盘评价ID
	 */
	public Integer getHouseCriticId() {
		return this.houseCriticId;
	}

    /**
     * 实体的toString方法
     * @return 实体字符串
     */
	public String toString() {
		return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
			.append("Id",getId())
			.append("UserId",getUserId())
			.append("HouseCriticId",getHouseCriticId())
			.toString();
	}

	/**
	 * 获取hash码
	 * @return HASH码
	 */
	public int hashCode() {
		return new HashCodeBuilder()
			.append(getId())
			.toHashCode();
	}

	/**
	 * 对象比较
	 * @param obj 待比较对象
	 * @return 是否相同<li>true--相同<li>false--不相同
	 */
	public boolean equals(Object obj) {
		if(obj instanceof CmPraiseEntity == false) return false;
		if(this == obj) return true;
		CmPraiseEntity other = (CmPraiseEntity)obj;
		return new EqualsBuilder()
			.append(getId(),other.getId())
			.isEquals();
	}
}

