/**
 * Description: CmInviteRecord数据库实体/领域对象
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2015-10-15 上午 09:33:17
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-10-15   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.beans.entity;

import com.house365.beans.system.DomainObject;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;

import java.util.Date;

/**
 * CmInviteRecord数据库实体/领域对象<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-10-15
 * @see
 * @since 1.0
 */
public class CmInviteRecordEntity extends DomainObject {
    /**
     *
     */
    private static final long serialVersionUID = 1L;

    //可以直接使用: @Length(max=50,message="用户名长度不能大于50")显示错误消息
    //columns START
    /**
     * 邀请人user_id
     */
    private Integer inviter;

    /**
     * 被邀请人user_id
     */
    private Integer invitedUser;

    /**
     * 邀请码
     */
    @Length(max = 50, message = "长度需要大于0且小于50")
    private String invitedCode;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新时间
     */
    private Date updateTime;


    /**
     * 设置邀请人user_id
     *
     * @param inviter 邀请人user_id
     */
    public void setInviter(Integer inviter) {
        this.inviter = inviter;
    }

    /**
     * 获取邀请人user_id
     *
     * @return 邀请人user_id
     */
    public Integer getInviter() {
        return this.inviter;
    }

    /**
     * 设置被邀请人user_id
     *
     * @param invitedUser 被邀请人user_id
     */
    public void setInvitedUser(Integer invitedUser) {
        this.invitedUser = invitedUser;
    }

    /**
     * 获取被邀请人user_id
     *
     * @return 被邀请人user_id
     */
    public Integer getInvitedUser() {
        return this.invitedUser;
    }

    /**
     * 设置邀请码
     *
     * @param invitedCode 邀请码
     */
    public void setInvitedCode(String invitedCode) {
        this.invitedCode = invitedCode;
    }

    /**
     * 获取邀请码
     *
     * @return 邀请码
     */
    public String getInvitedCode() {
        return this.invitedCode;
    }

    /**
     * 设置创建时间
     *
     * @param createTime 创建时间
     */
    public void setCreateTime(java.util.Date createTime) {
        this.createTime = createTime;
    }

    /**
     * 设置创建时间字符串格式
     *
     * @param createTime 创建时间
     */
    public void setCreateTimeStr(String createTime) {
        if (!com.house365.web.util.StringUtils.isBlank(createTime)) {
            try {
                this.createTime = java.text.DateFormat.getDateTimeInstance().parse(createTime);
            } catch (java.text.ParseException ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取创建时间
     *
     * @return 创建时间
     */
    public java.util.Date getCreateTime() {
        return this.createTime;
    }

    /**
     * 设置更新时间
     *
     * @param updateTime 更新时间
     */
    public void setUpdateTime(java.util.Date updateTime) {
        this.updateTime = updateTime;
    }

    /**
     * 设置更新时间字符串格式
     *
     * @param updateTime 更新时间
     */
    public void setUpdateTimeStr(String updateTime) {
        if (!com.house365.web.util.StringUtils.isBlank(updateTime)) {
            try {
                this.updateTime = java.text.DateFormat.getDateTimeInstance().parse(updateTime);
            } catch (java.text.ParseException ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取更新时间
     *
     * @return 更新时间
     */
    public java.util.Date getUpdateTime() {
        return this.updateTime;
    }

    /**
     * 实体的toString方法
     *
     * @return 实体字符串
     */
    @Override
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
                .append("Id", getId())
                .append("Inviter", getInviter())
                .append("InvitedUser", getInvitedUser())
                .append("InvitedCode", getInvitedCode())
                .append("CreateTime", getCreateTime())
                .append("UpdateTime", getUpdateTime())
                .toString();
    }

    /**
     * 获取hash码
     *
     * @return HASH码
     */
    @Override
    public int hashCode() {
        return new HashCodeBuilder()
                .append(getId())
                .toHashCode();
    }

    /**
     * 对象比较
     *
     * @param obj 待比较对象
     * @return 是否相同<li>true--相同<li>false--不相同
     */
    @Override
    public boolean equals(Object obj) {
        if (obj instanceof CmInviteRecordEntity == false) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        CmInviteRecordEntity other = (CmInviteRecordEntity) obj;
        return new EqualsBuilder()
                .append(getId(), other.getId())
                .isEquals();
    }
}

