/**
 * Description: CmHouseComment数据库实体/领域对象
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2015-08-10 下午 17:06:15
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-08-10   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.beans.entity;

import com.house365.beans.system.DomainObject;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;

import java.util.List;


/**
 * CmHouseComment数据库实体/领域对象<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-08-10
 * @see
 * @since 1.0
 */
public class CmHouseCommentEntity extends DomainObject {
    /**
     *
     */
    private static final long serialVersionUID = 1L;

    //可以直接使用: @Length(max=50,message="用户名长度不能大于50")显示错误消息
    //columns START
    /**
     * 楼盘编号
     */

    private Integer houseId;

    /**
     * 楼盘名称
     */
    @Length(max = 50, message = "长度需要大于0且小于50")
    private String houseName;

    /**
     * 评论者编号
     */

    private Integer criticId;

    /**
     * 评论者手机号
     */
    @Length(max = 20, message = "长度需要大于0且小于20")
    private String criticPhone;

    /**
     * 评论者姓名
     */
    @Length(max = 20, message = "长度需要大于0且小于20")
    private String criticName;

    /**
     * 评论内容
     */
    @Length(max = 500, message = "长度需要大于0且小于500")
    private String criticContent;

    /**
     * 图片集合
     */
    @Length(max = 500, message = "长度需要大于0且小于500")
    private String criticPictures;

    private List<String> picList;
    /**
     * 价格评分
     */

    private Float priceScore;
    /**
     * 地段评分
     */

    private Float placeScore;
    /**
     * 来源类型
     */
    private Integer source;
    /**
     * 交通评分
     */

    private Float trafficScore;
    /**
     * 配套评分
     */

    private Float infrastructureScore;
    /**
     * 环境评分
     */

    private Float environmentScore;
    /**
     * 平均得分
     */

    private Float averageScore;
    /**
     * 是否匿名 0:否 1:是
     */

    private Integer isAnonymous;
    /**
     * 评论日期
     */

    private java.util.Date commentDate;
    /**
     * 解禁时间
     */
    private java.util.Date activateTime;
    /**
     * 被举报次数
     */
    private Integer reportCount;
    /**
     * 赞数目
     */

    private Integer praiseAmount;
    /**
     * 评论数目
     */
    private Integer commentAmount;
    /**
     * 是否加精 0:否 1:是
     */

    private Integer isExcellent;
    /**
     * 是否置顶 0:否 1:是
     */

    private Integer isSticked;
    /**
     * 是否删除 0:否 1:是
     */

    private Integer isDeleted;
    /**
     * 是否已读 0:否 1:是
     */

    private Integer isReaded;
    /**
     * 用户头像
     */
    private String userPhoto;
    /**
     * 是否被举报
     */

    private Integer isReported;
    /**
     * 本人是否点赞 0:没有 1:点过赞
     */
    private Integer isPraised = 0;
    /**
     * 城市编号
     */

    private Integer cityId;
    /**
     * 城市名称
     */
    @Length(max = 20, message = "长度需要大于0且小于20")
    private String cityName;
    /**
     * 城市key
     */
    @Length(max = 20, message = "长度需要大于0且小于20")
    private String cityKey;
    private String commentDateStr;
    private Integer checkStatus;
    private CmHouseCommentReplyEntity managerReply;

    public List<String> getPicList() {
        return picList;
    }

    public void setPicList(List<String> picList) {
        this.picList = picList;
    }

    public Integer getReportCount() {
        return reportCount;
    }

    public void setReportCount(Integer reportCount) {
        this.reportCount = reportCount;
    }

    public java.util.Date getActivateTime() {
        return activateTime;
    }

    public void setActivateTime(java.util.Date activateTime) {
        this.activateTime = activateTime;
    }

    public Integer getIsPraised() {

        return isPraised;
    }

    public void setIsPraised(Integer isPraised) {
        this.isPraised = isPraised;
    }

    public Integer getIsReported() {
        return isReported;
    }

    public void setIsReported(Integer isReported) {
        this.isReported = isReported;
    }

    public CmHouseCommentReplyEntity getManagerReply() {
        return managerReply;
    }

    public void setManagerReply(CmHouseCommentReplyEntity managerReply) {
        this.managerReply = managerReply;
    }

    public Integer getCheckStatus() {
        return checkStatus;
    }

    public void setCheckStatus(Integer checkStatus) {
        this.checkStatus = checkStatus;
    }

    public String getCityKey() {
        return cityKey;
    }

    public void setCityKey(String cityKey) {
        this.cityKey = cityKey;
    }

    public String getUserPhoto() {
        return userPhoto;
    }

    public void setUserPhoto(String userPhoto) {
        this.userPhoto = userPhoto;
    }

    public String getCommentDateStr() {
        return commentDateStr;
    }

    /**
     * 设置评论日期字符串格式
     *
     * @param commentDate 评论日期
     */
    public void setCommentDateStr(String commentDate) {
        if (!com.house365.web.util.StringUtils.isBlank(commentDate)) {
            try {
                this.commentDate = java.text.DateFormat.getDateTimeInstance().parse(commentDate);
            } catch (java.text.ParseException ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取楼盘编号
     *
     * @return 楼盘编号
     */
    public Integer getHouseId() {
        return this.houseId;
    }

    /**
     * 设置楼盘编号
     *
     * @param houseId 楼盘编号
     */
    public void setHouseId(Integer houseId) {
        this.houseId = houseId;
    }

    /**
     * 获取楼盘名称
     *
     * @return 楼盘名称
     */
    public String getHouseName() {
        return this.houseName;
    }

    /**
     * 设置楼盘名称
     *
     * @param houseName 楼盘名称
     */
    public void setHouseName(String houseName) {
        this.houseName = houseName;
    }

    /**
     * 获取评论者编号
     *
     * @return 评论者编号
     */
    public Integer getCriticId() {
        return this.criticId;
    }

    /**
     * 设置评论者编号
     *
     * @param criticId 评论者编号
     */
    public void setCriticId(Integer criticId) {
        this.criticId = criticId;
    }

    /**
     * 获取评论者手机号
     *
     * @return 评论者手机号
     */
    public String getCriticPhone() {
        return this.criticPhone;
    }

    /**
     * 设置评论者手机号
     *
     * @param criticPhone 评论者手机号
     */
    public void setCriticPhone(String criticPhone) {
        this.criticPhone = criticPhone;
    }

    /**
     * 获取评论者姓名
     *
     * @return 评论者姓名
     */
    public String getCriticName() {
        return this.criticName;
    }

    /**
     * 设置评论者姓名
     *
     * @param criticName 评论者姓名
     */
    public void setCriticName(String criticName) {
        this.criticName = criticName;
    }

    /**
     * 获取评论内容
     *
     * @return 评论内容
     */
    public String getCriticContent() {
        return this.criticContent;
    }

    /**
     * 设置评论内容
     *
     * @param criticContent 评论内容
     */
    public void setCriticContent(String criticContent) {
        this.criticContent = criticContent;
    }

    /**
     * 获取图片集合
     *
     * @return 图片集合
     */
    public String getCriticPictures() {
        return this.criticPictures;
    }

    /**
     * 设置图片集合
     *
     * @param criticPictures 图片集合
     */
    public void setCriticPictures(String criticPictures) {
        this.criticPictures = criticPictures;
    }

    /**
     * 获取价格评分
     *
     * @return 价格评分
     */
    public Float getPriceScore() {
        return this.priceScore;
    }

    /**
     * 设置价格评分
     *
     * @param priceScore 价格评分
     */
    public void setPriceScore(Float priceScore) {
        this.priceScore = priceScore;
    }

    /**
     * 获取地段评分
     *
     * @return 地段评分
     */
    public Float getPlaceScore() {
        return this.placeScore;
    }

    /**
     * 设置地段评分
     *
     * @param placeScore 地段评分
     */
    public void setPlaceScore(Float placeScore) {
        this.placeScore = placeScore;
    }

    /**
     * 获取交通评分
     *
     * @return 交通评分
     */
    public Float getTrafficScore() {
        return this.trafficScore;
    }

    /**
     * 设置交通评分
     *
     * @param trafficScore 交通评分
     */
    public void setTrafficScore(Float trafficScore) {
        this.trafficScore = trafficScore;
    }

    /**
     * 获取配套评分
     *
     * @return 配套评分
     */
    public Float getInfrastructureScore() {
        return this.infrastructureScore;
    }

    /**
     * 设置配套评分
     *
     * @param infrastructureScore 配套评分
     */
    public void setInfrastructureScore(Float infrastructureScore) {
        this.infrastructureScore = infrastructureScore;
    }

    /**
     * 获取环境评分
     *
     * @return 环境评分
     */
    public Float getEnvironmentScore() {
        return this.environmentScore;
    }

    /**
     * 设置环境评分
     *
     * @param environmentScore 环境评分
     */
    public void setEnvironmentScore(Float environmentScore) {
        this.environmentScore = environmentScore;
    }

    /**
     * 获取平均得分
     *
     * @return 平均得分
     */
    public Float getAverageScore() {
        return this.averageScore;
    }

    /**
     * 设置平均得分
     *
     * @param averageScore 平均得分
     */
    public void setAverageScore(Float averageScore) {
        this.averageScore = averageScore;
    }

    /**
     * 获取是否匿名 0:否 1:是
     *
     * @return 是否匿名 0:否 1:是
     */
    public Integer getIsAnonymous() {
        return this.isAnonymous;
    }

    /**
     * 设置是否匿名 0:否 1:是
     *
     * @param isAnonymous 是否匿名 0:否 1:是
     */
    public void setIsAnonymous(Integer isAnonymous) {
        this.isAnonymous = isAnonymous;
    }

    /**
     * 获取评论日期
     *
     * @return 评论日期
     */
    public java.util.Date getCommentDate() {
        return this.commentDate;
    }

    /**
     * 设置评论日期
     *
     * @param commentDate 评论日期
     */
    public void setCommentDate(java.util.Date commentDate) {
        this.commentDate = commentDate;
    }

    /**
     * 获取赞数目
     *
     * @return 赞数目
     */
    public Integer getPraiseAmount() {
        return this.praiseAmount;
    }

    /**
     * 设置赞数目
     *
     * @param praiseAmount 赞数目
     */
    public void setPraiseAmount(Integer praiseAmount) {
        this.praiseAmount = praiseAmount;
    }

    /**
     * 获取评论数目
     *
     * @return 评论数目
     */
    public Integer getCommentAmount() {
        return this.commentAmount;
    }

    /**
     * 设置评论数目
     *
     * @param commentAmount 评论数目
     */
    public void setCommentAmount(Integer commentAmount) {
        this.commentAmount = commentAmount;
    }

    public Integer getSource() {
        return source;
    }

    public void setSource(Integer source) {
        this.source = source;
    }

    /**
     * 获取是否加精 0:否 1:是
     *
     * @return 是否加精 0:否 1:是
     */
    public Integer getIsExcellent() {
        if (isExcellent == null) {
            isExcellent = 0;
        }
        return this.isExcellent;
    }

    /**
     * 设置是否加精 0:否 1:是
     *
     * @param isExcellent 是否加精 0:否 1:是
     */
    public void setIsExcellent(Integer isExcellent) {
        this.isExcellent = isExcellent;
    }

    /**
     * 获取是否置顶 0:否 1:是
     *
     * @return 是否置顶 0:否 1:是
     */
    public Integer getIsSticked() {
        return this.isSticked;
    }

    /**
     * 设置是否置顶 0:否 1:是
     *
     * @param isSticked 是否置顶 0:否 1:是
     */
    public void setIsSticked(Integer isSticked) {
        this.isSticked = isSticked;
    }

    /**
     * 获取是否删除 0:否 1:是(列表页面上暂时用作禁言剩余小时)
     *
     * @return 是否删除 0:否 1:是
     */
    public Integer getIsDeleted() {
        return this.isDeleted;
    }

    /**
     * 设置是否删除 0:否 1:是
     *
     * @param isDeleted 是否删除 0:否 1:是
     */
    public void setIsDeleted(Integer isDeleted) {
        this.isDeleted = isDeleted;
    }

    /**
     * 获取是否已读 0:否 1:是
     *
     * @return 是否已读 0:否 1:是
     */
    public Integer getIsReaded() {
        return this.isReaded;
    }

    /**
     * 设置是否已读 0:否 1:是
     *
     * @param isReaded 是否已读 0:否 1:是
     */
    public void setIsReaded(Integer isReaded) {
        this.isReaded = isReaded;
    }

    /**
     * 获取城市编号
     *
     * @return 城市编号
     */
    public Integer getCityId() {
        return this.cityId;
    }

    /**
     * 设置城市编号 (列表页面上暂时用作禁言剩余分钟)
     *
     * @param cityId 城市编号
     */
    public void setCityId(Integer cityId) {
        this.cityId = cityId;
    }

    /**
     * 获取城市名称
     *
     * @return 城市名称
     */
    public String getCityName() {
        return this.cityName;
    }

    /**
     * 设置城市名称
     *
     * @param cityName 城市名称
     */
    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    /**
     * 实体的toString方法
     *
     * @return 实体字符串
     */
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE).append("Id", getId()).append("HouseId",
                                                                                                      getHouseId()).append(
            "HouseName", getHouseName()).append("CriticId", getCriticId()).append("CriticPhone",
                                                                                  getCriticPhone()).append("CriticName",
                                                                                                           getCriticName()).append(
            "CriticContent", getCriticContent()).append("CriticPictures", getCriticPictures()).append("PriceScore",
                                                                                                      getPriceScore()).append(
            "PlaceScore", getPlaceScore()).append("TrafficScore", getTrafficScore()).append("InfrastructureScore",
                                                                                            getInfrastructureScore()).append(
            "EnvironmentScore", getEnvironmentScore()).append("AverageScore", getAverageScore()).append("IsAnonymous",
                                                                                                        getIsAnonymous()).append(
            "CommentDate", getCommentDate()).append("PraiseAmount", getPraiseAmount()).append("CommentAmount",
                                                                                              getCommentAmount()).append(
            "IsExcellent", getIsExcellent()).append("IsSticked", getIsSticked()).append("IsDeleted",
                                                                                        getIsDeleted()).append(
            "IsReaded", getIsReaded()).append("CityId", getCityId()).append("CityName", getCityName()).toString();
    }

    /**
     * 获取hash码
     *
     * @return HASH码
     */
    public int hashCode() {
        return new HashCodeBuilder().append(getId()).toHashCode();
    }

    /**
     * 对象比较
     *
     * @param obj 待比较对象
     * @return 是否相同<li>true--相同<li>false--不相同
     */
    public boolean equals(Object obj) {
        if (obj instanceof CmHouseCommentEntity == false)
            return false;
        if (this == obj)
            return true;
        CmHouseCommentEntity other = (CmHouseCommentEntity) obj;
        return new EqualsBuilder().append(getId(), other.getId()).isEquals();
    }
}

