/**
 * Description: CmCreditRule数据库实体/领域对象
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2015-08-10 下午 17:06:11
 * <p/>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-08-10   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.beans.entity;

import javax.validation.constraints.*;

import com.house365.beans.system.DomainObject;
import org.hibernate.validator.constraints.*;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.util.Date;

/**
 * CmCreditRule数据库实体/领域对象<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-08-10
 * @see
 * @since 1.0
 */
public class CmCreditRuleEntity extends DomainObject {
    /**
     *
     */
    private static final long serialVersionUID = 1L;

    //可以直接使用: @Length(max=50,message="用户名长度不能大于50")显示错误消息
    //columns START
    /**
     * 积分数量
     */

    private Integer credits;

    /**
     * 积分规则名称
     */
    @Length(max = 100, message = "长度需要大于0且小于100")
    private String creditRuleName;

    /**
     * 计数周期(0:不限
     */

    private Integer countCircle;

    /**
     * 计数上限
     */

    private Integer countLimit;

    /**
     * 所属城市
     */

    private Integer cityId;

    /**
     * 所属城市名称
     */
    @Length(max = 100, message = "长度需要大于0且小于100")
    private String cityName;

    /**
     * 积分规则说明
     */
    //@Length(max=500, message="长度需要大于0且小于500")
    private String description;

    /**
     * 创建时间
     */

    private Date createTime;

    /**
     * 更新时间
     */

    private Date updateTime;

    /**
     * 有效期限
     */

    private Integer expire;

    /**
     * 是否显示
     */
    private Integer isShow;

    private Date activeStartTime;

    private Date activeEndTime;

    private Float activeWeight;

    //columns END
    /*
	public CmCreditRule(){
	}

	public CmCreditRule(
		Integer id
	){
		this.id = id;
	}

    */

    public Date getActiveStartTime() {
        return activeStartTime;
    }

    public void setActiveStartTime(Date activeStartTime) {
        this.activeStartTime = activeStartTime;
    }

    public Date getActiveEndTime() {
        return activeEndTime;
    }

    public void setActiveEndTime(Date activeEndTime) {
        this.activeEndTime = activeEndTime;
    }

    public Float getActiveWeight() {
        return activeWeight;
    }

    public void setActiveWeight(Float activeWeight) {
        this.activeWeight = activeWeight;
    }

    /**
     * 设置积分数量
     * @param credits 积分数量
     */
    public void setCredits(Integer credits) {
        this.credits = credits;
    }

    public Integer getIsShow() {
        return isShow;
    }

    public void setIsShow(Integer isShow) {
        this.isShow = isShow;
    }

    /**
     * 获取积分数量
     * @return 积分数量
     */
    public Integer getCredits() {
        return this.credits;
    }

    /**
     * 设置积分规则名称
     * @param creditRuleName 积分规则名称
     */
    public void setCreditRuleName(String creditRuleName) {
        this.creditRuleName = creditRuleName;
    }

    /**
     * 获取积分规则名称
     * @return 积分规则名称
     */
    public String getCreditRuleName() {
        return this.creditRuleName;
    }

    /**
     * 设置计数周期(0:不限
     * @param countCircle 计数周期(0:不限
     */
    public void setCountCircle(Integer countCircle) {
        this.countCircle = countCircle;
    }

    /**
     * 获取计数周期(0:不限
     * @return 计数周期(0:不限
     */
    public Integer getCountCircle() {
        return this.countCircle;
    }

    /**
     * 设置计数上限
     * @param countLimit 计数上限
     */
    public void setCountLimit(Integer countLimit) {
        this.countLimit = countLimit;
    }

    /**
     * 获取计数上限
     * @return 计数上限
     */
    public Integer getCountLimit() {
        return this.countLimit;
    }

    /**
     * 设置所属城市
     * @param cityId 所属城市
     */
    public void setCityId(Integer cityId) {
        this.cityId = cityId;
    }

    /**
     * 获取所属城市
     * @return 所属城市
     */
    public Integer getCityId() {
        return this.cityId;
    }

    /**
     * 设置所属城市名称
     * @param cityName 所属城市名称
     */
    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    /**
     * 获取所属城市名称
     * @return 所属城市名称
     */
    public String getCityName() {
        return this.cityName;
    }

    /**
     * 设置积分规则说明
     * @param description 积分规则说明
     */
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * 获取积分规则说明
     * @return 积分规则说明
     */
    public String getDescription() {
        return this.description;
    }

    /**
     * 设置创建时间
     * @param createTime 创建时间
     */
    public void setCreateTime(java.util.Date createTime) {
        this.createTime = createTime;
    }

    /**
     * 设置创建时间字符串格式
     * @param createTime 创建时间
     */
    public void setCreateTimeStr(String createTime) {
        if (!com.house365.web.util.StringUtils.isBlank(createTime)) {
            try {
                this.createTime = java.text.DateFormat.getDateTimeInstance().parse(createTime);
            } catch (java.text.ParseException ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取创建时间
     * @return 创建时间
     */
    public java.util.Date getCreateTime() {
        return this.createTime;
    }

    /**
     * 设置更新时间
     * @param updateTime 更新时间
     */
    public void setUpdateTime(java.util.Date updateTime) {
        this.updateTime = updateTime;
    }

    /**
     * 设置更新时间字符串格式
     * @param updateTime 更新时间
     */
    public void setUpdateTimeStr(String updateTime) {
        if (!com.house365.web.util.StringUtils.isBlank(updateTime)) {
            try {
                this.updateTime = java.text.DateFormat.getDateTimeInstance().parse(updateTime);
            } catch (java.text.ParseException ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取更新时间
     * @return 更新时间
     */
    public java.util.Date getUpdateTime() {
        return this.updateTime;
    }

    /**
     * 设置有效期限
     * @param expire 有效期限
     */
    public void setExpire(Integer expire) {
        this.expire = expire;
    }

    /**
     * 获取有效期限
     * @return 有效期限
     */
    public Integer getExpire() {
        return this.expire;
    }

    /**
     * 实体的toString方法
     * @return 实体字符串
     */
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
                .append("Id", getId())
                .append("Credits", getCredits())
                .append("CreditRuleName", getCreditRuleName())
                .append("CountCircle", getCountCircle())
                .append("CountLimit", getCountLimit())
                .append("CityId", getCityId())
                .append("CityName", getCityName())
                .append("Description", getDescription())
                .append("CreateTime", getCreateTime())
                .append("UpdateTime", getUpdateTime())
                .append("Expire", getExpire())
                .toString();
    }

    /**
     * 获取hash码
     * @return HASH码
     */
    public int hashCode() {
        return new HashCodeBuilder()
                .append(getId())
                .toHashCode();
    }

    /**
     * 对象比较
     * @param obj 待比较对象
     * @return 是否相同<li>true--相同<li>false--不相同
     */
    public boolean equals(Object obj) {
        if (obj instanceof CmCreditRuleEntity == false) return false;
        if (this == obj) return true;
        CmCreditRuleEntity other = (CmCreditRuleEntity) obj;
        return new EqualsBuilder()
                .append(getId(), other.getId())
                .isEquals();
    }
}

