/**
 * Description: 只包含楼盘和经纪人评论删除后的扣分数据库实体/领域对象
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2015-08-10 下午 17:06:10
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-08-10   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.beans.entity;

import javax.validation.constraints.*;
import com.house365.beans.system.DomainObject;
import org.hibernate.validator.constraints.*;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * 只包含楼盘和经纪人评论删除后的扣分数据库实体/领域对象<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-08-10
 * @see
 * @since 1.0
 */
public class CmCreditRemoveRecordEntity extends DomainObject{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	//可以直接使用: @Length(max=50,message="用户名长度不能大于50")显示错误消息
	//columns START
	/**
	 * 用户id
	 */
	
	private Integer userId;
	
	/**
	 * 用户手机号
	 */
	@Length(max=20, message="长度需要大于0且小于20")
	private String userPhone;
	
	/**
	 * 积分类型 0:楼盘评论 1:经纪人评论
	 */
	
	private Integer type;
	
	/**
	 * 积分数量
	 */
	
	private Integer amount;
	
	/**
	 * 积分余额
	 */
	
	private Integer remainingAmount;
	
	/**
	 * 评论编号
	 */
	
	private Integer criticId;
	
	/**
	 * 评论内容
	 */
	@Length(max=500, message="长度需要大于0且小于500")
	private String criticContent;
	
	/**
	 * 操作人员编号
	 */
	
	private Integer operatorId;
	
	/**
	 * 操作人员名称
	 */
	@Length(max=20, message="长度需要大于0且小于20")
	private String operatorName;
	
	/**
	 * 发生时间
	 */
	
	private java.util.Date happenTime;
	
	/**
	 * 城市编号
	 */
	
	private Integer cityId;
	
	/**
	 * 城市名称
	 */
	@Length(max=20, message="长度需要大于0且小于20")
	private String cityName;
	
	//columns END
	/*
	public CmCreditRemoveRecord(){
	}

	public CmCreditRemoveRecord(
		Integer id
	){
		this.id = id;
	}

    */

	/**
	 * 设置用户id
	 * @param userId 用户id
	 */
	public void setUserId(Integer userId) {
		this.userId = userId;
	}

	/**
	 * 获取用户id
	 * @return 用户id
	 */
	public Integer getUserId() {
		return this.userId;
	}

	/**
	 * 设置用户手机号
	 * @param userPhone 用户手机号
	 */
	public void setUserPhone(String userPhone) {
		this.userPhone = userPhone;
	}

	/**
	 * 获取用户手机号
	 * @return 用户手机号
	 */
	public String getUserPhone() {
		return this.userPhone;
	}

	/**
	 * 设置积分类型 0:楼盘评论 1:经纪人评论
	 * @param type 积分类型 0:楼盘评论 1:经纪人评论
	 */
	public void setType(Integer type) {
		this.type = type;
	}

	/**
	 * 获取积分类型 0:楼盘评论 1:经纪人评论
	 * @return 积分类型 0:楼盘评论 1:经纪人评论
	 */
	public Integer getType() {
		return this.type;
	}

	/**
	 * 设置积分数量
	 * @param amount 积分数量
	 */
	public void setAmount(Integer amount) {
		this.amount = amount;
	}

	/**
	 * 获取积分数量
	 * @return 积分数量
	 */
	public Integer getAmount() {
		return this.amount;
	}

	/**
	 * 设置积分余额
	 * @param remainingAmount 积分余额
	 */
	public void setRemainingAmount(Integer remainingAmount) {
		this.remainingAmount = remainingAmount;
	}

	/**
	 * 获取积分余额
	 * @return 积分余额
	 */
	public Integer getRemainingAmount() {
		return this.remainingAmount;
	}

	/**
	 * 设置评论编号
	 * @param criticId 评论编号
	 */
	public void setCriticId(Integer criticId) {
		this.criticId = criticId;
	}

	/**
	 * 获取评论编号
	 * @return 评论编号
	 */
	public Integer getCriticId() {
		return this.criticId;
	}

	/**
	 * 设置评论内容
	 * @param criticContent 评论内容
	 */
	public void setCriticContent(String criticContent) {
		this.criticContent = criticContent;
	}

	/**
	 * 获取评论内容
	 * @return 评论内容
	 */
	public String getCriticContent() {
		return this.criticContent;
	}

	/**
	 * 设置操作人员编号
	 * @param operatorId 操作人员编号
	 */
	public void setOperatorId(Integer operatorId) {
		this.operatorId = operatorId;
	}

	/**
	 * 获取操作人员编号
	 * @return 操作人员编号
	 */
	public Integer getOperatorId() {
		return this.operatorId;
	}

	/**
	 * 设置操作人员名称
	 * @param operatorName 操作人员名称
	 */
	public void setOperatorName(String operatorName) {
		this.operatorName = operatorName;
	}

	/**
	 * 获取操作人员名称
	 * @return 操作人员名称
	 */
	public String getOperatorName() {
		return this.operatorName;
	}

	/**
	 * 设置发生时间
	 * @param happenTime 发生时间
	 */
	public void setHappenTime(java.util.Date happenTime) {
		this.happenTime = happenTime;
	}

	/**
	 * 设置发生时间字符串格式
	 * @param happenTime 发生时间
	 */
	public void setHappenTimeStr(String happenTime) {
		if (!com.house365.web.util.StringUtils.isBlank(happenTime)) {
			try {
				this.happenTime = java.text.DateFormat.getDateTimeInstance().parse(happenTime);
			} catch (java.text.ParseException ex) {
				ex.printStackTrace();
			}
		}
	}

	/**
	 * 获取发生时间
	 * @return 发生时间
	 */
	public java.util.Date getHappenTime() {
		return this.happenTime;
	}

	/**
	 * 设置城市编号
	 * @param cityId 城市编号
	 */
	public void setCityId(Integer cityId) {
		this.cityId = cityId;
	}

	/**
	 * 获取城市编号
	 * @return 城市编号
	 */
	public Integer getCityId() {
		return this.cityId;
	}

	/**
	 * 设置城市名称
	 * @param cityName 城市名称
	 */
	public void setCityName(String cityName) {
		this.cityName = cityName;
	}

	/**
	 * 获取城市名称
	 * @return 城市名称
	 */
	public String getCityName() {
		return this.cityName;
	}

    /**
     * 实体的toString方法
     * @return 实体字符串
     */
	public String toString() {
		return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
			.append("Id",getId())
			.append("UserId",getUserId())
			.append("UserPhone",getUserPhone())
			.append("Type",getType())
			.append("Amount",getAmount())
			.append("RemainingAmount",getRemainingAmount())
			.append("CriticId",getCriticId())
			.append("CriticContent",getCriticContent())
			.append("OperatorId",getOperatorId())
			.append("OperatorName",getOperatorName())
			.append("HappenTime",getHappenTime())
			.append("CityId",getCityId())
			.append("CityName",getCityName())
			.toString();
	}

	/**
	 * 获取hash码
	 * @return HASH码
	 */
	public int hashCode() {
		return new HashCodeBuilder()
			.append(getId())
			.toHashCode();
	}

	/**
	 * 对象比较
	 * @param obj 待比较对象
	 * @return 是否相同<li>true--相同<li>false--不相同
	 */
	public boolean equals(Object obj) {
		if(obj instanceof CmCreditRemoveRecordEntity == false) return false;
		if(this == obj) return true;
		CmCreditRemoveRecordEntity other = (CmCreditRemoveRecordEntity)obj;
		return new EqualsBuilder()
			.append(getId(),other.getId())
			.isEquals();
	}
}

